/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.util;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.jsf.facesconfig.FacesConfigPlugin;
import org.eclipse.jst.jsf.facesconfig.emf.FacesConfigType;
import org.eclipse.jst.jsf.facesconfig.util.FacesConfigResourceFactory;
import org.eclipse.jst.jsf.facesconfig.util.IFacesConfigResource;
import org.eclipse.wst.common.componentcore.ArtifactEdit;
import org.eclipse.wst.common.componentcore.internal.ArtifactEditModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualFile;
import org.eclipse.wst.common.componentcore.resources.IVirtualResource;
import org.eclipse.wst.xml.core.internal.emf2xml.EMF2DOMSSERenderer;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public final class FacesConfigArtifactEdit
extends ArtifactEdit {
    private static final String EDIT_MODEL_ID = "jsf.facesconfig";
    private String sFileName = null;
    private FacesConfigType facesConfig = null;
    private URI facesConfigURI = URI.createURI((String)"WEB-INF/faces-config.xml");
    private boolean bRegistered = false;

    public FacesConfigArtifactEdit(IProject aProject, boolean toAccessAsReadOnly) throws IllegalArgumentException {
        super(aProject, toAccessAsReadOnly, false, EDIT_MODEL_ID);
    }

    public static FacesConfigArtifactEdit getFacesConfigArtifactEditForRead(IProject aProject, String sConfigFile) {
        FacesConfigArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new FacesConfigArtifactEdit(aProject, true);
            if (artifactEdit != null) {
                artifactEdit.setFilename(sConfigFile);
            }
        }
        catch (IllegalArgumentException iae) {
            FacesConfigPlugin.write(iae);
        }
        return artifactEdit;
    }

    public static FacesConfigArtifactEdit getFacesConfigArtifactEditForRead(IProject aProject) {
        return FacesConfigArtifactEdit.getFacesConfigArtifactEditForRead(aProject, null);
    }

    public static FacesConfigArtifactEdit getFacesConfigArtifactEditForWrite(IProject aProject, String sConfigFile) {
        FacesConfigArtifactEdit artifactEdit = null;
        try {
            artifactEdit = new FacesConfigArtifactEdit(aProject, false);
            if (artifactEdit != null) {
                artifactEdit.setFilename(sConfigFile);
            }
        }
        catch (IllegalArgumentException iae) {
            FacesConfigPlugin.write(iae);
        }
        return artifactEdit;
    }

    public static FacesConfigArtifactEdit getFacesConfigArtifactEditForWrite(IProject aProject) {
        return FacesConfigArtifactEdit.getFacesConfigArtifactEditForWrite(aProject, null);
    }

    public FacesConfigType getFacesConfig() {
        if (this.facesConfig == null) {
            if (this.sFileName != null && !this.bRegistered) {
                FacesConfigResourceFactory.register(this.sFileName);
                this.bRegistered = true;
            }
            this.facesConfig = (FacesConfigType)this.getDeploymentDescriptorRoot();
        }
        return this.facesConfig;
    }

    public URI getFacesConfigURI() {
        return this.facesConfigURI;
    }

    public EObject getDeploymentDescriptorRoot() {
        EList contents;
        Resource deploymentDescriptorResource = this.getDeploymentDescriptorResource();
        if (deploymentDescriptorResource != null && (contents = deploymentDescriptorResource.getContents()).size() > 0) {
            return (EObject)contents.get(0);
        }
        return null;
    }

    public Resource getDeploymentDescriptorResource() {
        this.facesConfigURI = this.sFileName != null ? URI.createURI((String)this.sFileName) : URI.createURI((String)"WEB-INF/faces-config.xml");
        ArtifactEditModel artifactEditModel = this.getArtifactEditModel();
        if (artifactEditModel != null) {
            return artifactEditModel.getResource(this.facesConfigURI);
        }
        return null;
    }

    public void setFilename(String filename) {
        this.sFileName = filename;
        if (filename != null && filename.length() > 0) {
            this.facesConfigURI = URI.createURI((String)filename);
        }
    }

    public IDOMModel getIDOMModel() {
        Resource resource = this.getDeploymentDescriptorResource();
        if (resource instanceof IFacesConfigResource) {
            EMF2DOMSSERenderer renderer = (EMF2DOMSSERenderer)((IFacesConfigResource)resource).getRenderer();
            return renderer.getXMLModel();
        }
        return null;
    }

    public IFile getFile() {
        IVirtualResource resource = this.getComponent().getRootFolder().findMember(this.facesConfigURI.toString());
        if (resource != null && resource.getType() == 16) {
            return ((IVirtualFile)resource).getUnderlyingFile();
        }
        return null;
    }

    public boolean isDisposed() {
        return this.getArtifactEditModel().isDisposed();
    }
}

