/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.generation.files;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.java.ASTNode;
import org.eclipse.modisco.java.AbstractMethodDeclaration;
import org.eclipse.modisco.java.AbstractMethodInvocation;
import org.eclipse.modisco.java.AbstractTypeDeclaration;
import org.eclipse.modisco.java.AbstractTypeQualifiedExpression;
import org.eclipse.modisco.java.AbstractVariablesContainer;
import org.eclipse.modisco.java.Annotation;
import org.eclipse.modisco.java.AnnotationMemberValuePair;
import org.eclipse.modisco.java.AnnotationTypeDeclaration;
import org.eclipse.modisco.java.AnnotationTypeMemberDeclaration;
import org.eclipse.modisco.java.AnonymousClassDeclaration;
import org.eclipse.modisco.java.Archive;
import org.eclipse.modisco.java.ArrayAccess;
import org.eclipse.modisco.java.ArrayCreation;
import org.eclipse.modisco.java.ArrayInitializer;
import org.eclipse.modisco.java.ArrayLengthAccess;
import org.eclipse.modisco.java.ArrayType;
import org.eclipse.modisco.java.AssertStatement;
import org.eclipse.modisco.java.Assignment;
import org.eclipse.modisco.java.Block;
import org.eclipse.modisco.java.BlockComment;
import org.eclipse.modisco.java.BodyDeclaration;
import org.eclipse.modisco.java.BooleanLiteral;
import org.eclipse.modisco.java.BreakStatement;
import org.eclipse.modisco.java.CastExpression;
import org.eclipse.modisco.java.CatchClause;
import org.eclipse.modisco.java.CharacterLiteral;
import org.eclipse.modisco.java.ClassDeclaration;
import org.eclipse.modisco.java.ClassFile;
import org.eclipse.modisco.java.ClassInstanceCreation;
import org.eclipse.modisco.java.Comment;
import org.eclipse.modisco.java.CompilationUnit;
import org.eclipse.modisco.java.ConditionalExpression;
import org.eclipse.modisco.java.ConstructorInvocation;
import org.eclipse.modisco.java.ContinueStatement;
import org.eclipse.modisco.java.DoStatement;
import org.eclipse.modisco.java.EmptyStatement;
import org.eclipse.modisco.java.EnhancedForStatement;
import org.eclipse.modisco.java.EnumConstantDeclaration;
import org.eclipse.modisco.java.EnumDeclaration;
import org.eclipse.modisco.java.Expression;
import org.eclipse.modisco.java.ExpressionStatement;
import org.eclipse.modisco.java.FieldAccess;
import org.eclipse.modisco.java.FieldDeclaration;
import org.eclipse.modisco.java.ForStatement;
import org.eclipse.modisco.java.IfStatement;
import org.eclipse.modisco.java.ImportDeclaration;
import org.eclipse.modisco.java.InfixExpression;
import org.eclipse.modisco.java.InheritanceKind;
import org.eclipse.modisco.java.Initializer;
import org.eclipse.modisco.java.InstanceofExpression;
import org.eclipse.modisco.java.InterfaceDeclaration;
import org.eclipse.modisco.java.Javadoc;
import org.eclipse.modisco.java.LabeledStatement;
import org.eclipse.modisco.java.LineComment;
import org.eclipse.modisco.java.Manifest;
import org.eclipse.modisco.java.ManifestAttribute;
import org.eclipse.modisco.java.ManifestEntry;
import org.eclipse.modisco.java.MemberRef;
import org.eclipse.modisco.java.MethodDeclaration;
import org.eclipse.modisco.java.MethodInvocation;
import org.eclipse.modisco.java.MethodRef;
import org.eclipse.modisco.java.MethodRefParameter;
import org.eclipse.modisco.java.Model;
import org.eclipse.modisco.java.Modifier;
import org.eclipse.modisco.java.NamedElement;
import org.eclipse.modisco.java.NamespaceAccess;
import org.eclipse.modisco.java.NullLiteral;
import org.eclipse.modisco.java.NumberLiteral;
import org.eclipse.modisco.java.Package;
import org.eclipse.modisco.java.PackageAccess;
import org.eclipse.modisco.java.ParameterizedType;
import org.eclipse.modisco.java.ParenthesizedExpression;
import org.eclipse.modisco.java.PostfixExpression;
import org.eclipse.modisco.java.PrefixExpression;
import org.eclipse.modisco.java.PrimitiveType;
import org.eclipse.modisco.java.PrimitiveTypeBoolean;
import org.eclipse.modisco.java.PrimitiveTypeByte;
import org.eclipse.modisco.java.PrimitiveTypeChar;
import org.eclipse.modisco.java.PrimitiveTypeDouble;
import org.eclipse.modisco.java.PrimitiveTypeFloat;
import org.eclipse.modisco.java.PrimitiveTypeInt;
import org.eclipse.modisco.java.PrimitiveTypeLong;
import org.eclipse.modisco.java.PrimitiveTypeShort;
import org.eclipse.modisco.java.PrimitiveTypeVoid;
import org.eclipse.modisco.java.ReturnStatement;
import org.eclipse.modisco.java.SingleVariableAccess;
import org.eclipse.modisco.java.SingleVariableDeclaration;
import org.eclipse.modisco.java.Statement;
import org.eclipse.modisco.java.StringLiteral;
import org.eclipse.modisco.java.SuperConstructorInvocation;
import org.eclipse.modisco.java.SuperFieldAccess;
import org.eclipse.modisco.java.SuperMethodInvocation;
import org.eclipse.modisco.java.SwitchCase;
import org.eclipse.modisco.java.SwitchStatement;
import org.eclipse.modisco.java.SynchronizedStatement;
import org.eclipse.modisco.java.TagElement;
import org.eclipse.modisco.java.TextElement;
import org.eclipse.modisco.java.ThisExpression;
import org.eclipse.modisco.java.ThrowStatement;
import org.eclipse.modisco.java.TryStatement;
import org.eclipse.modisco.java.Type;
import org.eclipse.modisco.java.TypeAccess;
import org.eclipse.modisco.java.TypeDeclaration;
import org.eclipse.modisco.java.TypeDeclarationStatement;
import org.eclipse.modisco.java.TypeLiteral;
import org.eclipse.modisco.java.TypeParameter;
import org.eclipse.modisco.java.UnresolvedAnnotationDeclaration;
import org.eclipse.modisco.java.UnresolvedAnnotationTypeMemberDeclaration;
import org.eclipse.modisco.java.UnresolvedClassDeclaration;
import org.eclipse.modisco.java.UnresolvedEnumDeclaration;
import org.eclipse.modisco.java.UnresolvedInterfaceDeclaration;
import org.eclipse.modisco.java.UnresolvedItem;
import org.eclipse.modisco.java.UnresolvedItemAccess;
import org.eclipse.modisco.java.UnresolvedLabeledStatement;
import org.eclipse.modisco.java.UnresolvedMethodDeclaration;
import org.eclipse.modisco.java.UnresolvedSingleVariableDeclaration;
import org.eclipse.modisco.java.UnresolvedType;
import org.eclipse.modisco.java.UnresolvedTypeDeclaration;
import org.eclipse.modisco.java.VariableDeclaration;
import org.eclipse.modisco.java.VariableDeclarationExpression;
import org.eclipse.modisco.java.VariableDeclarationFragment;
import org.eclipse.modisco.java.VariableDeclarationStatement;
import org.eclipse.modisco.java.VisibilityKind;
import org.eclipse.modisco.java.WhileStatement;
import org.eclipse.modisco.java.WildCardType;
import org.eclipse.modisco.java.generation.files.JavaModel2JavaTextUtils;

public class JavaModel2JavaTextSwitch
extends JavaModel2JavaTextUtils {
    protected final String absoluteOutputPath;

    public JavaModel2JavaTextSwitch(String absoluteOutputPath) {
        this.absoluteOutputPath = absoluteOutputPath;
    }

    public Object caseASTNode(ASTNode jASTNode) {
        return this.errorCase((EObject)jASTNode);
    }

    public Object caseAbstractMethodDeclaration(AbstractMethodDeclaration jAbstractMethodDeclaration) {
        this.wc((ASTNode)jAbstractMethodDeclaration);
        this.appendNodes((List<? extends ASTNode>)jAbstractMethodDeclaration.getAnnotations());
        this.appendModifier(jAbstractMethodDeclaration.getModifier());
        this.appendOptionalWrappedNodes("<", (List<? extends ASTNode>)jAbstractMethodDeclaration.getTypeParameters(), ", ", "> ");
        if (jAbstractMethodDeclaration instanceof MethodDeclaration) {
            TypeAccess returnType = ((MethodDeclaration)jAbstractMethodDeclaration).getReturnType();
            if (returnType != null) {
                this.appendNode((EObject)returnType);
            } else {
                this.append("void");
            }
            this.append(" ");
        }
        this.append(jAbstractMethodDeclaration.getName());
        this.appendWrappedNodes("(", (List<? extends ASTNode>)jAbstractMethodDeclaration.getParameters(), ", ", ")");
        this.appendOptionalWrappedNodes(" throws ", (List<? extends ASTNode>)jAbstractMethodDeclaration.getThrownExceptions(), ",", null);
        if (jAbstractMethodDeclaration.getBody() != null) {
            this.appendNode((EObject)jAbstractMethodDeclaration.getBody());
        } else {
            this.append(";");
        }
        this.wca((ASTNode)jAbstractMethodDeclaration);
        this.appendSoftNewLine();
        return this;
    }

    public Object caseAbstractMethodInvocation(AbstractMethodInvocation jAbstractMethodInvocation) {
        return this.errorCase((EObject)jAbstractMethodInvocation);
    }

    public Object caseAbstractTypeDeclaration(AbstractTypeDeclaration jAbstractTypeDeclaration) {
        return this.errorCase((EObject)jAbstractTypeDeclaration);
    }

    public Object caseAbstractTypeQualifiedExpression(AbstractTypeQualifiedExpression jAbstractTypeQualifiedExpression) {
        return this.errorCase((EObject)jAbstractTypeQualifiedExpression);
    }

    public Object caseAbstractVariablesContainer(AbstractVariablesContainer jAbstractVariablesContainer) {
        return this.errorCase((EObject)jAbstractVariablesContainer);
    }

    public Object caseAnnotation(Annotation jAnnotation) {
        this.wc((ASTNode)jAnnotation);
        this.append("@");
        this.appendNode((EObject)jAnnotation.getType());
        this.appendOptionalWrappedNodes("(", (List<? extends ASTNode>)jAnnotation.getValues(), ", ", ")");
        this.wca((ASTNode)jAnnotation);
        this.append("\n");
        return this;
    }

    public Object caseAnnotationMemberValuePair(AnnotationMemberValuePair jAnnotationMemberValuePair) {
        this.wc((ASTNode)jAnnotationMemberValuePair);
        AnnotationTypeMemberDeclaration jMember = jAnnotationMemberValuePair.getMember();
        if (jMember != null) {
            this.append(jMember.getName());
            this.append(" = ");
        }
        this.appendNode((EObject)jAnnotationMemberValuePair.getValue());
        this.wca((ASTNode)jAnnotationMemberValuePair);
        return this;
    }

    public Object caseAnnotationTypeDeclaration(AnnotationTypeDeclaration jAnnotationTypeDeclaration) {
        this.wc((ASTNode)jAnnotationTypeDeclaration);
        this.appendNodes((List<? extends ASTNode>)jAnnotationTypeDeclaration.getAnnotations());
        this.appendModifier(jAnnotationTypeDeclaration.getModifier());
        this.appendJavaKeyword((AbstractTypeDeclaration)jAnnotationTypeDeclaration);
        this.append(" ");
        this.append(jAnnotationTypeDeclaration.getName());
        this.append(" {");
        this.pushIndentation();
        this.append("\n");
        for (BodyDeclaration jBodyDeclaration : jAnnotationTypeDeclaration.getBodyDeclarations()) {
            if (jBodyDeclaration.isProxy()) continue;
            this.appendNode((EObject)jBodyDeclaration);
        }
        this.wci((ASTNode)jAnnotationTypeDeclaration);
        this.popIndentation();
        this.append("}");
        this.wca((ASTNode)jAnnotationTypeDeclaration);
        return this;
    }

    public Object caseAnnotationTypeMemberDeclaration(AnnotationTypeMemberDeclaration jAnnotationTypeMemberDeclaration) {
        this.wc((ASTNode)jAnnotationTypeMemberDeclaration);
        this.appendNodes((List<? extends ASTNode>)jAnnotationTypeMemberDeclaration.getAnnotations());
        this.appendModifier(jAnnotationTypeMemberDeclaration.getModifier());
        this.appendWrappedNode(null, (ASTNode)jAnnotationTypeMemberDeclaration.getType(), " ");
        this.append(jAnnotationTypeMemberDeclaration.getName());
        this.append("()");
        this.appendWrappedNode(" default ", (ASTNode)jAnnotationTypeMemberDeclaration.getDefault(), null);
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jAnnotationTypeMemberDeclaration);
        return this;
    }

    public Object caseAnonymousClassDeclaration(AnonymousClassDeclaration jAnonymousClassDeclaration) {
        this.wc((ASTNode)jAnonymousClassDeclaration);
        this.appendSoftSpace();
        this.append("{");
        this.pushIndentation();
        this.append("\n");
        for (BodyDeclaration jBodyDeclaration : jAnonymousClassDeclaration.getBodyDeclarations()) {
            if (jBodyDeclaration.isProxy()) continue;
            this.appendNode((EObject)jBodyDeclaration);
        }
        this.wci((ASTNode)jAnonymousClassDeclaration);
        this.popIndentation();
        this.append("}");
        this.wca((ASTNode)jAnonymousClassDeclaration);
        return this;
    }

    public Object caseArchive(Archive jArchive) {
        return this.errorCase((EObject)jArchive);
    }

    public Object caseArrayAccess(ArrayAccess jArrayAccess) {
        this.wc((ASTNode)jArrayAccess);
        this.appendNode((EObject)jArrayAccess.getArray());
        this.appendWrappedNode("[", (ASTNode)jArrayAccess.getIndex(), "]");
        this.wca((ASTNode)jArrayAccess);
        return this;
    }

    public Object caseArrayCreation(ArrayCreation jArrayCreation) {
        this.wc((ASTNode)jArrayCreation);
        this.append("new ");
        ArrayType jArrayType = (ArrayType)jArrayCreation.getType().getType();
        this.appendNode((EObject)jArrayType.getElementType());
        int size = jArrayCreation.getDimensions().size();
        if (size > 0) {
            this.appendWrappedNodes("[", (List<? extends ASTNode>)jArrayCreation.getDimensions(), "][", "]");
        }
        this.appendBrackets(jArrayType.getDimensions() - size);
        this.appendNode((EObject)jArrayCreation.getInitializer());
        this.wca((ASTNode)jArrayCreation);
        return this;
    }

    public Object caseArrayInitializer(ArrayInitializer jArrayInitializer) {
        this.wc((ASTNode)jArrayInitializer);
        this.appendWrappedNodes("{ ", (List<? extends ASTNode>)jArrayInitializer.getExpressions(), ", ", " }");
        this.wca((ASTNode)jArrayInitializer);
        return this;
    }

    public Object caseArrayLengthAccess(ArrayLengthAccess jArrayLengthAccess) {
        this.wc((ASTNode)jArrayLengthAccess);
        this.appendNode((EObject)jArrayLengthAccess.getArray());
        this.append(".length");
        this.wca((ASTNode)jArrayLengthAccess);
        return this;
    }

    public Object caseArrayType(ArrayType jArrayType) {
        this.wc((ASTNode)jArrayType);
        this.appendNode((EObject)jArrayType.getElementType());
        this.appendBrackets(jArrayType.getDimensions());
        this.wca((ASTNode)jArrayType);
        return this;
    }

    public Object caseAssertStatement(AssertStatement jAssertStatement) {
        this.wc((ASTNode)jAssertStatement);
        this.append("assert ");
        this.appendNode((EObject)jAssertStatement.getExpression());
        this.appendWrappedNode(" : ", (ASTNode)jAssertStatement.getMessage(), null);
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jAssertStatement);
        return this;
    }

    public Object caseAssignment(Assignment jAssignment) {
        this.wc((ASTNode)jAssignment);
        this.appendNode((EObject)jAssignment.getLeftHandSide());
        this.appendSoftSpace();
        this.append(jAssignment.getOperator().toString());
        this.appendSoftSpace();
        this.appendNode((EObject)jAssignment.getRightHandSide());
        this.wca((ASTNode)jAssignment);
        return this;
    }

    public Object caseBlock(Block jBlock) {
        this.wc((ASTNode)jBlock);
        this.appendSoftSpace();
        this.append("{\n");
        this.pushIndentation();
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jBlock.getStatements(), "\n", null);
        this.wci((ASTNode)jBlock);
        this.popIndentation();
        this.append("}\n");
        this.wca((ASTNode)jBlock);
        return this;
    }

    public Object caseBlockComment(BlockComment jBlockComment) {
        this.append(jBlockComment.getContent());
        return this;
    }

    public Object caseBodyDeclaration(BodyDeclaration jBodyDeclaration) {
        return this.errorCase((EObject)jBodyDeclaration);
    }

    public Object caseBooleanLiteral(BooleanLiteral jBooleanLiteral) {
        this.wc((ASTNode)jBooleanLiteral);
        this.append(jBooleanLiteral.isValue());
        this.wca((ASTNode)jBooleanLiteral);
        return this;
    }

    public Object caseBreakStatement(BreakStatement jBreakStatement) {
        this.wc((ASTNode)jBreakStatement);
        this.append("break");
        if (jBreakStatement.getLabel() != null) {
            this.appendSoftSpace();
            this.append(jBreakStatement.getLabel().getName());
        }
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jBreakStatement);
        return this;
    }

    public Object caseCastExpression(CastExpression jCastExpression) {
        this.wc((ASTNode)jCastExpression);
        this.appendWrappedNode("(", (ASTNode)jCastExpression.getType(), ")");
        this.appendNode((EObject)jCastExpression.getExpression());
        this.wca((ASTNode)jCastExpression);
        return this;
    }

    public Object caseCatchClause(CatchClause jCatchClause) {
        this.appendSoftNewLine();
        this.wc((ASTNode)jCatchClause);
        this.appendWrappedNode("catch (", (ASTNode)jCatchClause.getException(), ")");
        this.appendNode((EObject)jCatchClause.getBody());
        this.wca((ASTNode)jCatchClause);
        return this;
    }

    public Object caseCharacterLiteral(CharacterLiteral jCharacterLiteral) {
        this.wc((ASTNode)jCharacterLiteral);
        this.append(jCharacterLiteral.getEscapedValue());
        this.wca((ASTNode)jCharacterLiteral);
        return this;
    }

    public Object caseClassDeclaration(ClassDeclaration jClassDeclaration) {
        this.appendSoftNewLine();
        this.wc((ASTNode)jClassDeclaration);
        this.appendTypeHeader((TypeDeclaration)jClassDeclaration);
        this.appendWrappedNode(" extends ", (ASTNode)jClassDeclaration.getSuperClass(), null);
        this.appendOptionalWrappedNodes(" implements ", (List<? extends ASTNode>)jClassDeclaration.getSuperInterfaces(), ", ", null);
        this.appendSoftSpace();
        this.append("{");
        this.appendBodyDeclarations((List<BodyDeclaration>)jClassDeclaration.getBodyDeclarations());
        this.wci((ASTNode)jClassDeclaration);
        this.append("}");
        this.wca((ASTNode)jClassDeclaration);
        return this;
    }

    public Object caseClassFile(ClassFile jClassFile) {
        return this.errorCase((EObject)jClassFile);
    }

    public Object caseClassInstanceCreation(ClassInstanceCreation jClassInstanceCreation) {
        this.wc((ASTNode)jClassInstanceCreation);
        this.appendWrappedNode(null, (ASTNode)jClassInstanceCreation.getExpression(), ".");
        this.append("new ");
        this.appendNode((EObject)jClassInstanceCreation.getType());
        this.appendWrappedNodes("(", (List<? extends ASTNode>)jClassInstanceCreation.getArguments(), ", ", ")");
        this.appendNode((EObject)jClassInstanceCreation.getAnonymousClassDeclaration());
        this.wca((ASTNode)jClassInstanceCreation);
        return this;
    }

    public Object caseComment(Comment object) {
        return this.errorCase((EObject)object);
    }

    public Object caseCompilationUnit(CompilationUnit jCompilationUnit) {
        StringBuilder sFile = new StringBuilder();
        sFile.append(this.absoluteOutputPath);
        sFile.append("/");
        String fileKey = this.getQualifiedPath(sFile, (NamedElement)jCompilationUnit);
        this.pushFile();
        this.wc((ASTNode)jCompilationUnit);
        this.appendNode((EObject)jCompilationUnit.getPackage());
        this.appendOptionalWrappedNodes("\n", (List<? extends ASTNode>)jCompilationUnit.getImports(), null, null);
        this.append("\n");
        this.wci((ASTNode)jCompilationUnit);
        this.appendNodes((List<? extends ASTNode>)jCompilationUnit.getTypes());
        this.wca((ASTNode)jCompilationUnit);
        this.popFile(fileKey);
        return this;
    }

    public Object caseConditionalExpression(ConditionalExpression jConditionalExpression) {
        this.wc((ASTNode)jConditionalExpression);
        this.appendNode((EObject)jConditionalExpression.getExpression());
        this.append(" ? ");
        this.appendNode((EObject)jConditionalExpression.getThenExpression());
        this.append(" : ");
        this.appendNode((EObject)jConditionalExpression.getElseExpression());
        this.wca((ASTNode)jConditionalExpression);
        return this;
    }

    public Object caseConstructorInvocation(ConstructorInvocation jConstructorInvocation) {
        this.wc((ASTNode)jConstructorInvocation);
        this.appendOptionalWrappedNodes("<", (List<? extends ASTNode>)jConstructorInvocation.getTypeArguments(), ", ", ">");
        this.append("this");
        this.appendWrappedNodes("(", (List<? extends ASTNode>)jConstructorInvocation.getArguments(), ", ", ")");
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jConstructorInvocation);
        return this;
    }

    public Object caseContinueStatement(ContinueStatement jContinueStatement) {
        this.wc((ASTNode)jContinueStatement);
        this.append("continue");
        if (jContinueStatement.getLabel() != null) {
            this.appendSoftSpace();
            this.append(jContinueStatement.getLabel().getName());
        }
        this.append(";");
        this.wca((ASTNode)jContinueStatement);
        this.appendSoftNewLine();
        return this;
    }

    public Object caseDoStatement(DoStatement jDoStatement) {
        this.wc((ASTNode)jDoStatement);
        this.append("do ");
        this.appendNode((EObject)jDoStatement.getBody());
        this.appendSoftNewLine();
        this.appendWrappedNode("while (", (ASTNode)jDoStatement.getExpression(), ");");
        this.appendSoftNewLine();
        this.wca((ASTNode)jDoStatement);
        return this;
    }

    public Object caseEmptyStatement(EmptyStatement jEmptyStatement) {
        this.wc((ASTNode)jEmptyStatement);
        this.append(";");
        this.wca((ASTNode)jEmptyStatement);
        this.appendSoftNewLine();
        return this;
    }

    public Object caseEnhancedForStatement(EnhancedForStatement jEnhancedForStatement) {
        this.wc((ASTNode)jEnhancedForStatement);
        this.append("for (");
        this.appendNode((EObject)jEnhancedForStatement.getParameter());
        this.appendSoftSpace();
        this.append(":");
        this.appendSoftSpace();
        this.appendNode((EObject)jEnhancedForStatement.getExpression());
        this.append(")");
        this.appendSoftSpace();
        this.appendNode((EObject)jEnhancedForStatement.getBody());
        this.wca((ASTNode)jEnhancedForStatement);
        this.appendSoftNewLine();
        return this;
    }

    public Object caseEnumConstantDeclaration(EnumConstantDeclaration jEnumConstantDeclaration) {
        this.wc((ASTNode)jEnumConstantDeclaration);
        this.appendNodes((List<? extends ASTNode>)jEnumConstantDeclaration.getAnnotations());
        this.appendNode((EObject)jEnumConstantDeclaration.getModifier());
        this.append(jEnumConstantDeclaration.getName());
        this.appendWrappedNodes("(", (List<? extends ASTNode>)jEnumConstantDeclaration.getArguments(), ",", ")");
        this.wca((ASTNode)jEnumConstantDeclaration);
        return this;
    }

    public Object caseEnumDeclaration(EnumDeclaration jEnumDeclaration) {
        this.appendSoftNewLine();
        this.wc((ASTNode)jEnumDeclaration);
        this.appendNodes((List<? extends ASTNode>)jEnumDeclaration.getAnnotations());
        this.appendNode((EObject)jEnumDeclaration.getModifier());
        this.appendJavaKeyword((AbstractTypeDeclaration)jEnumDeclaration);
        this.append(" ");
        this.append(jEnumDeclaration.getName());
        this.appendOptionalWrappedNodes(" implements ", (List<? extends ASTNode>)jEnumDeclaration.getSuperInterfaces(), ", ", null);
        this.appendSoftSpace();
        this.append("{\n");
        this.pushIndentation();
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jEnumDeclaration.getEnumConstants(), ",\n", ";");
        this.appendSoftNewLine();
        for (BodyDeclaration jBodyDeclaration : jEnumDeclaration.getBodyDeclarations()) {
            if (jBodyDeclaration.isProxy()) continue;
            this.appendNode((EObject)jBodyDeclaration);
        }
        this.wci((ASTNode)jEnumDeclaration);
        this.popIndentation();
        this.append("}");
        this.wca((ASTNode)jEnumDeclaration);
        return this;
    }

    public Object caseExpression(Expression jExpression) {
        return this.errorCase((EObject)jExpression);
    }

    public Object caseExpressionStatement(ExpressionStatement jExpressionStatement) {
        this.wc((ASTNode)jExpressionStatement);
        this.appendNode((EObject)jExpressionStatement.getExpression());
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jExpressionStatement);
        return this;
    }

    public Object caseFieldAccess(FieldAccess jFieldAccess) {
        this.wc((ASTNode)jFieldAccess);
        this.appendNode((EObject)jFieldAccess.getExpression());
        this.append(".");
        this.appendNode((EObject)jFieldAccess.getField());
        this.wca((ASTNode)jFieldAccess);
        return this;
    }

    public Object caseFieldDeclaration(FieldDeclaration jFieldDeclaration) {
        this.wc((ASTNode)jFieldDeclaration);
        this.appendNodes((List<? extends ASTNode>)jFieldDeclaration.getAnnotations());
        this.wci((ASTNode)jFieldDeclaration);
        this.appendModifier(jFieldDeclaration.getModifier());
        this.appendWrappedNode(null, (ASTNode)jFieldDeclaration.getType(), " ");
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jFieldDeclaration.getFragments(), ", ", null);
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jFieldDeclaration);
        return this;
    }

    public Object caseForStatement(ForStatement jForStatement) {
        this.wc((ASTNode)jForStatement);
        this.append("for (");
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jForStatement.getInitializers(), ", ", null);
        this.append("; ");
        this.appendNode((EObject)jForStatement.getExpression());
        this.append("; ");
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jForStatement.getUpdaters(), ", ", null);
        this.append(") ");
        this.appendNode((EObject)jForStatement.getBody());
        this.wca((ASTNode)jForStatement);
        this.appendSoftNewLine();
        return this;
    }

    public Object caseIfStatement(IfStatement jIfStatement) {
        this.wc((ASTNode)jIfStatement);
        this.appendWrappedNode("if (", (ASTNode)jIfStatement.getExpression(), ")");
        this.appendSoftSpace();
        this.appendNode((EObject)jIfStatement.getThenStatement());
        this.appendSoftNewLine();
        if (jIfStatement.getElseStatement() != null) {
            this.append("else");
            this.appendSoftSpace();
            this.appendNode((EObject)jIfStatement.getElseStatement());
            this.appendSoftNewLine();
        }
        this.wca((ASTNode)jIfStatement);
        return this;
    }

    public Object caseImportDeclaration(ImportDeclaration jImportDeclaration) {
        this.appendSoftNewLine();
        this.wc((ASTNode)jImportDeclaration);
        this.append("import");
        if (jImportDeclaration.isStatic()) {
            this.append(" static");
        }
        this.append(" ");
        NamedElement jImportedElement = jImportDeclaration.getImportedElement();
        this.appendQualifiedName(jImportedElement);
        if (jImportedElement instanceof Package) {
            this.append(".*");
        }
        if (jImportedElement instanceof AbstractTypeDeclaration && jImportDeclaration.isStatic()) {
            this.append(".*");
        }
        this.append(";\n");
        this.wca((ASTNode)jImportDeclaration);
        return this;
    }

    public Object caseInfixExpression(InfixExpression jInfixExpression) {
        this.wc((ASTNode)jInfixExpression);
        this.appendNode((EObject)jInfixExpression.getLeftOperand());
        this.appendSoftSpace();
        this.append(jInfixExpression.getOperator().toString());
        this.appendSoftSpace();
        this.appendNode((EObject)jInfixExpression.getRightOperand());
        this.appendOptionalWrappedNodes(" ", (List<? extends ASTNode>)jInfixExpression.getExtendedOperands(), " ", null);
        this.wca((ASTNode)jInfixExpression);
        return this;
    }

    public Object caseInitializer(Initializer jInitializer) {
        this.wc((ASTNode)jInitializer);
        this.appendNodes((List<? extends ASTNode>)jInitializer.getAnnotations());
        this.appendNode((EObject)jInitializer.getModifier());
        this.appendNode((EObject)jInitializer.getBody());
        this.wca((ASTNode)jInitializer);
        return this;
    }

    public Object caseInstanceofExpression(InstanceofExpression jInstanceofExpression) {
        this.wc((ASTNode)jInstanceofExpression);
        this.appendNode((EObject)jInstanceofExpression.getLeftOperand());
        this.append(" instanceof ");
        this.appendNode((EObject)jInstanceofExpression.getRightOperand());
        this.wca((ASTNode)jInstanceofExpression);
        return this;
    }

    public Object caseInterfaceDeclaration(InterfaceDeclaration jInterfaceDeclaration) {
        this.appendSoftNewLine();
        this.wc((ASTNode)jInterfaceDeclaration);
        this.appendTypeHeader((TypeDeclaration)jInterfaceDeclaration);
        this.appendOptionalWrappedNodes(" extends ", (List<? extends ASTNode>)jInterfaceDeclaration.getSuperInterfaces(), ", ", null);
        this.appendSoftSpace();
        this.append("{");
        this.appendBodyDeclarations((List<BodyDeclaration>)jInterfaceDeclaration.getBodyDeclarations());
        this.wci((ASTNode)jInterfaceDeclaration);
        this.append("}");
        this.wca((ASTNode)jInterfaceDeclaration);
        return this;
    }

    public Object caseJavadoc(Javadoc jJavadoc) {
        EList jTags = jJavadoc.getTags();
        if (jTags.size() > 0) {
            this.appendSoftNewLine();
            this.append("/**");
            for (TagElement jTag : jTags) {
                this.append("\n * ");
                this.appendNode((EObject)jTag);
            }
            this.append("\n */\n");
        } else {
            this.append(jJavadoc.getContent());
            this.append("\n");
        }
        return this;
    }

    public Object caseLabeledStatement(LabeledStatement jLabeledStatement) {
        this.wc((ASTNode)jLabeledStatement);
        this.append(jLabeledStatement.getName());
        this.append(" : ");
        this.appendNode((EObject)jLabeledStatement.getBody());
        this.wca((ASTNode)jLabeledStatement);
        return this;
    }

    public Object caseLineComment(LineComment jLineComment) {
        this.append(jLineComment.getContent());
        this.append("\n");
        return this;
    }

    public Object caseManifest(Manifest jManifest) {
        return this.errorCase((EObject)jManifest);
    }

    public Object caseManifestAttribute(ManifestAttribute jManifestAttribute) {
        return this.errorCase((EObject)jManifestAttribute);
    }

    public Object caseManifestEntry(ManifestEntry jManifestEntry) {
        return this.errorCase((EObject)jManifestEntry);
    }

    public Object caseMemberRef(MemberRef jMemberRef) {
        this.wc((ASTNode)jMemberRef);
        this.appendWrappedNode(null, (ASTNode)jMemberRef.getQualifier(), "#");
        this.append(jMemberRef.getMember().getName());
        this.wca((ASTNode)jMemberRef);
        return this;
    }

    public Object caseMethodInvocation(MethodInvocation jMethodInvocation) {
        this.wc((ASTNode)jMethodInvocation);
        this.appendWrappedNode(null, (ASTNode)jMethodInvocation.getExpression(), ".");
        this.appendMethodHeader((AbstractMethodInvocation)jMethodInvocation);
        this.wca((ASTNode)jMethodInvocation);
        return this;
    }

    public Object caseMethodRef(MethodRef jMethodRef) {
        this.appendNode((EObject)jMethodRef.getQualifier());
        this.append("#");
        this.append(jMethodRef.getMethod().getName());
        this.appendWrappedNodes("(", (List<? extends ASTNode>)jMethodRef.getParameters(), ", ", ")");
        this.wca((ASTNode)jMethodRef);
        return this;
    }

    public Object caseMethodRefParameter(MethodRefParameter jMethodRefParameter) {
        this.appendNode((EObject)jMethodRefParameter.getType());
        if (jMethodRefParameter.isVarargs()) {
            this.append("...");
        }
        this.append(" ");
        this.append(jMethodRefParameter.getName());
        this.wca((ASTNode)jMethodRefParameter);
        return this;
    }

    public Object caseModel(Model jModel) {
        this.appendNodes((List<? extends ASTNode>)jModel.getCompilationUnits());
        return this;
    }

    public Object caseModifier(Modifier jModifier) {
        this.wc((ASTNode)jModifier);
        if (jModifier.getVisibility() == VisibilityKind.PUBLIC) {
            this.append("public ");
        } else if (jModifier.getVisibility() == VisibilityKind.PRIVATE) {
            this.append("private ");
        } else if (jModifier.getVisibility() == VisibilityKind.PROTECTED) {
            this.append("protected ");
        }
        if (jModifier.getInheritance() == InheritanceKind.ABSTRACT) {
            this.append("abstract ");
        }
        if (jModifier.isStatic()) {
            this.append("static ");
        }
        if (jModifier.getInheritance() == InheritanceKind.FINAL) {
            this.append("final ");
        }
        if (jModifier.isTransient()) {
            this.append("transient ");
        }
        if (jModifier.isVolatile()) {
            this.append("volatile ");
        }
        if (jModifier.isSynchronized()) {
            this.append("synchronized ");
        }
        if (jModifier.isNative()) {
            this.append("native ");
        }
        if (jModifier.isStrictfp()) {
            this.append("strictfp ");
        }
        this.wca((ASTNode)jModifier);
        return this;
    }

    public Object caseNamedElement(NamedElement jNamedElement) {
        return this.errorCase((EObject)jNamedElement);
    }

    public Object caseNamespaceAccess(NamespaceAccess jNamespaceAccess) {
        return this.errorCase((EObject)jNamespaceAccess);
    }

    public Object caseNumberLiteral(NumberLiteral jNumberLiteral) {
        this.wc((ASTNode)jNumberLiteral);
        this.append(jNumberLiteral.getTokenValue());
        this.wca((ASTNode)jNumberLiteral);
        return this;
    }

    public Object caseNullLiteral(NullLiteral jNullLiteral) {
        this.wc((ASTNode)jNullLiteral);
        this.append("null");
        this.wca((ASTNode)jNullLiteral);
        return this;
    }

    public Object casePackage(Package jPackage) {
        this.wc((ASTNode)jPackage);
        this.append("package ");
        this.appendQualifiedName((NamedElement)jPackage);
        this.wca((ASTNode)jPackage);
        this.append(";\n");
        return this;
    }

    public Object casePackageAccess(PackageAccess jPackageAccess) {
        this.wc((ASTNode)jPackageAccess);
        this.appendWrappedNode(null, (ASTNode)jPackageAccess.getQualifier(), ".");
        this.append(jPackageAccess.getPackage().getName());
        this.wca((ASTNode)jPackageAccess);
        return this;
    }

    public Object caseParameterizedType(ParameterizedType jParameterizedType) {
        this.wc((ASTNode)jParameterizedType);
        this.appendNode((EObject)jParameterizedType.getType());
        this.appendWrappedNodes("<", (List<? extends ASTNode>)jParameterizedType.getTypeArguments(), ", ", ">");
        this.wca((ASTNode)jParameterizedType);
        return this;
    }

    public Object caseParenthesizedExpression(ParenthesizedExpression jParenthesizedExpression) {
        this.wc((ASTNode)jParenthesizedExpression);
        this.appendWrappedNode("(", (ASTNode)jParenthesizedExpression.getExpression(), ")");
        this.wca((ASTNode)jParenthesizedExpression);
        return this;
    }

    public Object casePostfixExpression(PostfixExpression jPostfixExpression) {
        this.wc((ASTNode)jPostfixExpression);
        this.appendNode((EObject)jPostfixExpression.getOperand());
        this.append(jPostfixExpression.getOperator().toString());
        this.wca((ASTNode)jPostfixExpression);
        return this;
    }

    public Object casePrefixExpression(PrefixExpression jPrefixExpression) {
        this.wc((ASTNode)jPrefixExpression);
        this.append(jPrefixExpression.getOperator().toString());
        this.appendNode((EObject)jPrefixExpression.getOperand());
        this.wca((ASTNode)jPrefixExpression);
        return this;
    }

    public Object casePrimitiveType(PrimitiveType jPrimitiveType) {
        return this.errorCase((EObject)jPrimitiveType);
    }

    public Object casePrimitiveTypeBoolean(PrimitiveTypeBoolean jPrimitiveType) {
        this.append("boolean");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeByte(PrimitiveTypeByte jPrimitiveType) {
        this.append("byte");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeChar(PrimitiveTypeChar jPrimitiveType) {
        this.append("char");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeDouble(PrimitiveTypeDouble jPrimitiveType) {
        this.append("double");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeFloat(PrimitiveTypeFloat jPrimitiveType) {
        this.append("float");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeInt(PrimitiveTypeInt jPrimitiveType) {
        this.append("int");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeLong(PrimitiveTypeLong jPrimitiveType) {
        this.append("long");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeShort(PrimitiveTypeShort jPrimitiveType) {
        this.append("short");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object casePrimitiveTypeVoid(PrimitiveTypeVoid jPrimitiveType) {
        this.append("void");
        this.wca((ASTNode)jPrimitiveType);
        return this;
    }

    public Object caseReturnStatement(ReturnStatement jReturnStatement) {
        this.wc((ASTNode)jReturnStatement);
        this.append("return");
        this.appendWrappedNode(" ", (ASTNode)jReturnStatement.getExpression(), null);
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jReturnStatement);
        return this;
    }

    public Object caseSingleVariableAccess(SingleVariableAccess jSingleVariableAccess) {
        this.wc((ASTNode)jSingleVariableAccess);
        this.appendWrappedNode(null, (ASTNode)jSingleVariableAccess.getQualifier(), ".");
        this.append(jSingleVariableAccess.getVariable().getName());
        this.wca((ASTNode)jSingleVariableAccess);
        return this;
    }

    public Object caseSingleVariableDeclaration(SingleVariableDeclaration jSingleVariableDeclaration) {
        this.wc((ASTNode)jSingleVariableDeclaration);
        this.appendNodes((List<? extends ASTNode>)jSingleVariableDeclaration.getAnnotations());
        this.appendModifier(jSingleVariableDeclaration.getModifier());
        this.appendWrappedNode(null, (ASTNode)jSingleVariableDeclaration.getType(), " ");
        if (jSingleVariableDeclaration.isVarargs()) {
            this.append("... ");
        }
        this.append(jSingleVariableDeclaration.getName());
        this.appendBrackets(jSingleVariableDeclaration.getExtraArrayDimensions());
        this.appendWrappedNode("=", (ASTNode)jSingleVariableDeclaration.getInitializer(), null);
        this.wca((ASTNode)jSingleVariableDeclaration);
        return this;
    }

    public Object caseStatement(Statement jStatement) {
        return this.errorCase((EObject)jStatement);
    }

    public Object caseStringLiteral(StringLiteral jStringLiteral) {
        this.wc((ASTNode)jStringLiteral);
        this.append(jStringLiteral.getEscapedValue());
        this.wca((ASTNode)jStringLiteral);
        return this;
    }

    public Object caseSuperConstructorInvocation(SuperConstructorInvocation jSuperConstructorInvocation) {
        this.wc((ASTNode)jSuperConstructorInvocation);
        this.appendWrappedNode(null, (ASTNode)jSuperConstructorInvocation.getExpression(), ".");
        this.appendOptionalWrappedNodes("<", (List<? extends ASTNode>)jSuperConstructorInvocation.getTypeArguments(), ", ", ">");
        this.append("super");
        this.appendWrappedNodes("(", (List<? extends ASTNode>)jSuperConstructorInvocation.getArguments(), ", ", ")");
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jSuperConstructorInvocation);
        return this;
    }

    public Object caseSuperFieldAccess(SuperFieldAccess jSuperFieldAccess) {
        this.wc((ASTNode)jSuperFieldAccess);
        this.appendWrappedNode("", (ASTNode)jSuperFieldAccess.getQualifier(), ".");
        this.append("super.");
        this.appendNode((EObject)jSuperFieldAccess.getField());
        this.wca((ASTNode)jSuperFieldAccess);
        return this;
    }

    public Object caseSuperMethodInvocation(SuperMethodInvocation jSuperMethodInvocation) {
        this.wc((ASTNode)jSuperMethodInvocation);
        this.append("super.");
        this.appendMethodHeader((AbstractMethodInvocation)jSuperMethodInvocation);
        this.wca((ASTNode)jSuperMethodInvocation);
        return this;
    }

    public Object caseSwitchCase(SwitchCase jSwitchCase) {
        this.appendSoftNewLine();
        this.wc((ASTNode)jSwitchCase);
        if (jSwitchCase.isDefault()) {
            this.append("default");
        } else {
            this.appendWrappedNode("case ", (ASTNode)jSwitchCase.getExpression(), null);
        }
        this.append(": ");
        this.wca((ASTNode)jSwitchCase);
        return this;
    }

    public Object caseSwitchStatement(SwitchStatement jSwitchStatement) {
        this.wc((ASTNode)jSwitchStatement);
        this.appendWrappedNode("switch (", (ASTNode)jSwitchStatement.getExpression(), ") {\n");
        this.pushIndentation();
        this.appendNodes((List<? extends ASTNode>)jSwitchStatement.getStatements());
        this.appendSoftNewLine();
        this.popIndentation();
        this.append("}");
        this.wca((ASTNode)jSwitchStatement);
        this.appendSoftNewLine();
        return this;
    }

    public Object caseSynchronizedStatement(SynchronizedStatement jSynchronizedStatement) {
        this.wc((ASTNode)jSynchronizedStatement);
        this.appendWrappedNode("synchronized (", (ASTNode)jSynchronizedStatement.getExpression(), ")");
        this.appendSoftSpace();
        this.appendNode((EObject)jSynchronizedStatement.getBody());
        this.wca((ASTNode)jSynchronizedStatement);
        return this;
    }

    public Object caseTagElement(TagElement jTagElement) {
        if (jTagElement.getTagName() != null) {
            this.append(jTagElement.getTagName());
            String separator = " ";
            for (ASTNode jNode : jTagElement.getFragments()) {
                this.append(separator);
                if (jNode instanceof TagElement) {
                    this.append("{");
                    this.appendNode((EObject)jNode);
                    this.append("}");
                    continue;
                }
                this.appendNode((EObject)jNode);
            }
        } else {
            String separator = null;
            for (ASTNode jNode : jTagElement.getFragments()) {
                this.append(separator);
                if (jNode instanceof TagElement) {
                    this.append("{");
                    this.appendNode((EObject)jNode);
                    this.append("}");
                } else {
                    this.appendNode((EObject)jNode);
                }
                separator = " ";
            }
        }
        return this;
    }

    public Object caseTextElement(TextElement jTextElement) {
        this.append(jTextElement.getText());
        return this;
    }

    public Object caseThisExpression(ThisExpression jThisExpression) {
        this.wc((ASTNode)jThisExpression);
        this.appendWrappedNode("", (ASTNode)jThisExpression.getQualifier(), ".");
        this.append("this");
        this.wca((ASTNode)jThisExpression);
        return this;
    }

    public Object caseThrowStatement(ThrowStatement jThrowStatement) {
        this.wc((ASTNode)jThrowStatement);
        this.appendWrappedNode("throw ", (ASTNode)jThrowStatement.getExpression(), ";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jThrowStatement);
        return this;
    }

    public Object caseTryStatement(TryStatement jTryStatement) {
        this.wc((ASTNode)jTryStatement);
        this.append("try ");
        this.appendNode((EObject)jTryStatement.getBody());
        this.appendNodes((List<? extends ASTNode>)jTryStatement.getCatchClauses());
        this.appendWrappedNode("finally ", (ASTNode)jTryStatement.getFinally(), null);
        this.wca((ASTNode)jTryStatement);
        return this;
    }

    public Object caseType(Type jType) {
        return this.errorCase((EObject)jType);
    }

    public Object caseTypeAccess(TypeAccess jTypeAccess) {
        this.wc((ASTNode)jTypeAccess);
        this.appendWrappedNode(null, (ASTNode)jTypeAccess.getQualifier(), ".");
        Type jType = jTypeAccess.getType();
        if (jType instanceof ArrayType || jType instanceof ParameterizedType || jType instanceof WildCardType) {
            this.appendNode((EObject)jType);
        } else {
            this.append(jType.getName());
        }
        this.wca((ASTNode)jTypeAccess);
        return this;
    }

    public Object caseTypeDeclaration(TypeDeclaration jTypeDeclaration) {
        return this.errorCase((EObject)jTypeDeclaration);
    }

    public Object caseTypeDeclarationStatement(TypeDeclarationStatement jTypeDeclarationStatement) {
        this.wc((ASTNode)jTypeDeclarationStatement);
        this.appendNode((EObject)jTypeDeclarationStatement.getDeclaration());
        this.wca((ASTNode)jTypeDeclarationStatement);
        this.appendSoftNewLine();
        return this;
    }

    public Object caseTypeLiteral(TypeLiteral jTypeLiteral) {
        this.wc((ASTNode)jTypeLiteral);
        if (!this.appendWrappedNode(null, (ASTNode)jTypeLiteral.getType(), ".class")) {
            this.append("void.class");
        }
        this.wca((ASTNode)jTypeLiteral);
        return this;
    }

    public Object caseTypeParameter(TypeParameter jTypeParameter) {
        this.wc((ASTNode)jTypeParameter);
        this.append(jTypeParameter.getName());
        this.appendOptionalWrappedNodes(" extends ", (List<? extends ASTNode>)jTypeParameter.getBounds(), " & ", null);
        this.wca((ASTNode)jTypeParameter);
        return this;
    }

    public Object caseUnresolvedAnnotationDeclaration(UnresolvedAnnotationDeclaration jUnresolvedAnnotationDeclaration) {
        this.wc((ASTNode)jUnresolvedAnnotationDeclaration);
        this.append(jUnresolvedAnnotationDeclaration.getName());
        this.wca((ASTNode)jUnresolvedAnnotationDeclaration);
        return this;
    }

    public Object caseUnresolvedAnnotationTypeMemberDeclaration(UnresolvedAnnotationTypeMemberDeclaration jUnresolvedAnnotationTypeMemberDeclaration) {
        this.wc((ASTNode)jUnresolvedAnnotationTypeMemberDeclaration);
        this.append(jUnresolvedAnnotationTypeMemberDeclaration.getName());
        this.wca((ASTNode)jUnresolvedAnnotationTypeMemberDeclaration);
        return this;
    }

    public Object caseUnresolvedClassDeclaration(UnresolvedClassDeclaration jUnresolvedClassDeclaration) {
        this.wc((ASTNode)jUnresolvedClassDeclaration);
        this.append(jUnresolvedClassDeclaration.getName());
        this.wca((ASTNode)jUnresolvedClassDeclaration);
        return this;
    }

    public Object caseUnresolvedEnumDeclaration(UnresolvedEnumDeclaration jUnresolvedEnumDeclaration) {
        this.wc((ASTNode)jUnresolvedEnumDeclaration);
        this.append(jUnresolvedEnumDeclaration.getName());
        this.wca((ASTNode)jUnresolvedEnumDeclaration);
        return this;
    }

    public Object caseUnresolvedInterfaceDeclaration(UnresolvedInterfaceDeclaration jUnresolvedInterfaceDeclaration) {
        this.wc((ASTNode)jUnresolvedInterfaceDeclaration);
        this.append(jUnresolvedInterfaceDeclaration.getName());
        this.wca((ASTNode)jUnresolvedInterfaceDeclaration);
        return this;
    }

    public Object caseUnresolvedItem(UnresolvedItem jUnresolvedItem) {
        this.wc((ASTNode)jUnresolvedItem);
        this.append(jUnresolvedItem.getName());
        this.wca((ASTNode)jUnresolvedItem);
        return this;
    }

    public Object caseUnresolvedItemAccess(UnresolvedItemAccess jUnresolvedItemAccess) {
        this.wc((ASTNode)jUnresolvedItemAccess);
        this.appendWrappedNode(null, jUnresolvedItemAccess.getQualifier(), ".");
        this.appendNode((EObject)jUnresolvedItemAccess.getElement());
        this.wca((ASTNode)jUnresolvedItemAccess);
        return this;
    }

    public Object caseUnresolvedLabeledStatement(UnresolvedLabeledStatement jUnresolvedLabeledStatement) {
        this.wc((ASTNode)jUnresolvedLabeledStatement);
        this.append(jUnresolvedLabeledStatement.getName());
        this.wca((ASTNode)jUnresolvedLabeledStatement);
        return this;
    }

    public Object caseUnresolvedMethodDeclaration(UnresolvedMethodDeclaration jUnresolvedMethodDeclaration) {
        this.wc((ASTNode)jUnresolvedMethodDeclaration);
        this.append(jUnresolvedMethodDeclaration.getName());
        this.wca((ASTNode)jUnresolvedMethodDeclaration);
        return this;
    }

    public Object caseUnresolvedSingleVariableDeclaration(UnresolvedSingleVariableDeclaration jUnresolvedSingleVariableDeclaration) {
        this.wc((ASTNode)jUnresolvedSingleVariableDeclaration);
        this.append(jUnresolvedSingleVariableDeclaration.getName());
        this.wca((ASTNode)jUnresolvedSingleVariableDeclaration);
        return this;
    }

    public Object caseUnresolvedType(UnresolvedType jUnresolvedType) {
        this.wc((ASTNode)jUnresolvedType);
        this.append(jUnresolvedType.getName());
        this.wca((ASTNode)jUnresolvedType);
        return this;
    }

    public Object caseUnresolvedTypeDeclaration(UnresolvedTypeDeclaration jUnresolvedTypeDeclaration) {
        this.wc((ASTNode)jUnresolvedTypeDeclaration);
        this.append(jUnresolvedTypeDeclaration.getName());
        this.wca((ASTNode)jUnresolvedTypeDeclaration);
        return this;
    }

    public Object caseVariableDeclaration(VariableDeclaration jVariableDeclaration) {
        return this.errorCase((EObject)jVariableDeclaration);
    }

    public Object caseVariableDeclarationExpression(VariableDeclarationExpression jVariableDeclarationExpression) {
        this.wc((ASTNode)jVariableDeclarationExpression);
        this.appendNodes((List<? extends ASTNode>)jVariableDeclarationExpression.getAnnotations());
        this.appendNode((EObject)jVariableDeclarationExpression.getModifier());
        this.appendNode((EObject)jVariableDeclarationExpression.getType());
        this.append(" ");
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jVariableDeclarationExpression.getFragments(), ",", null);
        this.wca((ASTNode)jVariableDeclarationExpression);
        return this;
    }

    public Object caseVariableDeclarationFragment(VariableDeclarationFragment jVariableDeclarationFragment) {
        this.wc((ASTNode)jVariableDeclarationFragment);
        this.append(jVariableDeclarationFragment.getName());
        this.appendBrackets(jVariableDeclarationFragment.getExtraArrayDimensions());
        this.appendWrappedNode(" = ", (ASTNode)jVariableDeclarationFragment.getInitializer(), null);
        this.wca((ASTNode)jVariableDeclarationFragment);
        return this;
    }

    public Object caseVariableDeclarationStatement(VariableDeclarationStatement jVariableDeclarationStatement) {
        this.wc((ASTNode)jVariableDeclarationStatement);
        this.appendNodes((List<? extends ASTNode>)jVariableDeclarationStatement.getAnnotations());
        this.appendModifier(jVariableDeclarationStatement.getModifier());
        this.appendNode((EObject)jVariableDeclarationStatement.getType());
        this.appendBrackets(jVariableDeclarationStatement.getExtraArrayDimensions());
        this.append(" ");
        this.appendWrappedNodes(null, (List<? extends ASTNode>)jVariableDeclarationStatement.getFragments(), ",", null);
        this.append(";");
        this.appendSoftNewLine();
        this.wca((ASTNode)jVariableDeclarationStatement);
        return this;
    }

    public Object caseWhileStatement(WhileStatement jWhileStatement) {
        this.wc((ASTNode)jWhileStatement);
        this.appendWrappedNode("while (", (ASTNode)jWhileStatement.getExpression(), ") ");
        this.appendNode((EObject)jWhileStatement.getBody());
        this.wca((ASTNode)jWhileStatement);
        return this;
    }

    public Object caseWildCardType(WildCardType jWildCardType) {
        this.wc((ASTNode)jWildCardType);
        this.append("?");
        this.appendWrappedNode(jWildCardType.isUpperBound() ? " extends " : " super ", (ASTNode)jWildCardType.getBound(), null);
        this.wca((ASTNode)jWildCardType);
        return this;
    }

    public Object defaultCase(EObject eObject) {
        System.err.println("Missing case" + eObject.eClass().getName());
        this.append("Missing case" + eObject.eClass().getName() + "\n");
        this.doChildren(eObject, true);
        return null;
    }

    public Object errorCase(EObject eObject) {
        System.err.println("Missing override case" + eObject.eClass().getName());
        this.append("Missing override case" + eObject.eClass().getName() + "\n");
        this.doChildren(eObject, true);
        return null;
    }
}

