/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.mylyn.context.core.IDegreeOfInterest;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.internal.context.core.AggregateInteractionEvent;
import org.eclipse.mylyn.internal.context.core.InteractionContext;
import org.eclipse.mylyn.monitor.core.InteractionEvent;

public class DegreeOfInterest
implements IDegreeOfInterest {
    private final List<InteractionEvent> events = new ArrayList<InteractionEvent>();
    private final Map<InteractionEvent.Kind, InteractionEvent> collapsedEvents = new HashMap<InteractionEvent.Kind, InteractionEvent>();
    protected IInteractionContextScaling contextScaling;
    private float edits = 0.0f;
    private float selections = 0.0f;
    private float commands = 0.0f;
    private float predictedBias = 0.0f;
    private float propagatedBias = 0.0f;
    private float manipulationBias = 0.0f;
    private final InteractionContext context;
    private final int eventCountOnCreation;

    public DegreeOfInterest(InteractionContext context, IInteractionContextScaling scaling) {
        this(context, scaling, context.getUserEventCount());
    }

    public DegreeOfInterest(InteractionContext context, IInteractionContextScaling scaling, int eventCountOnCreation) {
        this.context = context;
        this.eventCountOnCreation = eventCountOnCreation <= 0 ? context.getUserEventCount() : eventCountOnCreation;
        this.contextScaling = scaling;
    }

    public void addEvent(InteractionEvent event) {
        this.events.add(event);
        InteractionEvent last = this.collapsedEvents.get(event.getKind());
        if (last != null) {
            int numCollapsedEvents = 1;
            if (last instanceof AggregateInteractionEvent) {
                numCollapsedEvents = ((AggregateInteractionEvent)last).getNumCollapsedEvents();
            }
            AggregateInteractionEvent aggregateEvent = new AggregateInteractionEvent(event.getKind(), event.getStructureKind(), event.getStructureHandle(), event.getOriginId(), event.getNavigation(), event.getDelta(), last.getInterestContribution() + event.getInterestContribution(), last.getDate(), event.getEndDate(), numCollapsedEvents + 1, this.eventCountOnCreation);
            this.collapsedEvents.put(event.getKind(), aggregateEvent);
        } else {
            this.collapsedEvents.put(event.getKind(), event);
        }
        this.updateEventState(event);
    }

    private void updateEventState(InteractionEvent event) {
        switch (event.getKind()) {
            case EDIT: {
                this.edits += event.getInterestContribution();
                break;
            }
            case SELECTION: {
                this.selections += event.getInterestContribution();
                break;
            }
            case COMMAND: {
                this.commands += event.getInterestContribution();
                break;
            }
            case PREDICTION: {
                this.predictedBias += event.getInterestContribution();
                break;
            }
            case PROPAGATION: {
                this.propagatedBias += event.getInterestContribution();
                break;
            }
            case MANIPULATION: {
                this.manipulationBias += event.getInterestContribution();
            }
        }
    }

    @Override
    public float getValue() {
        float value = this.getEncodedValue();
        value += this.predictedBias;
        return value += this.propagatedBias;
    }

    @Override
    public float getEncodedValue() {
        float value = 0.0f;
        value += this.selections * this.contextScaling.get(InteractionEvent.Kind.SELECTION);
        value += this.edits * this.contextScaling.get(InteractionEvent.Kind.EDIT);
        value += this.commands * this.contextScaling.get(InteractionEvent.Kind.COMMAND);
        value += this.manipulationBias;
        return value -= this.getDecayValue();
    }

    @Override
    public float getDecayValue() {
        if (this.context != null) {
            return (float)(this.context.getUserEventCount() - this.eventCountOnCreation) * this.contextScaling.getDecay();
        }
        return 0.0f;
    }

    @Override
    public boolean isPropagated() {
        float value = this.selections * this.contextScaling.get(InteractionEvent.Kind.SELECTION) + this.edits * this.contextScaling.get(InteractionEvent.Kind.EDIT);
        return value <= 0.0f && this.propagatedBias > 0.0f;
    }

    @Override
    public boolean isPredicted() {
        return this.getValue() - this.predictedBias <= 0.0f && this.predictedBias > 0.0f;
    }

    @Override
    public boolean isLandmark() {
        return this.getValue() >= this.contextScaling.getLandmark();
    }

    @Override
    public boolean isInteresting() {
        return this.getValue() > this.contextScaling.getInteresting();
    }

    public String toString() {
        return "(selections: " + this.selections + ", edits: " + this.edits + ", commands: " + this.commands + ", predicted: " + this.predictedBias + ", propagated: " + this.propagatedBias + ", manipulation: " + this.manipulationBias + ")";
    }

    @Override
    public List<InteractionEvent> getEvents() {
        return this.events;
    }

    public List<InteractionEvent> getCollapsedEvents() {
        return new ArrayList<InteractionEvent>(this.collapsedEvents.values());
    }
}

