/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.codemining;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.xml.stream.XMLStreamException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.codemining.AbstractCodeMiningProvider;
import org.eclipse.jface.text.codemining.ICodeMining;
import org.eclipse.jface.text.codemining.ICodeMiningProvider;
import org.eclipse.pde.internal.genericeditor.target.extension.codemining.Messages;
import org.eclipse.pde.internal.genericeditor.target.extension.codemining.TargetDefinitionActivationCodeMining;
import org.eclipse.pde.internal.genericeditor.target.extension.model.Node;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;

public class TargetDefinitionCodeMiningProvider
extends AbstractCodeMiningProvider {
    public CompletableFuture<List<? extends ICodeMining>> provideCodeMinings(ITextViewer viewer, IProgressMonitor monitor) {
        return CompletableFuture.supplyAsync(() -> {
            ArrayList<ICodeMining> minings = new ArrayList<ICodeMining>();
            IDocument document = viewer.getDocument();
            try {
                this.fillCodeMinings(document, minings);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            return minings;
        });
    }

    void fillCodeMinings(IDocument document, List<ICodeMining> minings) throws BadLocationException {
        int line = 0;
        try {
            Parser parser = Parser.getDefault();
            Node target = parser.parse(document);
            if (target != null) {
                line = document.getLineOfOffset(target.getOffsetStart());
                minings.add((ICodeMining)new TargetDefinitionActivationCodeMining(line, document, (ICodeMiningProvider)this, null));
            } else {
                minings.add((ICodeMining)new TargetDefinitionActivationCodeMining(line, document, (ICodeMiningProvider)this, Messages.TargetDefinitionCodeMiningProvider_e_format_invalid));
            }
        }
        catch (XMLStreamException e) {
            minings.add((ICodeMining)new TargetDefinitionActivationCodeMining(line, document, (ICodeMiningProvider)this, Messages.TargetDefinitionCodeMiningProvider_e_format_invalid));
        }
    }
}

