/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.util.project.observer;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.php.internal.core.util.project.observer.CompositeProjectChangeObserver;
import org.eclipse.php.internal.core.util.project.observer.IProjectClosedObserver;

public class ProjectRemovedObserversAttacher {
    private static ProjectRemovedObserversAttacher instance = new ProjectRemovedObserversAttacher();
    private Map<IProject, IProjectClosedObserver> project2CompositeProjectChangeObserver = new HashMap<IProject, IProjectClosedObserver>();
    private IResourceChangeListener resourceChangeListener;

    public static ProjectRemovedObserversAttacher getInstance() {
        return instance;
    }

    private ProjectRemovedObserversAttacher() {
    }

    public boolean addProjectClosedObserver(IProject project, IProjectClosedObserver projectChangeObserver) {
        if (this.resourceChangeListener == null) {
            this.resourceChangeListener = new IResourceChangeListener(){

                public void resourceChanged(IResourceChangeEvent event) {
                    IResourceDelta resourceDelta = event.getDelta();
                    if (resourceDelta == null) {
                        return;
                    }
                    IResourceDelta[] affectedChildren = resourceDelta.getAffectedChildren(4);
                    if (affectedChildren.length > 0) {
                        ProjectRemovedObserversAttacher.this.handleClosedProjects(affectedChildren);
                    } else {
                        affectedChildren = resourceDelta.getAffectedChildren(2);
                        ProjectRemovedObserversAttacher.this.handleRemovedProjects(affectedChildren);
                    }
                }
            };
        }
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
        if (project == null || !project.isAccessible()) {
            return false;
        }
        CompositeProjectChangeObserver compositeProjectChangeObserver = this.getCompositeProjectChangeObserver(project);
        compositeProjectChangeObserver.add(projectChangeObserver);
        return true;
    }

    private void handleRemovedProjects(IResourceDelta[] affectedChildren) {
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta resourceDelta = affectedChildren[i];
            IResource resource = resourceDelta.getResource();
            IProject project = (IProject)resource;
            this.notifyProjectClosed(project);
            ++i;
        }
    }

    private void notifyProjectClosed(IProject project) {
        this.getCompositeProjectChangeObserver(project).closed();
        this.removeCompositeProjectChangeObserver(project);
    }

    private void handleClosedProjects(IResourceDelta[] affectedChildren) {
        int i = 0;
        while (i < affectedChildren.length) {
            IResourceDelta resourceDelta = affectedChildren[i];
            IResource resource = resourceDelta.getResource();
            IProject project = (IProject)resource;
            int eventFlags = resourceDelta.getFlags();
            if ((eventFlags & 0x4000) != 0 && !project.isOpen()) {
                this.notifyProjectClosed(project);
            }
            ++i;
        }
    }

    private void removeCompositeProjectChangeObserver(IProject project) {
        CompositeProjectChangeObserver compositeProjectChangeObserver = (CompositeProjectChangeObserver)this.project2CompositeProjectChangeObserver.remove(project);
        compositeProjectChangeObserver.clear();
        if (this.project2CompositeProjectChangeObserver.isEmpty()) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.resourceChangeListener);
        }
    }

    private CompositeProjectChangeObserver getCompositeProjectChangeObserver(IProject project) {
        IProjectClosedObserver object = this.project2CompositeProjectChangeObserver.get(project);
        if (object == null) {
            CompositeProjectChangeObserver compositeProjectChangeObserver = new CompositeProjectChangeObserver();
            this.project2CompositeProjectChangeObserver.put(project, compositeProjectChangeObserver);
            return compositeProjectChangeObserver;
        }
        return (CompositeProjectChangeObserver)object;
    }
}

