/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.common.edit.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.command.ReplaceCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.uml2.common.edit.command.SubsetSupersetCommand;

public class SubsetSupersetReplaceCommand
extends SubsetSupersetCommand {
    protected final Object value;
    protected final Collection<?> collection;

    public SubsetSupersetReplaceCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, EStructuralFeature[] supersetFeatures, EStructuralFeature[] subsetFeatures, Object value, Collection<?> collection) {
        super(domain, owner, feature, supersetFeatures, subsetFeatures, (Command)new ReplaceCommand(domain, owner, feature, value, collection));
        this.value = value;
        this.collection = collection;
    }

    @Override
    public void execute() {
        if (this.supersetFeatures != null) {
            for (Object element : this.collection) {
                int i = 0;
                while (i < this.supersetFeatures.length) {
                    EList values;
                    if (this.supersetFeatures[i].isMany() && !(values = (EList)this.owner.eGet(this.supersetFeatures[i])).contains(element)) {
                        this.appendAndExecute(AddCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)this.supersetFeatures[i], Collections.singleton(element), (int)-1));
                    }
                    ++i;
                }
            }
        }
        if (this.subsetFeatures != null) {
            int i = 0;
            while (i < this.subsetFeatures.length) {
                if (this.subsetFeatures[i].isMany()) {
                    EList values = (EList)this.owner.eGet(this.subsetFeatures[i]);
                    if (values.contains(this.value)) {
                        this.appendAndExecute(RemoveCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)this.subsetFeatures[i], Collections.singleton(this.value)));
                    }
                } else if (this.value == this.owner.eGet(this.subsetFeatures[i])) {
                    EReference subsetReference = (EReference)this.subsetFeatures[i];
                    this.appendAndExecute((Command)(subsetReference.isContainer() && !subsetReference.getEOpposite().isMany() ? new SetCommand(this.domain, this.owner, this.subsetFeatures[i], null) : SetCommand.create((EditingDomain)this.domain, (Object)this.owner, (Object)this.subsetFeatures[i], null)));
                }
                ++i;
            }
        }
        super.execute();
    }
}

