/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.uml2.uml.validation;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.validation.IValidationContext;
import org.eclipse.emf.validation.model.ConstraintStatus;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.validation.model.IModelConstraint;
import org.eclipse.emf.validation.service.IConstraintDescriptor;
import org.eclipse.uml2.uml.UMLPlugin;
import org.eclipse.uml2.uml.validation.DelegatingConstraintDescriptor;

class DelegatingModelConstraint
implements IModelConstraint {
    private final IConstraintDescriptor descriptor;
    private final EValidator delegate;
    private final EValidator.SubstitutionLabelProvider labelProvider;
    private final Method constraintMethod;

    DelegatingModelConstraint(String namespace, EValidator delegate, EValidator.SubstitutionLabelProvider labelProvider, EClass target, Method constraintMethod) {
        String name = constraintMethod.getName();
        String expectedPrefix = String.format("validate%s_validate", target.getName());
        if (name.startsWith(expectedPrefix)) {
            name = name.substring(expectedPrefix.length());
        }
        this.descriptor = new DelegatingConstraintDescriptor(namespace, target, name);
        this.delegate = delegate;
        this.labelProvider = labelProvider;
        this.constraintMethod = constraintMethod;
    }

    public final IConstraintDescriptor getDescriptor() {
        return this.descriptor;
    }

    public IStatus validate(IValidationContext ctx) {
        ConstraintStatus result;
        ContextAdapter ctxAdapter = ContextAdapter.getInstance(ctx);
        BasicDiagnostic diagnostics = ctxAdapter.getDiagnostics();
        Map<Object, Object> contextMap = ctxAdapter.getContextMap();
        try {
            contextMap.put(EValidator.SubstitutionLabelProvider.class, this.labelProvider);
            boolean isOK = (Boolean)this.constraintMethod.invoke((Object)this.delegate, ctx.getTarget(), diagnostics, contextMap);
            if (isOK) {
                result = ctx.createSuccessStatus();
            } else {
                int count = diagnostics.getChildren().size();
                switch (count) {
                    case 0: {
                        result = ctx.createFailureStatus(new Object[]{this.getDescriptor().getName()});
                        break;
                    }
                    case 1: {
                        result = DelegatingModelConstraint.toConstraintStatus(ctx, (Diagnostic)diagnostics.getChildren().get(0));
                        break;
                    }
                    default: {
                        ArrayList<IConstraintStatus> statuses = new ArrayList<IConstraintStatus>(diagnostics.getChildren().size());
                        for (Diagnostic next : diagnostics.getChildren()) {
                            statuses.add(DelegatingModelConstraint.toConstraintStatus(ctx, next));
                        }
                        result = ConstraintStatus.createMultiStatus((IValidationContext)ctx, statuses);
                        break;
                    }
                }
            }
        }
        catch (InvocationTargetException e) {
            ctx.disableCurrentConstraint(e.getTargetException());
            result = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)ctx.getTarget(), (Collection)ctx.getResultLocus(), (int)2, (int)this.getDescriptor().getStatusCode(), (String)UMLPlugin.INSTANCE.getString("_UI_Validation_runtimeError"), (Object[])new Object[]{this.getDescriptor().getException().getMessage()});
        }
        catch (Exception e) {
            ctx.disableCurrentConstraint((Throwable)e);
            result = ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)ctx.getTarget(), (Collection)ctx.getResultLocus(), (int)2, (int)this.getDescriptor().getStatusCode(), (String)UMLPlugin.INSTANCE.getString("_UI_Validation_linkageError"), (Object[])new Object[]{e.getMessage()});
        }
        return result;
    }

    private static IConstraintStatus toConstraintStatus(IValidationContext ctx, Diagnostic diagnostic) {
        EObject target = ctx.getTarget();
        ArrayList<EObject> resultLocus = new ArrayList<EObject>(3);
        for (Object next : diagnostic.getData()) {
            if (next == target || !(next instanceof EObject)) continue;
            resultLocus.add((EObject)next);
        }
        return ConstraintStatus.createStatus((IValidationContext)ctx, (EObject)target, resultLocus, (int)diagnostic.getSeverity(), (int)diagnostic.getCode(), (String)"{0}", (Object[])new Object[]{diagnostic.getMessage()});
    }

    private static final class ContextAdapter {
        private static final Map<IValidationContext, ContextAdapter> contextAdapters = new WeakHashMap<IValidationContext, ContextAdapter>();
        private Map<Object, Object> contextMap = new HashMap<Object, Object>();
        private BasicDiagnostic diagnostics;

        ContextAdapter() {
        }

        static ContextAdapter getInstance(IValidationContext ctx) {
            ContextAdapter result = contextAdapters.get(ctx);
            if (result == null) {
                result = new ContextAdapter();
                contextAdapters.put(ctx, result);
            }
            return result;
        }

        Map<Object, Object> getContextMap() {
            return this.contextMap;
        }

        BasicDiagnostic getDiagnostics() {
            if (this.diagnostics != null && !this.diagnostics.getChildren().isEmpty()) {
                this.diagnostics = null;
            }
            if (this.diagnostics == null) {
                this.diagnostics = new BasicDiagnostic();
            }
            return this.diagnostics;
        }
    }
}

