/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.structure.components;

import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.wb.internal.core.editor.structure.components.IComponentsTree;
import org.eclipse.wb.internal.core.utils.gef.EditPartsContentProvider;
import org.eclipse.wb.internal.core.utils.gef.EditPartsSelectionProvider;
import org.eclipse.wb.internal.core.utils.ui.UiUtils;
import org.eclipse.wb.internal.gef.tree.TreeViewer;

final class ComponentsTreeWrapper
implements IComponentsTree {
    private final TreeViewer m_viewer;
    private final ITreeContentProvider m_contentProvider;
    private final ISelectionProvider m_selectionProvider;
    private Runnable m_expandListener;

    public ComponentsTreeWrapper(TreeViewer viewer) {
        this.m_viewer = viewer;
        this.m_contentProvider = new EditPartsContentProvider(this.m_viewer);
        this.m_selectionProvider = new EditPartsSelectionProvider(this.m_viewer);
        this.m_viewer.getControl().addTreeListener(new TreeListener(){

            public void treeCollapsed(TreeEvent e) {
                if (ComponentsTreeWrapper.this.m_expandListener != null) {
                    ComponentsTreeWrapper.this.m_expandListener.run();
                }
            }

            public void treeExpanded(TreeEvent e) {
                if (ComponentsTreeWrapper.this.m_expandListener != null) {
                    ComponentsTreeWrapper.this.m_expandListener.run();
                }
            }
        });
    }

    @Override
    public ITreeContentProvider getContentProvider() {
        return this.m_contentProvider;
    }

    @Override
    public ISelectionProvider getSelectionProvider() {
        return this.m_selectionProvider;
    }

    @Override
    public Object[] getExpandedElements() {
        TreeItem[] expandedItems = UiUtils.getExpanded(this.m_viewer.getControl());
        Object[] models = new Object[expandedItems.length];
        int i = 0;
        while (i < expandedItems.length) {
            TreeItem treeItem = expandedItems[i];
            EditPart editPart = (EditPart)treeItem.getData();
            models[i] = editPart.getModel();
            ++i;
        }
        return models;
    }

    @Override
    public void setExpandedElements(Object[] elements) {
        Object[] editParts = new EditPart[elements.length];
        int i = 0;
        while (i < elements.length) {
            Object element = elements[i];
            editParts[i] = (EditPart)this.m_viewer.getEditPartRegistry().get(element);
            ++i;
        }
        UiUtils.setExpandedByData(this.m_viewer.getControl(), editParts);
    }

    @Override
    public void setExpandListener(Runnable listener) {
        this.m_expandListener = listener;
    }
}

