/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.table.editparts;

import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.Request;
import org.eclipse.gef.requests.SelectionRequest;
import org.eclipse.gef.tools.TargetingTool;
import org.eclipse.wb.internal.core.model.property.table.PropertyTable;

public class PropertyEditPartTracker
extends TargetingTool
implements DragTracker {
    private EditPart owner;

    public PropertyEditPartTracker(EditPart owner) {
        this.owner = owner;
    }

    private boolean isLocationSplitter() {
        EditPartViewer editPartViewer = this.getCurrentViewer();
        if (editPartViewer instanceof PropertyTable) {
            PropertyTable propertyTable = (PropertyTable)editPartViewer;
            return Math.abs(propertyTable.getSplitter() - this.getLocation().x) < 2;
        }
        return false;
    }

    protected boolean handleButtonDown(int button) {
        if (this.isLocationSplitter() || button != 1) {
            return false;
        }
        this.getCurrentViewer().select(this.owner);
        SelectionRequest request = new SelectionRequest();
        request.setType((Object)"selection");
        request.setLocation(this.getLocation());
        this.owner.performRequest((Request)request);
        return true;
    }

    protected String getCommandName() {
        return "Property Tracker";
    }
}

