/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.swt.model.jface.resource;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.jface.resource.ResourceRegistry;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.model.creation.CreationSupport;
import org.eclipse.wb.internal.core.model.description.ComponentDescription;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.reflect.ReflectionUtils;
import org.eclipse.wb.internal.core.utils.state.EditorState;
import org.eclipse.wb.internal.swt.model.jface.resource.KeyFieldInfo;

public abstract class ResourceRegistryInfo
extends JavaInfo {
    private final List<KeyFieldInfo> m_fields;

    public ResourceRegistryInfo(AstEditor editor, ComponentDescription description, CreationSupport creationSupport) throws Exception {
        super(editor, description, creationSupport);
        Class<?> displayClass = EditorState.get((AstEditor)editor).getEditorLoader().loadClass("org.eclipse.swt.widgets.Display");
        ReflectionUtils.invokeMethod(displayClass, (String)"getDefault()", (Object[])new Object[0]);
        this.m_fields = ResourceRegistryInfo.getKeyFields(this.getDescription().getComponentClass());
    }

    public final List<KeyFieldInfo> getKeyFields() {
        return this.m_fields;
    }

    public abstract Runnable getDisposeRunnable();

    private static List<KeyFieldInfo> getKeyFields(Class<?> registryClass) throws Exception {
        ArrayList<KeyFieldInfo> fields = new ArrayList<KeyFieldInfo>();
        Field[] fieldArray = registryClass.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (Modifier.isStatic(field.getModifiers()) && field.getType() == String.class) {
                Class<?> declaringClass = field.getDeclaringClass();
                String keyName = field.getName();
                String keyValue = (String)field.get(null);
                fields.add(new KeyFieldInfo(declaringClass, keyName, keyValue));
            }
            ++n2;
        }
        Collections.sort(fields, new Comparator<KeyFieldInfo>(){

            @Override
            public int compare(KeyFieldInfo info1, KeyFieldInfo info2) {
                return info1.keyName.compareTo(info2.keyName);
            }
        });
        return fields;
    }

    public ResourceRegistry getResourceRegistry() {
        return (ResourceRegistry)this.getObject();
    }
}

