/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.imports;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.conversion.IValueConverter;
import org.eclipse.xtext.formatting.IWhitespaceInformationProvider;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.util.IAcceptor;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.ReplaceRegion;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.util.TextRegion;
import org.eclipse.xtext.xbase.conversion.XbaseQualifiedNameValueConverter;
import org.eclipse.xtext.xbase.imports.IImportsConfiguration;
import org.eclipse.xtext.xbase.imports.IMutableImportsConfiguration;
import org.eclipse.xtext.xbase.imports.ImportSectionRegionUtil;
import org.eclipse.xtext.xbase.typesystem.util.Maps2;
import org.eclipse.xtext.xtype.XImportDeclaration;
import org.eclipse.xtext.xtype.XImportSection;
import org.eclipse.xtext.xtype.XtypeFactory;

public class RewritableImportSection {
    private List<XImportDeclaration> originalImportDeclarations = Lists.newArrayList();
    private List<XImportDeclaration> addedImportDeclarations = Lists.newArrayList();
    private Set<XImportDeclaration> removedImportDeclarations = Sets.newLinkedHashSet();
    private Map<String, List<JvmDeclaredType>> plainImports = Maps.newHashMap();
    private Map<JvmDeclaredType, Set<String>> staticImports = Maps.newHashMap();
    private Map<JvmDeclaredType, Set<String>> staticExtensionImports = Maps.newHashMap();
    private String lineSeparator;
    private XtextResource resource;
    private ImportSectionRegionUtil regionUtil;
    private boolean isSort;
    private Set<String> implicitlyImportedPackages;
    private IValueConverter<String> nameValueConverter;
    private ITextRegion importRegion;
    private IImportsConfiguration importsConfiguration;
    private boolean enabled = true;

    public RewritableImportSection(XtextResource resource, IImportsConfiguration importsConfiguration, XImportSection originalImportSection, String lineSeparator, ImportSectionRegionUtil regionUtil, IValueConverter<String> nameConverter) {
        this.importsConfiguration = importsConfiguration;
        this.resource = resource;
        this.lineSeparator = lineSeparator;
        this.regionUtil = regionUtil;
        this.nameValueConverter = nameConverter;
        this.implicitlyImportedPackages = importsConfiguration.getImplicitlyImportedPackages(resource);
        this.importRegion = regionUtil.computeRegion(resource);
        if (originalImportSection != null) {
            for (XImportDeclaration originalImportDeclaration : originalImportSection.getImportDeclarations()) {
                this.originalImportDeclarations.add(originalImportDeclaration);
                JvmDeclaredType importedType = originalImportDeclaration.getImportedType();
                if (originalImportDeclaration.isStatic()) {
                    String memberName = originalImportDeclaration.getMemberName();
                    if (originalImportDeclaration.isExtension()) {
                        Maps2.putIntoSetMap(importedType, memberName, this.staticExtensionImports);
                        continue;
                    }
                    Maps2.putIntoSetMap(importedType, memberName, this.staticImports);
                    continue;
                }
                if (importedType == null) continue;
                Maps2.putIntoListMap(importedType.getSimpleName(), importedType, this.plainImports);
            }
        }
    }

    public void setSort(boolean isSort) {
        this.isSort = isSort;
    }

    public boolean isSort() {
        return this.isSort;
    }

    public boolean addImport(JvmDeclaredType type) {
        if (this.plainImports.containsKey(type.getSimpleName()) || !this.needsImport(type)) {
            return false;
        }
        Maps2.putIntoListMap(type.getSimpleName(), type, this.plainImports);
        XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        importDeclaration.setImportedType(type);
        this.addedImportDeclarations.add(importDeclaration);
        return true;
    }

    public boolean addImport(String fqn) {
        if (!this.needsImport(fqn)) {
            return false;
        }
        return this.addedImportDeclarations.add(this.createImport(fqn, null));
    }

    protected XImportDeclaration createImport(String importedNamespace, String member) {
        XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        importDeclaration.setImportedNamespace(importedNamespace);
        if (member != null) {
            importDeclaration.setMemberName(member);
        }
        return importDeclaration;
    }

    protected boolean needsImport(String fqn) {
        for (String string : this.implicitlyImportedPackages) {
            if (!fqn.startsWith(string)) continue;
            return fqn.substring(string.length() + 1).lastIndexOf(46) > 0;
        }
        for (XImportDeclaration importDeclr : this.originalImportDeclarations) {
            if (importDeclr.isStatic() || !fqn.equals(importDeclr.getImportedTypeName())) continue;
            return false;
        }
        for (XImportDeclaration importDeclr : this.addedImportDeclarations) {
            String identifier = importDeclr.getImportedTypeName();
            if (importDeclr.isStatic() || !fqn.equals(identifier)) continue;
            return false;
        }
        return true;
    }

    public boolean needsImport(JvmDeclaredType type) {
        if (type.getDeclaringType() != null) {
            return true;
        }
        String packageName = type.getPackageName();
        return packageName != null && !this.implicitlyImportedPackages.contains(packageName);
    }

    public boolean removeImport(JvmDeclaredType type) {
        List<XImportDeclaration> addedImportDeclarationsToRemove = this.findOriginalImports(type, null, this.addedImportDeclarations, false, false);
        this.addedImportDeclarations.removeAll(addedImportDeclarationsToRemove);
        List<XImportDeclaration> originalImportDeclarationsToRemove = this.findOriginalImports(type, null, this.originalImportDeclarations, false, false);
        this.removedImportDeclarations.addAll(originalImportDeclarationsToRemove);
        for (Map.Entry<String, List<JvmDeclaredType>> entry : this.plainImports.entrySet()) {
            List<JvmDeclaredType> values = entry.getValue();
            if (values.size() == 1 && values.get(0) == type) {
                this.plainImports.remove(type.getSimpleName());
                return true;
            }
            Iterator<JvmDeclaredType> iterator = values.iterator();
            while (iterator.hasNext()) {
                JvmDeclaredType value = iterator.next();
                if (value != type) continue;
                iterator.remove();
                return true;
            }
        }
        return false;
    }

    protected List<XImportDeclaration> findOriginalImports(JvmDeclaredType type, String memberName, Collection<XImportDeclaration> list, boolean isStatic, boolean isExtension) {
        ArrayList result = Lists.newArrayList();
        for (XImportDeclaration importDeclaration : list) {
            if (isStatic ^ importDeclaration.isStatic() || isExtension ^ importDeclaration.isExtension() || importDeclaration.getImportedType() != type || memberName != null && !memberName.equals(importDeclaration.getMemberName())) continue;
            result.add(importDeclaration);
        }
        return result;
    }

    public boolean hasImportedType(JvmDeclaredType type) {
        List<JvmDeclaredType> importedTypes = this.getImportedTypes(type.getSimpleName());
        if (importedTypes == null) {
            return false;
        }
        for (JvmDeclaredType importedType : importedTypes) {
            if (importedType != type) continue;
            return true;
        }
        return false;
    }

    public List<JvmDeclaredType> getImportedTypes(String simpleName) {
        return this.plainImports.get(simpleName);
    }

    public boolean addStaticImport(JvmMember member) {
        if (member instanceof JvmDeclaredType) {
            return this.addStaticImport((JvmDeclaredType)member, null);
        }
        return this.addStaticImport(member.getDeclaringType(), member.getSimpleName());
    }

    public boolean addStaticImport(JvmDeclaredType type, String memberName) {
        if (this.hasStaticImport(this.staticImports, type, memberName)) {
            return false;
        }
        Maps2.putIntoSetMap(type, memberName, this.staticImports);
        XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        importDeclaration.setImportedType(type);
        importDeclaration.setStatic(true);
        if (memberName == null) {
            importDeclaration.setWildcard(true);
        } else {
            importDeclaration.setMemberName(memberName);
        }
        this.addedImportDeclarations.add(importDeclaration);
        return true;
    }

    public boolean addStaticImport(String typeFqn, String member) {
        if (typeFqn == null || member == null) {
            throw new IllegalArgumentException("Type name " + typeFqn + ". Member name: " + member);
        }
        if (this.hasStaticImport(typeFqn, member, false)) {
            return false;
        }
        XImportDeclaration importDecl = this.createImport(typeFqn, member);
        importDecl.setStatic(true);
        return this.addedImportDeclarations.add(importDecl);
    }

    public boolean addStaticExtensionImport(String typeFqn, String member) {
        if (typeFqn == null || member == null) {
            throw new IllegalArgumentException("Type name " + typeFqn + ". Member name: " + member);
        }
        if (this.hasStaticImport(typeFqn, member, true)) {
            return false;
        }
        XImportDeclaration importDecl = this.createImport(typeFqn, member);
        importDecl.setStatic(true);
        importDecl.setExtension(true);
        return this.addedImportDeclarations.add(importDecl);
    }

    public boolean removeStaticImport(JvmDeclaredType type, String memberName) {
        return this.removeStaticImport(this.staticImports, type, memberName, true, false);
    }

    public boolean addStaticExtensionImport(JvmMember member) {
        if (member instanceof JvmDeclaredType) {
            return this.addStaticExtensionImport((JvmDeclaredType)member, null);
        }
        return this.addStaticExtensionImport(member.getDeclaringType(), member.getSimpleName());
    }

    public boolean addStaticExtensionImport(JvmDeclaredType type, String memberName) {
        if (this.hasStaticImport(this.staticExtensionImports, type, memberName)) {
            return false;
        }
        Maps2.putIntoSetMap(type, memberName, this.staticExtensionImports);
        XImportDeclaration importDeclaration = XtypeFactory.eINSTANCE.createXImportDeclaration();
        importDeclaration.setImportedType(type);
        importDeclaration.setStatic(true);
        importDeclaration.setExtension(true);
        if (memberName == null) {
            importDeclaration.setWildcard(true);
        } else {
            importDeclaration.setMemberName(memberName);
        }
        this.addedImportDeclarations.add(importDeclaration);
        return true;
    }

    public boolean removeStaticExtensionImport(JvmDeclaredType type, String memberName) {
        return this.removeStaticImport(this.staticExtensionImports, type, memberName, true, true);
    }

    protected boolean removeStaticImport(Map<JvmDeclaredType, Set<String>> staticImports, JvmDeclaredType type, String memberName, boolean isStatic, boolean isExtension) {
        List<XImportDeclaration> originalImportDeclarationsToRemove = this.findOriginalImports(type, memberName, this.originalImportDeclarations, isStatic, isExtension);
        this.removedImportDeclarations.addAll(originalImportDeclarationsToRemove);
        List<XImportDeclaration> addedImportDeclarationsToRemove = this.findOriginalImports(type, memberName, this.addedImportDeclarations, isStatic, isExtension);
        this.addedImportDeclarations.removeAll(addedImportDeclarationsToRemove);
        Set<String> members = staticImports.get(type);
        return members != null && members.remove(memberName);
    }

    public void update() {
        XImportSection importSection = this.importsConfiguration.getImportSection(this.resource);
        if (importSection == null && this.importsConfiguration instanceof IMutableImportsConfiguration) {
            importSection = XtypeFactory.eINSTANCE.createXImportSection();
            IMutableImportsConfiguration mutableImportsConfiguration = (IMutableImportsConfiguration)this.importsConfiguration;
            mutableImportsConfiguration.setImportSection(this.resource, importSection);
        }
        if (importSection == null) {
            return;
        }
        this.removeObsoleteStaticImports();
        ArrayList allImportDeclarations = Lists.newArrayList();
        allImportDeclarations.addAll(this.originalImportDeclarations);
        allImportDeclarations.addAll(this.addedImportDeclarations);
        allImportDeclarations.removeAll(this.removedImportDeclarations);
        EList<XImportDeclaration> importDeclarations = importSection.getImportDeclarations();
        importDeclarations.clear();
        importDeclarations.addAll(allImportDeclarations);
    }

    public List<ReplaceRegion> rewrite() {
        this.removeObsoleteStaticImports();
        final ArrayList replaceRegions = Lists.newArrayList();
        if (this.isSort) {
            ArrayList allImportDeclarations = Lists.newArrayList();
            allImportDeclarations.addAll(this.originalImportDeclarations);
            allImportDeclarations.addAll(this.addedImportDeclarations);
            allImportDeclarations.removeAll(this.removedImportDeclarations);
            String newImportSection = this.serializeImports(allImportDeclarations);
            this.importRegion = this.regionUtil.addLeadingWhitespace(this.importRegion, this.resource);
            this.importRegion = this.regionUtil.addTrailingWhitespace(this.importRegion, this.resource);
            return Collections.singletonList(new ReplaceRegion(this.importRegion, newImportSection));
        }
        for (XImportDeclaration removedImportDeclaration : this.removedImportDeclarations) {
            ICompositeNode node = NodeModelUtils.findActualNodeFor((EObject)removedImportDeclaration);
            if (node == null) continue;
            ITextRegion textRegion = node.getTextRegion();
            textRegion = this.regionUtil.addTrailingSingleWhitespace(textRegion, this.lineSeparator, this.resource);
            replaceRegions.add(new ReplaceRegion(textRegion, ""));
        }
        this.addSectionToAppend(new IAcceptor<ReplaceRegion>(){

            public void accept(ReplaceRegion t) {
                replaceRegions.add(t);
            }
        });
        return replaceRegions;
    }

    private void removeObsoleteStaticImports() {
        for (Map.Entry<JvmDeclaredType, Set<String>> staticExtensionImport : this.staticExtensionImports.entrySet()) {
            JvmDeclaredType type = staticExtensionImport.getKey();
            Set<String> memberNames = this.staticImports.get(type);
            if (memberNames == null) continue;
            for (String memberName : staticExtensionImport.getValue()) {
                if (!memberNames.contains(memberName)) continue;
                this.removeStaticImport(type, memberName);
            }
        }
    }

    protected void addSectionToAppend(IAcceptor<ReplaceRegion> acceptor) {
        StringBuilder importDeclarationsToAppend = this.getImportDeclarationsToAppend();
        if (importDeclarationsToAppend.length() == 0) {
            return;
        }
        this.importRegion = this.regionUtil.addLeadingWhitespace(this.importRegion, this.resource);
        this.importRegion = this.regionUtil.addTrailingSingleWhitespace(this.importRegion, this.lineSeparator, this.resource);
        int insertOffset = this.importRegion.getEndOffset();
        if (insertOffset != 0 && this.originalImportDeclarations.isEmpty()) {
            importDeclarationsToAppend.insert(0, this.lineSeparator);
        }
        importDeclarationsToAppend.append(this.lineSeparator);
        int insertLength = -this.importRegion.getLength();
        ReplaceRegion appendDeclarations = new ReplaceRegion((ITextRegion)new TextRegion(insertOffset, insertLength += this.regionUtil.addTrailingWhitespace(this.importRegion, this.resource).getLength()), importDeclarationsToAppend.toString());
        acceptor.accept((Object)appendDeclarations);
    }

    protected StringBuilder getImportDeclarationsToAppend() {
        StringBuilder builder = new StringBuilder();
        for (XImportDeclaration newImportDeclaration : this.addedImportDeclarations) {
            this.appendImport(builder, newImportDeclaration);
        }
        return builder;
    }

    protected void appendImport(StringBuilder builder, XImportDeclaration newImportDeclaration) {
        builder.append("import ");
        if (newImportDeclaration.isStatic()) {
            builder.append("static ");
            if (newImportDeclaration.isExtension()) {
                builder.append("extension ");
            }
        }
        String qualifiedTypeName = newImportDeclaration.getImportedNamespace();
        if (newImportDeclaration.getImportedType() != null) {
            qualifiedTypeName = this.serializeType(newImportDeclaration.getImportedType());
        }
        String escapedTypeName = this.nameValueConverter.toString((Object)qualifiedTypeName);
        builder.append(escapedTypeName);
        if (newImportDeclaration.isStatic()) {
            builder.append(".");
            if (newImportDeclaration.isWildcard()) {
                builder.append("*");
            } else {
                builder.append(newImportDeclaration.getMemberName());
            }
        }
        builder.append(this.lineSeparator);
    }

    protected String serializeType(JvmDeclaredType type) {
        return type.getQualifiedName('.');
    }

    protected String serializeImports(List<XImportDeclaration> allDeclarations) {
        StringBuilder builder = new StringBuilder();
        if (this.needsPreceedingBlankLine()) {
            builder.append(this.lineSeparator).append(this.lineSeparator);
        }
        boolean needNewline = this.appendSubsection(builder, Iterables.filter(allDeclarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration input) {
                return !input.isStatic();
            }
        }), false);
        needNewline = this.appendSubsection(builder, Iterables.filter(allDeclarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration input) {
                return input.isStatic() && !input.isExtension();
            }
        }), needNewline);
        this.appendSubsection(builder, Iterables.filter(allDeclarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration input) {
                return input.isStatic() && input.isExtension();
            }
        }), needNewline);
        if (!Iterables.isEmpty(allDeclarations)) {
            builder.append(this.lineSeparator);
        }
        return builder.toString();
    }

    protected boolean needsPreceedingBlankLine() {
        return this.regionUtil.addLeadingWhitespace(this.importRegion, this.resource).getOffset() != 0;
    }

    protected boolean appendSubsection(StringBuilder builder, Iterable<XImportDeclaration> subSection, boolean needsNewline) {
        if (!Iterables.isEmpty(subSection)) {
            if (needsNewline) {
                builder.append(this.lineSeparator);
            }
            for (XImportDeclaration declaration : this.isSort() ? this.sort(subSection) : subSection) {
                this.appendImport(builder, declaration);
            }
            return true;
        }
        return needsNewline;
    }

    protected List<XImportDeclaration> sort(Iterable<XImportDeclaration> declarations) {
        ArrayList sortMe = Lists.newArrayList((Iterable)Iterables.filter(declarations, (Predicate)new Predicate<XImportDeclaration>(){

            public boolean apply(XImportDeclaration in) {
                return !Strings.isEmpty((String)in.getImportedTypeName());
            }
        }));
        Collections.sort(sortMe, new Comparator<XImportDeclaration>(){

            @Override
            public int compare(XImportDeclaration o1, XImportDeclaration o2) {
                return o1.getImportedName().compareTo(o2.getImportedName());
            }
        });
        return sortMe;
    }

    public boolean hasStaticImport(JvmDeclaredType declaringType, String memberName, boolean extension) {
        if (extension) {
            return this.hasStaticImport(this.staticExtensionImports, declaringType, memberName);
        }
        return this.hasStaticImport(this.staticImports, declaringType, memberName);
    }

    private boolean hasStaticImport(Map<JvmDeclaredType, Set<String>> imports, JvmDeclaredType declaringType, String memberName) {
        Set<String> members = imports.get(declaringType);
        return members != null && members.contains(memberName);
    }

    public boolean hasStaticImport(String memberName, boolean extension) {
        if (extension) {
            return this.hasStaticImport(this.staticExtensionImports, memberName);
        }
        return this.hasStaticImport(this.staticImports, memberName);
    }

    private boolean hasStaticImport(Map<JvmDeclaredType, Set<String>> imports, String memberName) {
        for (Map.Entry<JvmDeclaredType, Set<String>> entry : imports.entrySet()) {
            Set<String> value = entry.getValue();
            if (value == null || !value.contains(memberName)) continue;
            return true;
        }
        return false;
    }

    private boolean hasStaticImport(String typeName, String memberName, boolean extension) {
        for (String string : this.implicitlyImportedPackages) {
            if (!typeName.startsWith(string)) continue;
            return typeName.substring(string.length()).lastIndexOf(46) == 0;
        }
        Map<JvmDeclaredType, Set<String>> imports = this.staticImports;
        if (extension) {
            imports = this.staticExtensionImports;
        }
        for (JvmDeclaredType type : imports.keySet()) {
            if (!typeName.equals(type.getIdentifier())) continue;
            Set<String> members = imports.get(type);
            return members != null && (members.contains(memberName) || members.contains(null));
        }
        for (XImportDeclaration importDeclr : this.addedImportDeclarations) {
            String identifier = importDeclr.getImportedTypeName();
            if (!importDeclr.isStatic() || !typeName.equals(identifier) || !Objects.equals(importDeclr.getMemberName(), memberName) && !importDeclr.isWildcard() && !"*".equals(importDeclr.getMemberName())) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static class Factory {
        public static final String REWRITABLEIMPORTSECTION_ENABLEMENT = "RewritableImportSection_Enablement";
        @Inject(optional=true)
        @Named(value="RewritableImportSection_Enablement")
        private boolean enabled = true;
        @Inject
        private IImportsConfiguration importsConfiguration;
        @Inject
        private IWhitespaceInformationProvider whitespaceInformationProvider;
        @Inject
        private ImportSectionRegionUtil regionUtil;
        @Inject
        private XbaseQualifiedNameValueConverter nameValueConverter;

        public RewritableImportSection parse(XtextResource resource) {
            RewritableImportSection rewritableImportSection = new RewritableImportSection(resource, this.importsConfiguration, this.importsConfiguration.getImportSection(resource), this.getLineSeparator(resource), this.regionUtil, (IValueConverter<String>)this.nameValueConverter);
            rewritableImportSection.setEnabled(this.enabled);
            return rewritableImportSection;
        }

        public RewritableImportSection createNewEmpty(XtextResource resource) {
            RewritableImportSection rewritableImportSection = new RewritableImportSection(resource, this.importsConfiguration, null, this.getLineSeparator(resource), this.regionUtil, (IValueConverter<String>)this.nameValueConverter);
            rewritableImportSection.setSort(true);
            rewritableImportSection.setEnabled(this.enabled);
            return rewritableImportSection;
        }

        protected String getLineSeparator(XtextResource resource) {
            return this.whitespaceInformationProvider.getLineSeparatorInformation(resource.getURI()).getLineSeparator();
        }
    }
}

