/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.layout.pdf;

import org.eclipse.birt.report.engine.content.IContent;
import org.eclipse.birt.report.engine.content.IStyle;
import org.eclipse.birt.report.engine.extension.IReportItemExecutor;
import org.eclipse.birt.report.engine.layout.IBlockStackingLayoutManager;
import org.eclipse.birt.report.engine.layout.area.impl.AreaFactory;
import org.eclipse.birt.report.engine.layout.area.impl.ContainerArea;
import org.eclipse.birt.report.engine.layout.pdf.PDFBlockStackingLM;
import org.eclipse.birt.report.engine.layout.pdf.PDFLayoutEngineContext;
import org.eclipse.birt.report.engine.layout.pdf.PDFStackingLM;

public class PDFTextInlineBlockLM
extends PDFBlockStackingLM
implements IBlockStackingLayoutManager {
    public PDFTextInlineBlockLM(PDFLayoutEngineContext context, PDFStackingLM parent, IContent content, IReportItemExecutor executor) {
        super(context, parent, content, executor);
    }

    @Override
    protected void initialize() {
        boolean isNewArea = this.root == null;
        this.createRoot();
        if (isNewArea) {
            IStyle areaStyle = this.root.getStyle();
            this.validateBoxProperty(areaStyle, this.parent.getCurrentMaxContentWidth(), this.context.getMaxHeight());
            this.setOffsetX(this.root.getContentX());
            this.setOffsetY(this.isFirst ? this.root.getContentY() : 0);
            int maxWidth = this.parent.getCurrentMaxContentWidth();
            this.calculateSpecifiedWidth();
            int width = maxWidth;
            if (this.specifiedWidth > 0) {
                width = Math.min(this.specifiedWidth, maxWidth);
            }
            this.root.setAllocatedWidth(width);
            this.setCurrentBP(0);
            this.setCurrentIP(0);
        }
        this.maxAvaWidth = this.root.getContentWidth();
        this.root.setAllocatedHeight(this.parent.getCurrentMaxContentHeight());
        this.maxAvaHeight = this.root.getContentHeight();
    }

    @Override
    protected void createRoot() {
        if (this.root == null) {
            this.root = (ContainerArea)AreaFactory.createBlockContainer(this.content);
        }
    }
}

