/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.List;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.buildship.core.preferences.internal.DefaultPersistentModel;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;

public final class PersistentModelBuilder {
    private final PersistentModel previous;
    private IPath buildDir;
    private Collection<IPath> subprojectPaths;
    private List<IClasspathEntry> classpath;
    private Collection<IPath> derivedResources;
    private Collection<IPath> linkedResources;

    public PersistentModelBuilder(PersistentModel previous) {
        this.previous = (PersistentModel)Preconditions.checkNotNull((Object)previous);
        if (previous.isPresent()) {
            this.buildDir = previous.getBuildDir();
            this.subprojectPaths = previous.getSubprojectPaths();
            this.classpath = previous.getClasspath();
            this.derivedResources = previous.getDerivedResources();
            this.linkedResources = previous.getLinkedResources();
        }
    }

    public PersistentModelBuilder buildDir(IPath buildDir) {
        this.buildDir = buildDir;
        return this;
    }

    public PersistentModelBuilder subprojectPaths(Collection<IPath> subprojectPaths) {
        this.subprojectPaths = subprojectPaths;
        return this;
    }

    public PersistentModelBuilder classpath(List<IClasspathEntry> classpath) {
        this.classpath = classpath;
        return this;
    }

    public PersistentModelBuilder derivedResources(Collection<IPath> derivedResources) {
        this.derivedResources = derivedResources;
        return this;
    }

    public PersistentModelBuilder linkedResources(Collection<IPath> linkedResources) {
        this.linkedResources = linkedResources;
        return this;
    }

    public PersistentModel getPrevious() {
        return this.previous;
    }

    public PersistentModel build() {
        return new DefaultPersistentModel(this.previous.getProject(), this.buildDir, this.subprojectPaths, this.classpath, this.derivedResources, this.linkedResources);
    }
}

