/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.tools.emf.ui.internal.wbm;

import java.io.IOException;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import javax.inject.Named;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Optional;
import org.eclipse.e4.tools.emf.ui.common.IModelResource;
import org.eclipse.e4.tools.emf.ui.internal.common.ModelEditor;
import org.eclipse.e4.tools.services.IResourcePool;
import org.eclipse.e4.ui.di.UISynchronize;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.workbench.modeling.EPartService;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.FrameworkUtil;

public class ApplicationModelEditor
extends ModelEditor {
    private static final String EDITORPROJECT = "org.eclipse.e4.tools.emf.ui.editorproject";
    @Inject
    @Optional
    MPart part;
    @Inject
    EPartService partService;
    private Resource resource;
    private IProject project;
    @Inject
    Shell shell;
    @Inject
    UISynchronize sync;
    private IResourceChangeListener listener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent event) {
            if (event.getType() == 2 || event.getType() == 4) {
                if (event.getResource().equals((Object)ApplicationModelEditor.this.project)) {
                    this.hidePart(true);
                }
                return;
            }
            if (ApplicationModelEditor.this.resource == null) {
                return;
            }
            IResourceDelta delta = event.getDelta().findMember((IPath)new Path(ApplicationModelEditor.this.resource.getURI().toPlatformString(false)));
            if (delta == null) {
                return;
            }
            if (delta.getKind() == 2) {
                this.hidePart(true);
            }
            if (!ApplicationModelEditor.this.isSaving() && delta.getKind() == 4 && delta.getMarkerDeltas().length == 0) {
                ApplicationModelEditor.this.reloadModel();
            }
        }

        private void hidePart(final boolean force) {
            ApplicationModelEditor.this.sync.asyncExec(new Runnable(){

                @Override
                public void run() {
                    (this).ApplicationModelEditor.this.partService.hidePart((this).ApplicationModelEditor.this.part, force);
                }
            });
        }
    };

    @Inject
    public ApplicationModelEditor(Composite composite, IEclipseContext context, IModelResource modelProvider, @Named(value="org.eclipse.e4.tools.emf.ui.editorproject") @Optional IProject project, IResourcePool resourcePool) {
        super(composite, context, modelProvider, project, resourcePool);
        EList resources = modelProvider.getEditingDomain().getResourceSet().getResources();
        if (!resources.isEmpty()) {
            this.resource = (Resource)resources.get(0);
        }
    }

    @Inject
    public void addResourceListener(@Named(value="org.eclipse.e4.tools.emf.ui.editorproject") @Optional IProject project) {
        if (project != null && this.resource != null) {
            this.project = project;
            project.getWorkspace().addResourceChangeListener(this.listener);
        }
    }

    @PreDestroy
    private void removeResourceListener() {
        if (this.project != null) {
            this.project.getWorkspace().removeResourceChangeListener(this.listener);
        }
    }

    protected void statusDialog(final Exception exc) {
        try {
            this.sync.syncExec(new Runnable(){

                @Override
                public void run() {
                    String bundle = FrameworkUtil.getBundle(this.getClass()).getSymbolicName();
                    Status status = new Status(4, bundle, exc.getMessage());
                    ErrorDialog.openError((Shell)ApplicationModelEditor.this.shell, (String)exc.getMessage(), (String)exc.getMessage(), (IStatus)status);
                    exc.printStackTrace(System.err);
                }
            });
        }
        catch (Exception exception) {}
    }

    protected void reloadModel() {
        this.getModelProvider().getRoot().getRealm().asyncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    ApplicationModelEditor.this.resource.unload();
                    ApplicationModelEditor.this.resource.load(null);
                    ApplicationModelEditor.this.getModelProvider().replaceRoot((EObject)ApplicationModelEditor.this.resource.getContents().get(0));
                    ApplicationModelEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    ApplicationModelEditor.this.statusDialog(e);
                }
            }
        });
    }
}

