/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.facet.widgets.table.ui.nattable.internal.nattable;

import java.util.List;
import net.sourceforge.nattable.NatTable;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.cell.LayerCell;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.facet.util.core.Logger;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.Column;
import org.eclipse.emf.facet.widgets.table.metamodel.v0_2_0.table.FeatureColumn;
import org.eclipse.emf.facet.widgets.table.ui.internal.exported.IGridElement;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Activator;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.Messages;
import org.eclipse.emf.facet.widgets.table.ui.nattable.internal.NatTableWidget;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.graphics.Point;

public class NatTableDropListener
implements DropTargetListener {
    private final NatTable natTable;
    private final NatTableWidget natTableWidget;

    public NatTableDropListener(NatTable fNatTable, NatTableWidget natTableWidget) {
        this.natTable = fNatTable;
        this.natTableWidget = natTableWidget;
    }

    public void dragEnter(DropTargetEvent event) {
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
        IGridElement gridElement;
        LocalTransfer localTransfer = LocalTransfer.getInstance();
        Object data = localTransfer.nativeToJava(event.currentDataType);
        List<PositionCoordinate> selectedCellsPositions = this.natTableWidget.getSelectedCellsPositionCoordinates();
        Point point = this.natTableWidget.toControl(event.x, event.y);
        PositionCoordinate cellPosition = this.natTableWidget.getCellPositionAt(point.x, point.y);
        if (cellPosition == null) {
            if (selectedCellsPositions.size() != 0) {
                this.natTableWidget.getBodyLayer().getSelectionLayer().clear();
                this.natTable.redraw();
            }
            event.detail = 1;
            return;
        }
        if (selectedCellsPositions.size() != 1 || !selectedCellsPositions.get(0).equals((Object)cellPosition)) {
            this.natTableWidget.getBodyLayer().getSelectionLayer().selectCell(cellPosition.getColumnPosition(), cellPosition.getRowPosition(), false, false);
            this.natTable.redraw();
        }
        IStructuredSelection structuredSelection = null;
        if (data instanceof IStructuredSelection) {
            structuredSelection = (IStructuredSelection)data;
        }
        event.detail = (gridElement = this.getGridElement(cellPosition)) == null || !this.canDropOn(gridElement, structuredSelection) ? 0 : 16;
    }

    private boolean canDropOn(IGridElement gridElement, IStructuredSelection structuredSelection) {
        FeatureColumn featureColumn;
        ETypedElement feature;
        boolean result = false;
        Column column = gridElement.getColumn();
        if (column instanceof FeatureColumn && (feature = (featureColumn = (FeatureColumn)column).getFeature()) instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)feature;
            result = this.canDropOnFeature(gridElement, structuredSelection, structuralFeature);
        }
        return result;
    }

    private boolean canDropOnFeature(IGridElement gridElement, IStructuredSelection structuredSelection, EStructuralFeature feature) {
        if (feature.getEType() instanceof EClass) {
            EClass eClass = (EClass)feature.getEType();
            Object element = gridElement.getElement();
            if (element instanceof EObject) {
                EObject eObject = (EObject)element;
                if (!eObject.eClass().getEAllStructuralFeatures().contains((Object)feature)) {
                    return false;
                }
                if (structuredSelection != null) {
                    int nElements = 0;
                    for (Object object : structuredSelection) {
                        if (++nElements > 1 && !feature.isMany()) {
                            return false;
                        }
                        if (eClass.isInstance(object)) continue;
                        return false;
                    }
                    return this.natTableWidget.getController().canBeDropped(structuredSelection, feature, element);
                }
                return true;
            }
        }
        return false;
    }

    public void drop(DropTargetEvent event) {
        Point point = this.natTableWidget.toControl(event.x, event.y);
        PositionCoordinate cellPosition = this.natTableWidget.getCellPositionAt(point.x, point.y);
        if (event.data instanceof StructuredSelection) {
            StructuredSelection structuredSelection = (StructuredSelection)event.data;
            if (cellPosition == null) {
                this.natTableWidget.getController().drop(structuredSelection);
            } else {
                IGridElement gridElement = this.getGridElement(cellPosition);
                if (gridElement != null) {
                    this.dropOnGridElement(structuredSelection, gridElement);
                }
            }
        }
    }

    private IGridElement getGridElement(PositionCoordinate cellPosition) {
        Object dataValue;
        LayerCell cell = this.natTableWidget.getCellAt(cellPosition.getColumnPosition(), cellPosition.getRowPosition());
        if (cell != null && (dataValue = cell.getDataValue()) instanceof IGridElement) {
            IGridElement gridElement = (IGridElement)dataValue;
            return gridElement;
        }
        return null;
    }

    private void dropOnGridElement(StructuredSelection structuredSelection, IGridElement gridElement) {
        Column column = gridElement.getColumn();
        if (column instanceof FeatureColumn) {
            FeatureColumn featureColumn = (FeatureColumn)column;
            if (featureColumn.getFeature() instanceof EStructuralFeature) {
                EStructuralFeature structuralFeature = (EStructuralFeature)featureColumn.getFeature();
                this.dropOnFeature(structuredSelection, gridElement.getElement(), structuralFeature);
            } else {
                Logger.logError((String)("unhandled case:" + column.eClass().getName()), (Plugin)Activator.getDefault());
            }
        } else {
            Logger.logError((String)("unhandled case:" + column.eClass().getName()), (Plugin)Activator.getDefault());
        }
    }

    private void dropOnFeature(StructuredSelection structuredSelection, Object element, EStructuralFeature feature) {
        if (!this.confirmMove((EObject)element, feature)) {
            return;
        }
        this.natTableWidget.getController().drop(structuredSelection, element, feature);
    }

    private boolean confirmMove(EObject eObject, EStructuralFeature feature) {
        EReference reference;
        if (feature instanceof EReference && (reference = (EReference)feature).isContainment()) {
            Object list = eObject.eGet(feature);
            boolean empty = list == null || list instanceof List && ((List)list).isEmpty();
            String message = !empty && !feature.isMany() ? Messages.NatTableDropListener_valueWillBeMovedAndPreviousLost : Messages.NatTableDropListener_valueWillBeMoved;
            String fullMessage = String.valueOf(Messages.NatTableDropListener_compositeFeature) + message;
            return MessageDialog.openConfirm(null, (String)Messages.NatTableDropListener_moveElement, (String)fullMessage);
        }
        return true;
    }

    public void dropAccept(DropTargetEvent event) {
    }
}

