/**
 * Copyright (c) 2015 Codetrails GmbH.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.epp.internal.logging.aeri.ide.handlers;

import static org.apache.commons.lang3.ArrayUtils.isEmpty;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.epp.internal.logging.aeri.ide.IServerDescriptor;
import org.eclipse.epp.internal.logging.aeri.ide.dialogs.ConfigureServerDialog;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.dialogs.Dialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

import com.google.common.base.Throwables;

public class CreateConfigureDialogHandler {

    @Execute
    public Dialog execute(IServerDescriptor server, IEclipseContext context) {
        IEclipseContext child = context.createChild("configure-scope-ctx"); //$NON-NLS-1$
        child.set(IServerDescriptor.class, server);

        String contributor = server.getContributor();
        String clazzName = getConfigureDialogClassName(server);
        Bundle ext = null;

        if (clazzName != null) {
            ext = Platform.getBundle(contributor);
        } else {
            // fall back:
            clazzName = ConfigureServerDialog.class.getName();
            ext = FrameworkUtil.getBundle(getClass());
        }
        Class<? extends Dialog> clazz;
        try {
            clazz = (Class<? extends Dialog>) ext.loadClass(clazzName);
            Dialog object = ContextInjectionFactory.make(clazz, child);
            return object;
        } catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    @Nullable
    private String getConfigureDialogClassName(IServerDescriptor server) {
        IConfigurationElement element = server.getConfigurationElement();
        IConfigurationElement[] children = element.getChildren("configure"); //$NON-NLS-1$
        if (isEmpty(children)) {
            return null;
        }
        return children[0].getAttribute("dialog"); //$NON-NLS-1$
    }
}
