/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gef.dot.internal.ui;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Bounds;
import javafx.scene.Node;
import javafx.scene.text.Text;
import org.eclipse.gef.common.attributes.IAttributeCopier;
import org.eclipse.gef.common.attributes.IAttributeStore;
import org.eclipse.gef.dot.internal.DotAttributes;
import org.eclipse.gef.dot.internal.language.arrowtype.ArrowType;
import org.eclipse.gef.dot.internal.language.color.Color;
import org.eclipse.gef.dot.internal.language.color.DotColors;
import org.eclipse.gef.dot.internal.language.color.HSVColor;
import org.eclipse.gef.dot.internal.language.color.RGBColor;
import org.eclipse.gef.dot.internal.language.color.StringColor;
import org.eclipse.gef.dot.internal.language.dir.DirType;
import org.eclipse.gef.dot.internal.language.dot.EdgeOp;
import org.eclipse.gef.dot.internal.language.dot.GraphType;
import org.eclipse.gef.dot.internal.language.layout.Layout;
import org.eclipse.gef.dot.internal.language.point.Point;
import org.eclipse.gef.dot.internal.language.rankdir.Rankdir;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedNodeShape;
import org.eclipse.gef.dot.internal.language.shape.PolygonBasedShape;
import org.eclipse.gef.dot.internal.language.shape.Shape;
import org.eclipse.gef.dot.internal.language.splines.Splines;
import org.eclipse.gef.dot.internal.language.splinetype.Spline;
import org.eclipse.gef.dot.internal.language.splinetype.SplineType;
import org.eclipse.gef.dot.internal.language.style.EdgeStyle;
import org.eclipse.gef.dot.internal.language.style.NodeStyle;
import org.eclipse.gef.dot.internal.language.style.Style;
import org.eclipse.gef.dot.internal.language.style.StyleItem;
import org.eclipse.gef.dot.internal.ui.DotArrowShapeDecorations;
import org.eclipse.gef.dot.internal.ui.DotBSplineInterpolator;
import org.eclipse.gef.fx.nodes.GeometryNode;
import org.eclipse.gef.fx.nodes.IConnectionInterpolator;
import org.eclipse.gef.fx.nodes.IConnectionRouter;
import org.eclipse.gef.fx.nodes.OrthogonalRouter;
import org.eclipse.gef.fx.nodes.PolylineInterpolator;
import org.eclipse.gef.fx.nodes.StraightRouter;
import org.eclipse.gef.geometry.planar.Dimension;
import org.eclipse.gef.geometry.planar.Ellipse;
import org.eclipse.gef.geometry.planar.IGeometry;
import org.eclipse.gef.geometry.planar.Polygon;
import org.eclipse.gef.geometry.planar.Rectangle;
import org.eclipse.gef.graph.Edge;
import org.eclipse.gef.graph.Graph;
import org.eclipse.gef.layout.ILayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.GridLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.RadialLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.SpringLayoutAlgorithm;
import org.eclipse.gef.layout.algorithms.TreeLayoutAlgorithm;
import org.eclipse.gef.zest.fx.ZestProperties;

public class Dot2ZestAttributesConverter
implements IAttributeCopier {
    private Options options;

    public void copy(IAttributeStore source, IAttributeStore target) {
        if (source instanceof org.eclipse.gef.graph.Node && target instanceof org.eclipse.gef.graph.Node) {
            this.convertAttributes((org.eclipse.gef.graph.Node)source, (org.eclipse.gef.graph.Node)target);
        } else if (source instanceof Edge && target instanceof Edge) {
            this.convertAttributes((Edge)source, (Edge)target);
        } else if (source instanceof Graph && target instanceof Graph) {
            this.convertAttributes((Graph)source, (Graph)target);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void convertAttributes(Edge dot, Edge zest) {
        Double arrowSizeParsed;
        String zestSourceDecorationCssStyle;
        Color dotColor;
        String javaFxColor;
        DirType dotDir;
        String dotTailLabel;
        String dotHeadLabel;
        String dotXLabel;
        String dotLabel;
        String dotId = DotAttributes.getId((Edge)dot);
        if (dotId != null) {
            ZestProperties.setCssId((Edge)zest, (String)dotId);
        }
        if ((dotLabel = DotAttributes.getLabel((Edge)dot)) != null && dotLabel.equals("\\E")) {
            boolean directed = GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph()));
            String dotName = String.valueOf(DotAttributes._getName((org.eclipse.gef.graph.Node)dot.getSource())) + (directed ? EdgeOp.DIRECTED.toString() : EdgeOp.UNDIRECTED.toString()) + DotAttributes._getName((org.eclipse.gef.graph.Node)dot.getTarget());
            String string = dotLabel = dotId != null ? dotId : dotName;
        }
        if (dotLabel != null) {
            ZestProperties.setLabel((Edge)zest, (String)dotLabel);
        }
        if ((dotXLabel = DotAttributes.getXlabel((Edge)dot)) != null) {
            ZestProperties.setExternalLabel((Edge)zest, (String)dotXLabel);
        }
        if ((dotHeadLabel = DotAttributes.getHeadlabel((Edge)dot)) != null) {
            ZestProperties.setTargetLabel((Edge)zest, (String)dotHeadLabel);
        }
        if ((dotTailLabel = DotAttributes.getTaillabel((Edge)dot)) != null) {
            ZestProperties.setSourceLabel((Edge)zest, (String)dotTailLabel);
        }
        String dotStyle = DotAttributes.getStyle((Edge)dot);
        String connectionCssStyle = null;
        if (EdgeStyle.DASHED.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-dash-array: 7 7;";
        } else if (EdgeStyle.DOTTED.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-dash-array: 1 7;";
        } else if (EdgeStyle.BOLD.toString().equals(dotStyle)) {
            connectionCssStyle = "-fx-stroke-width: 2;";
        } else if (EdgeStyle.INVIS.toString().equals(dotStyle)) {
            ZestProperties.setInvisible((Edge)zest, (Boolean)true);
        }
        if (connectionCssStyle == null) {
            connectionCssStyle = "-fx-stroke-line-cap: butt;";
        }
        if ((dotDir = DotAttributes.getDirParsed((Edge)dot)) == null) {
            DirType dirType = dotDir = GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph())) ? DirType.FORWARD : DirType.NONE;
        }
        if ((javaFxColor = this.computeZestColor(dotColor = DotAttributes.getColorParsed((Edge)dot))) != null) {
            String zestFill;
            String zestStroke = "-fx-stroke: " + javaFxColor + ";";
            connectionCssStyle = String.valueOf(connectionCssStyle) + zestStroke;
            if (DirType.BACK.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
                zestFill = "-fx-fill: " + javaFxColor + ";";
                zestSourceDecorationCssStyle = String.valueOf(zestStroke) + zestFill;
                ZestProperties.setSourceDecorationCssStyle((Edge)zest, (String)zestSourceDecorationCssStyle);
            }
            if (DirType.FORWARD.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
                zestFill = "-fx-fill: " + javaFxColor + ";";
                String zestTargetDecorationCssStyle = String.valueOf(zestStroke) + zestFill;
                ZestProperties.setTargetDecorationCssStyle((Edge)zest, (String)zestTargetDecorationCssStyle);
            }
        }
        ZestProperties.setCurveCssStyle((Edge)zest, (String)connectionCssStyle);
        Color dotFillColor = DotAttributes.getFillcolorParsed((Edge)dot);
        String javaFxFillColor = this.computeZestColor(dotFillColor);
        if (javaFxFillColor != null) {
            zestSourceDecorationCssStyle = ZestProperties.getSourceDecorationCssStyle((Edge)zest);
            ZestProperties.setSourceDecorationCssStyle((Edge)zest, (String)(String.valueOf(zestSourceDecorationCssStyle) + "-fx-fill: " + javaFxFillColor + ";"));
            String zestTargetDecorationCssStyle = ZestProperties.getTargetDecorationCssStyle((Edge)zest);
            ZestProperties.setTargetDecorationCssStyle((Edge)zest, (String)(String.valueOf(zestTargetDecorationCssStyle) + "-fx-fill: " + javaFxFillColor + ";"));
        }
        double arrowSize = (arrowSizeParsed = DotAttributes.getArrowsizeParsed((Edge)dot)) == null ? 1.0 : arrowSizeParsed;
        String dotArrowHead = DotAttributes.getArrowhead((Edge)dot);
        Node zestEdgeTargetDecoration = null;
        if (dotArrowHead == null) {
            if (GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph().getRootGraph()))) {
                zestEdgeTargetDecoration = DotArrowShapeDecorations.getDefault(arrowSize, true);
            }
        } else {
            zestEdgeTargetDecoration = this.computeZestDecoration(DotAttributes.getArrowheadParsed((Edge)dot), arrowSize);
        }
        if (DirType.FORWARD.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
            ZestProperties.setTargetDecoration((Edge)zest, (Node)zestEdgeTargetDecoration);
        }
        String dotArrowTail = DotAttributes.getArrowtail((Edge)dot);
        Node zestEdgeSourceDecoration = null;
        if (dotArrowTail == null) {
            if (GraphType.DIGRAPH.equals((Object)DotAttributes._getType((Graph)dot.getGraph().getRootGraph().getRootGraph()))) {
                zestEdgeSourceDecoration = DotArrowShapeDecorations.getDefault(arrowSize, true);
            }
        } else {
            zestEdgeSourceDecoration = this.computeZestDecoration(DotAttributes.getArrowtailParsed((Edge)dot), arrowSize);
        }
        if (DirType.BACK.equals((Object)dotDir) || DirType.BOTH.equals((Object)dotDir)) {
            ZestProperties.setSourceDecoration((Edge)zest, (Node)zestEdgeSourceDecoration);
        }
        GeometryNode curve = new GeometryNode();
        ZestProperties.setCurve((Edge)zest, (Node)curve);
        if (!this.options().emulateLayout) {
            String dotPos;
            String splines = DotAttributes.getSplines((Graph)dot.getGraph().getRootGraph());
            if (Splines.EMPTY.toString().equals(splines) || Splines.NONE.toString().equals(splines)) {
                ZestProperties.setInvisible((Edge)zest, (Boolean)true);
            }
            if ((dotPos = DotAttributes.getPos((Edge)dot)) != null && !this.options().ignorePositions) {
                List<org.eclipse.gef.geometry.planar.Point> bSplineControlPoints = this.computeZestBSplineControlPoints(dot);
                if (Splines.LINE.toString().equals(splines) || Splines.FALSE.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                } else if (Splines.POLYLINE.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
                } else if (Splines.ORTHO.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new PolylineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new OrthogonalRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, this.computeZestOrthogonalControlPoints(bSplineControlPoints));
                } else if (!Splines.COMPOUND.toString().equals(splines)) {
                    ZestProperties.setInterpolator((Edge)zest, (IConnectionInterpolator)new DotBSplineInterpolator());
                    ZestProperties.setRouter((Edge)zest, (IConnectionRouter)new StraightRouter());
                    ZestProperties.setStartPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(0));
                    ZestProperties.setEndPoint((Edge)zest, (org.eclipse.gef.geometry.planar.Point)bSplineControlPoints.get(bSplineControlPoints.size() - 1));
                    ZestProperties.setControlPoints((Edge)zest, bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
                }
            }
            String dotLp = DotAttributes.getLp((Edge)dot);
            if (dotLabel != null && dotLp != null && !this.options().ignorePositions) {
                ZestProperties.setLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getLpParsed((Edge)dot), dotLabel));
            }
            String dotXlp = DotAttributes.getXlp((Edge)dot);
            if (dotXLabel != null && dotXlp != null && !this.options().ignorePositions) {
                ZestProperties.setExternalLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getXlpParsed((Edge)dot), dotXLabel));
            }
            String headLp = DotAttributes.getHeadLp((Edge)dot);
            if (dotHeadLabel != null && headLp != null && !this.options().ignorePositions) {
                ZestProperties.setTargetLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getHeadLpParsed((Edge)dot), dotHeadLabel));
            }
            String tailLp = DotAttributes.getTailLp((Edge)dot);
            if (dotTailLabel != null && tailLp != null && !this.options().ignorePositions) {
                ZestProperties.setSourceLabelPosition((Edge)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(DotAttributes.getTailLpParsed((Edge)dot), dotTailLabel));
            }
        }
    }

    private List<org.eclipse.gef.geometry.planar.Point> computeZestOrthogonalControlPoints(List<org.eclipse.gef.geometry.planar.Point> bSplineControlPoints) {
        ArrayList<org.eclipse.gef.geometry.planar.Point> subList = new ArrayList<org.eclipse.gef.geometry.planar.Point>(bSplineControlPoints.subList(1, bSplineControlPoints.size() - 1));
        int i = subList.size() - 2;
        while (i > 0) {
            org.eclipse.gef.geometry.planar.Point p = (org.eclipse.gef.geometry.planar.Point)subList.get(i + 1);
            org.eclipse.gef.geometry.planar.Point q = (org.eclipse.gef.geometry.planar.Point)subList.get(i);
            org.eclipse.gef.geometry.planar.Point r = (org.eclipse.gef.geometry.planar.Point)subList.get(i - 1);
            if (p.x == q.x && q.x == r.x || p.y == q.y && q.y == r.y) {
                subList.remove(i);
            }
            --i;
        }
        List<org.eclipse.gef.geometry.planar.Point> subList2 = subList.subList(1, subList.size() - 1);
        return subList2;
    }

    private Node computeZestDecoration(ArrowType arrowType, double arrowSize) {
        return DotArrowShapeDecorations.get(arrowType, arrowSize);
    }

    private List<org.eclipse.gef.geometry.planar.Point> computeZestBSplineControlPoints(Edge dot) {
        SplineType splineType = DotAttributes.getPosParsed((Edge)dot);
        ArrayList<org.eclipse.gef.geometry.planar.Point> controlPoints = new ArrayList<org.eclipse.gef.geometry.planar.Point>();
        for (Spline spline : splineType.getSplines()) {
            Point startp = spline.getStartp();
            if (startp == null) {
                startp = (Point)spline.getControlPoints().get(0);
            }
            controlPoints.add(new org.eclipse.gef.geometry.planar.Point(startp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * startp.getY()));
            for (Point cp : spline.getControlPoints()) {
                controlPoints.add(new org.eclipse.gef.geometry.planar.Point(cp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * cp.getY()));
            }
            Point endp = spline.getEndp();
            if (endp == null) {
                endp = (Point)spline.getControlPoints().get(spline.getControlPoints().size() - 1);
            }
            controlPoints.add(new org.eclipse.gef.geometry.planar.Point(endp.getX(), (double)(this.options().invertYAxis ? -1 : 1) * endp.getY()));
        }
        return controlPoints;
    }

    protected void convertAttributes(org.eclipse.gef.graph.Node dot, org.eclipse.gef.graph.Node zest) {
        String dotLabel;
        String dotId = DotAttributes.getId((org.eclipse.gef.graph.Node)dot);
        if (dotId != null) {
            ZestProperties.setCssId((org.eclipse.gef.graph.Node)zest, (String)dotId);
        }
        String zestShapeStyle = this.computeZestStyle(dot);
        Shape dotShape = DotAttributes.getShapeParsed((org.eclipse.gef.graph.Node)dot);
        GeometryNode zestShape = null;
        if (dotShape == null) {
            zestShape = new GeometryNode((IGeometry)new Ellipse(new Rectangle()));
        } else if (dotShape.getShape() instanceof PolygonBasedShape) {
            PolygonBasedNodeShape polygonShape = ((PolygonBasedShape)dotShape.getShape()).getShape();
            if (PolygonBasedNodeShape.CIRCLE.equals((Object)polygonShape) || PolygonBasedNodeShape.ELLIPSE.equals((Object)polygonShape) || PolygonBasedNodeShape.OVAL.equals((Object)polygonShape)) {
                zestShape = new GeometryNode((IGeometry)new Ellipse(new Rectangle()));
            } else if (PolygonBasedNodeShape.BOX.equals((Object)polygonShape) || PolygonBasedNodeShape.RECT.equals((Object)polygonShape) || PolygonBasedNodeShape.RECTANGLE.equals((Object)polygonShape) || PolygonBasedNodeShape.SQUARE.equals((Object)polygonShape)) {
                zestShape = new GeometryNode((IGeometry)new Rectangle());
            } else if (PolygonBasedNodeShape.DIAMOND.equals((Object)polygonShape)) {
                zestShape = new GeometryNode((IGeometry)new Polygon(new double[]{0.0, 50.0, 50.0, 0.0, 100.0, 50.0, 50.0, 100.0, 0.0, 50.0}));
            } else if (PolygonBasedNodeShape.INVTRIANGLE.equals((Object)polygonShape)) {
                zestShape = new GeometryNode((IGeometry)new Polygon(new double[]{0.0, 10.0, 100.0, 10.0, 50.0, 100.0, 0.0, 10.0}));
            } else if (PolygonBasedNodeShape.TRIANGLE.equals((Object)polygonShape)) {
                zestShape = new GeometryNode((IGeometry)new Polygon(new double[]{0.0, 50.0, 50.0, 0.0, 100.0, 50.0, 0.0, 50.0}));
            }
        }
        if (zestShape != null) {
            if (zestShapeStyle != null) {
                zestShape.setStyle(zestShapeStyle);
            }
            ZestProperties.setShape((org.eclipse.gef.graph.Node)zest, (Node)zestShape);
        }
        if ((dotLabel = DotAttributes.getLabel((org.eclipse.gef.graph.Node)dot)) == null || dotLabel.equals("\\N")) {
            dotLabel = dotId != null ? dotId : DotAttributes._getName((org.eclipse.gef.graph.Node)dot);
        }
        ZestProperties.setLabel((org.eclipse.gef.graph.Node)zest, (String)dotLabel);
        String dotXLabel = DotAttributes.getXlabel((org.eclipse.gef.graph.Node)dot);
        if (dotXLabel != null) {
            ZestProperties.setExternalLabel((org.eclipse.gef.graph.Node)zest, (String)dotXLabel);
        }
        String dotHeight = DotAttributes.getHeight((org.eclipse.gef.graph.Node)dot);
        String dotWidth = DotAttributes.getWidth((org.eclipse.gef.graph.Node)dot);
        double zestWidth = (dotWidth == null ? 0.75 : Double.parseDouble(dotWidth)) * 72.0;
        double zestHeight = (dotHeight == null ? 0.5 : Double.parseDouble(dotHeight)) * 72.0;
        if (this.options().emulateLayout && !Boolean.TRUE.equals(DotAttributes.getFixedsizeParsed((org.eclipse.gef.graph.Node)dot))) {
            Dimension labelSize = Dot2ZestAttributesConverter.computeZestLabelSize(dotLabel);
            ZestProperties.setSize((org.eclipse.gef.graph.Node)zest, (Dimension)Dimension.max((Dimension)new Dimension(zestWidth, zestHeight), (Dimension)labelSize));
        } else {
            ZestProperties.setSize((org.eclipse.gef.graph.Node)zest, (Dimension)new Dimension(zestWidth, zestHeight));
        }
        String dotPos = DotAttributes.getPos((org.eclipse.gef.graph.Node)dot);
        if (dotPos != null && !this.options().ignorePositions) {
            Point dotPosParsed = DotAttributes.getPosParsed((org.eclipse.gef.graph.Node)dot);
            ZestProperties.setPosition((org.eclipse.gef.graph.Node)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestPosition(dotPosParsed, zestWidth, zestHeight));
            ZestProperties.setLayoutIrrelevant((org.eclipse.gef.graph.Node)zest, (Boolean)dotPosParsed.isInputOnly());
        }
        String dotXlp = DotAttributes.getXlp((org.eclipse.gef.graph.Node)dot);
        if (dotXLabel != null && dotXlp != null && !this.options().ignorePositions) {
            Point dotXlpParsed = DotAttributes.getXlpParsed((org.eclipse.gef.graph.Node)dot);
            ZestProperties.setExternalLabelPosition((org.eclipse.gef.graph.Node)zest, (org.eclipse.gef.geometry.planar.Point)this.computeZestLabelPosition(dotXlpParsed, dotXLabel));
        }
    }

    private String computeZestStyle(org.eclipse.gef.graph.Node dot) {
        Color dotFillColor;
        String javaFxFillColor;
        String zestStyle = null;
        Color dotColor = DotAttributes.getColorParsed((org.eclipse.gef.graph.Node)dot);
        String javaFxColor = this.computeZestColor(dotColor);
        if (javaFxColor != null) {
            zestStyle = "-fx-stroke: " + javaFxColor + ";";
        }
        boolean isFilledStyle = false;
        Style nodeStyle = DotAttributes.getStyleParsed((org.eclipse.gef.graph.Node)dot);
        if (nodeStyle != null) {
            for (StyleItem styleItem : nodeStyle.getStyleItems()) {
                if (!styleItem.getName().equals(NodeStyle.FILLED.toString())) continue;
                isFilledStyle = true;
                break;
            }
        }
        if (isFilledStyle && (javaFxFillColor = this.computeZestColor(dotFillColor = DotAttributes.getFillcolorParsed((org.eclipse.gef.graph.Node)dot))) != null) {
            zestStyle = zestStyle == null ? "-fx-fill: " + javaFxFillColor + ";" : String.valueOf(zestStyle) + "-fx-fill: " + javaFxFillColor + ";";
        }
        return zestStyle;
    }

    private org.eclipse.gef.geometry.planar.Point computeZestPosition(Point dotPosition, double widthInPixel, double heightInPixel) {
        return new org.eclipse.gef.geometry.planar.Point(dotPosition.getX() - widthInPixel / 2.0, (double)(this.options().invertYAxis ? -1 : 1) * dotPosition.getY() - heightInPixel / 2.0);
    }

    private org.eclipse.gef.geometry.planar.Point computeZestLabelPosition(Point dotLabelPosition, String labelText) {
        Dimension labelSize = Dot2ZestAttributesConverter.computeZestLabelSize(labelText);
        return this.computeZestPosition(dotLabelPosition, labelSize.getWidth(), labelSize.getHeight());
    }

    static Dimension computeZestLabelSize(String labelText) {
        Bounds layoutBounds = new Text(labelText).getLayoutBounds();
        return new Dimension(layoutBounds.getWidth(), layoutBounds.getHeight());
    }

    private String computeZestColor(Color dotColor) {
        String javaFxColor = null;
        if (dotColor instanceof RGBColor) {
            RGBColor rgbColor = (RGBColor)dotColor;
            StringBuffer sb = new StringBuffer();
            sb.append("#");
            sb.append(rgbColor.getR());
            sb.append(rgbColor.getG());
            sb.append(rgbColor.getB());
            if (rgbColor.getA() != null) {
                sb.append(rgbColor.getA());
            }
            javaFxColor = sb.toString();
        } else if (dotColor instanceof HSVColor) {
            HSVColor hsvColor = (HSVColor)dotColor;
            javaFxColor = String.format("hsb(%s, %s%%, %s%%)", Double.parseDouble(hsvColor.getH()) * 360.0, Double.parseDouble(hsvColor.getS()) * 100.0, Double.parseDouble(hsvColor.getV()) * 100.0);
        } else if (dotColor instanceof StringColor) {
            StringColor stringColor = (StringColor)dotColor;
            String colorSchema = stringColor.getScheme();
            String colorName = stringColor.getName();
            if (colorSchema == null || colorSchema.isEmpty()) {
                colorSchema = "x11";
            }
            javaFxColor = DotColors.get((String)colorSchema, (String)colorName);
        }
        return javaFxColor;
    }

    protected void convertAttributes(Graph dot, Graph zest) {
        if (this.options().emulateLayout) {
            Rankdir dotRankdir;
            String dotLayout = DotAttributes.getLayout((Graph)dot);
            Object algo = null;
            algo = Layout.CIRCO.toString().equals(dotLayout) || Layout.NEATO.toString().equals(dotLayout) || Layout.TWOPI.toString().equals(dotLayout) ? new RadialLayoutAlgorithm() : (Layout.FDP.toString().equals(dotLayout) || Layout.SFDP.toString().equals(dotLayout) ? new SpringLayoutAlgorithm() : (Layout.OSAGE.toString().equals(dotLayout) ? new GridLayoutAlgorithm() : new TreeLayoutAlgorithm(Rankdir.LR.equals((Object)(dotRankdir = DotAttributes.getRankdirParsed((Graph)dot))) ? 3 : 1)));
            ZestProperties.setLayoutAlgorithm((Graph)zest, (ILayoutAlgorithm)algo);
        }
    }

    public Options options() {
        if (this.options == null) {
            this.options = new Options();
        }
        return this.options;
    }

    public static final class Options {
        public boolean emulateLayout = true;
        public boolean ignorePositions = false;
        public boolean invertYAxis = false;
    }
}

