/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.model;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.eclipse.jubula.client.core.model.ExecTestCasePO;
import org.eclipse.jubula.client.core.model.IEventExecTestCasePO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ReentryProperty;
import org.eclipse.jubula.tools.internal.exception.InvalidDataException;
import org.eclipse.persistence.internal.descriptors.PersistenceObject;
import org.eclipse.persistence.internal.weaving.PersistenceWeaved;

@Entity
@DiscriminatorValue(value="H")
class EventExecTestCasePO
extends ExecTestCasePO
implements IEventExecTestCasePO,
PersistenceWeaved,
PersistenceObject {
    private Integer m_reentryProp;
    private String m_eventType;
    private Integer m_maxRetries;
    static final long serialVersionUID = 4526471251301008365L;

    EventExecTestCasePO() {
    }

    EventExecTestCasePO(ISpecTestCasePO specTC, INodePO assocNode, boolean isGenerated) {
        super(specTC, isGenerated);
        this.setParentNode(assocNode);
    }

    EventExecTestCasePO(ReentryProperty prop) {
        this.setReentryProp(prop);
    }

    EventExecTestCasePO(ISpecTestCasePO specTC, INodePO assocNode, String guid, boolean isGenerated) {
        super(specTC, guid, isGenerated);
        this.setParentNode(assocNode);
    }

    EventExecTestCasePO(String specTCGuid, String projectGuid, INodePO assocNode, String guid, boolean isGenerated) {
        super(specTCGuid, projectGuid, guid, isGenerated);
        this.setParentNode(assocNode);
    }

    EventExecTestCasePO(String specTCGuid, String projectGuid, INodePO assocNode, boolean isGenerated) {
        super(specTCGuid, projectGuid, isGenerated);
        this.setParentNode(assocNode);
    }

    @Basic
    @Column(name="REENTRY_PROP")
    private Integer getReentryPropValue() {
        return this.m_reentryProp;
    }

    private void setReentryPropValue(Integer reentryProp) {
        this.m_reentryProp = reentryProp;
    }

    @Override
    @Transient
    public ReentryProperty getReentryProp() {
        try {
            return ReentryProperty.getProperty(this.getReentryPropValue());
        }
        catch (InvalidDataException invalidDataException) {
            return null;
        }
    }

    @Override
    public void setReentryProp(ReentryProperty prop) {
        this.setReentryPropValue(prop.getValue());
        if (prop == ReentryProperty.RETRY) {
            if (this.getMaxRetries() == null) {
                this.setMaxRetries(1);
            }
        } else {
            this.setMaxRetries(null);
        }
    }

    @Override
    @Basic
    @Column(name="EVENT_TYPE")
    public String getEventType() {
        return this.m_eventType;
    }

    @Override
    public void setEventType(String eventType) {
        this.m_eventType = eventType;
    }

    @Override
    protected void removeMe(INodePO parent) {
        ((ISpecTestCasePO)parent).getEventExecTcMap().remove(this.getEventType());
        this.setParentNode(null);
    }

    @Override
    @Basic
    @Column(name="MAX_RETRIES")
    public Integer getMaxRetries() {
        return this.m_maxRetries;
    }

    @Override
    public void setMaxRetries(Integer maxRetries) {
        this.m_maxRetries = maxRetries;
    }

    @Override
    public Object _persistence_post_clone() {
        Object object = super._persistence_post_clone();
        this._persistence_primaryKey = null;
        return this;
    }

    @Override
    public Object _persistence_new(PersistenceObject persistenceObject) {
        return new EventExecTestCasePO();
    }

    @Override
    public Object _persistence_get(String string) {
        if (string == "maxRetries") {
            return this.maxRetries;
        }
        if (string == "eventType") {
            return this.eventType;
        }
        if (string == "reentryPropValue") {
            return this.reentryPropValue;
        }
        return super._persistence_get(string);
    }

    @Override
    public void _persistence_set(String string, Object object) {
        if (string == "maxRetries") {
            this.maxRetries = (Integer)object;
            return;
        }
        if (string == "eventType") {
            this.eventType = (String)object;
            return;
        }
        if (string == "reentryPropValue") {
            this.reentryPropValue = (Integer)object;
            return;
        }
        super._persistence_set(string, object);
    }
}

