/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.wizards.refactor.param;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jubula.client.core.model.IExecTestCasePO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParameterInterfacePO;
import org.eclipse.jubula.client.core.model.ISpecTestCasePO;
import org.eclipse.jubula.client.core.model.ITestCasePO;
import org.eclipse.jubula.client.ui.rcp.dialogs.AbstractEditParametersDialog;

public class ExistingAndNewParameterData
implements Comparator<IParamDescriptionPO> {
    private Map<IParamDescriptionPO, Set<ISpecTestCasePO>> m_map = new HashMap<IParamDescriptionPO, Set<ISpecTestCasePO>>();
    private IParameterInterfacePO m_dataCube;
    private IParamDescriptionPO m_oldParamDescription;
    private IParamDescriptionPO m_newParamDescription;

    public ExistingAndNewParameterData(Collection<ITestCasePO> testCases) {
        for (ITestCasePO testCase : testCases) {
            for (IParamDescriptionPO param : testCase.getParameterList()) {
                IParameterInterfacePO dataCube = testCase.getReferencedDataCube();
                IParamDescriptionPO dcParam = ExistingAndNewParameterData.findParameterByNameAndType(dataCube, param);
                if (dcParam == null || ExistingAndNewParameterData.findParameterByType(dataCube, param).size() <= 1) continue;
                Set<ISpecTestCasePO> paramNameTestCases = this.m_map.get(dcParam);
                if (paramNameTestCases == null) {
                    paramNameTestCases = new HashSet<ISpecTestCasePO>();
                    this.m_map.put(dcParam, paramNameTestCases);
                    if (this.m_dataCube == null) {
                        this.m_dataCube = dataCube;
                    }
                }
                paramNameTestCases.add(this.getSpecTestCase(testCase));
            }
        }
    }

    private static IParamDescriptionPO findParameterByNameAndType(IParameterInterfacePO dataCube, IParamDescriptionPO param) {
        for (IParamDescriptionPO dcParam : dataCube.getParameterList()) {
            if (!param.getName().equals(dcParam.getName()) || !param.getType().equals(dcParam.getType())) continue;
            return dcParam;
        }
        return null;
    }

    private static List<IParamDescriptionPO> findParameterByType(IParameterInterfacePO dataCube, IParamDescriptionPO param) {
        ArrayList<IParamDescriptionPO> paramDescs = new ArrayList<IParamDescriptionPO>();
        for (IParamDescriptionPO dcParam : dataCube.getParameterList()) {
            if (!param.getType().equals(dcParam.getType())) continue;
            paramDescs.add(dcParam);
        }
        return paramDescs;
    }

    private ISpecTestCasePO getSpecTestCase(ITestCasePO testCase) {
        if (testCase instanceof IExecTestCasePO) {
            IExecTestCasePO exec = (IExecTestCasePO)testCase;
            return exec.getSpecTestCase();
        }
        return (ISpecTestCasePO)testCase;
    }

    public Object[] getAllParamDescriptions() {
        ArrayList<IParamDescriptionPO> paramDescs = new ArrayList<IParamDescriptionPO>(this.m_map.keySet());
        Collections.sort(paramDescs, this);
        return paramDescs.toArray();
    }

    public Object[] getTestCasesOfParamDescription(IParamDescriptionPO paramDesc) {
        return this.m_map.get(paramDesc).toArray();
    }

    public String[] setOldParamDescription(IParamDescriptionPO paramDesc) {
        this.m_oldParamDescription = paramDesc;
        ArrayList<String> columnNames = new ArrayList<String>();
        for (String paramName : this.m_dataCube.getParamNames()) {
            IParamDescriptionPO currentParamDesc = this.m_dataCube.getParameterForName(paramName);
            if (paramDesc.getName().equals(currentParamDesc.getName()) || !paramDesc.getType().equals(currentParamDesc.getType())) continue;
            columnNames.add(paramName);
        }
        return columnNames.toArray(new String[columnNames.size()]);
    }

    public IParamDescriptionPO getOldParamDescription() {
        return this.m_oldParamDescription;
    }

    public Set<ISpecTestCasePO> getSelectedTestCases() {
        return this.m_map.get(this.m_oldParamDescription);
    }

    public void setNewParamName(String paramName) {
        if (this.m_dataCube != null) {
            this.m_newParamDescription = this.m_dataCube.getParameterForName(paramName);
        }
    }

    public IParamDescriptionPO getNewParamDescription() {
        return this.m_newParamDescription;
    }

    public boolean isComplete() {
        return this.m_oldParamDescription != null && this.m_newParamDescription != null;
    }

    public List<AbstractEditParametersDialog.Parameter> getNewParametersFromSpecTestCase(ISpecTestCasePO testCase) {
        ArrayList<AbstractEditParametersDialog.Parameter> params = new ArrayList<AbstractEditParametersDialog.Parameter>();
        for (IParamDescriptionPO param : testCase.getParameterList()) {
            AbstractEditParametersDialog.Parameter newParam = new AbstractEditParametersDialog.Parameter(param);
            if (param.getName().equals(this.m_oldParamDescription.getName())) {
                newParam.setName(this.m_newParamDescription.getName());
            }
            params.add(newParam);
        }
        return params;
    }

    @Override
    public int compare(IParamDescriptionPO o1, IParamDescriptionPO o2) {
        return o1.getName().compareTo(o2.getName());
    }
}

