/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.inspections.collections;

import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.inspections.collectionextract.CollectionExtractionUtils;
import org.eclipse.mat.inspections.collectionextract.ExtractedMap;
import org.eclipse.mat.internal.Messages;
import org.eclipse.mat.internal.collectionextract.HashSetCollectionExtractor;
import org.eclipse.mat.query.IQuery;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.annotations.Argument;
import org.eclipse.mat.query.annotations.CommandName;
import org.eclipse.mat.query.annotations.HelpUrl;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.snapshot.query.ObjectListResult;
import org.eclipse.mat.util.IProgressListener;

@CommandName(value="hash_set_values")
@HelpUrl(value="/org.eclipse.mat.ui.help/tasks/analyzingjavacollectionusage.html")
public class HashSetValuesQuery
implements IQuery {
    @Argument
    public ISnapshot snapshot;
    @Argument(flag="none")
    public IObject hashSet;
    @Argument(isMandatory=false)
    public String collection;
    @Argument(isMandatory=false)
    public String array_attribute;
    @Argument(isMandatory=false)
    public String key_attribute;

    public IResult execute(IProgressListener listener) throws Exception {
        int[] result;
        ExtractedMap extractor;
        if (this.collection != null && this.hashSet.getClazz().doesExtend(this.collection)) {
            if (this.array_attribute == null || this.key_attribute == null) {
                String msg = Messages.HashSetValuesQuery_ErrorMsg_MissingArgument;
                throw new SnapshotException(msg);
            }
            extractor = new ExtractedMap(this.hashSet, new HashSetCollectionExtractor(this.array_attribute, this.key_attribute));
        } else {
            extractor = CollectionExtractionUtils.extractMap(this.hashSet);
            if (extractor == null) {
                throw new IllegalArgumentException(this.hashSet.getTechnicalName());
            }
        }
        if (!extractor.hasSize()) {
            result = new int[]{};
        } else if (extractor.hasExtractableContents()) {
            result = extractor.extractEntryIds();
        } else {
            throw new IllegalArgumentException(this.hashSet.getTechnicalName());
        }
        return new ObjectListResult.Outbound(this.snapshot, result);
    }
}

