/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.ui.editor.reload;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.papyrus.infra.core.utils.AdapterUtils;
import org.eclipse.papyrus.infra.ui.editor.reload.IDisposableReloadContext;
import org.eclipse.papyrus.infra.ui.editor.reload.IInternalEMFSelectionContext;
import org.eclipse.papyrus.infra.ui.editor.reload.IReloadContextProvider;

public class DelegatingReloadContext
implements IDisposableReloadContext,
IAdaptable {
    private Object delegate;

    public DelegatingReloadContext(Object reloadContextProvider) {
        IReloadContextProvider provider = (IReloadContextProvider)AdapterUtils.adapt((Object)reloadContextProvider, IReloadContextProvider.class, null);
        if (provider != null) {
            this.delegate = provider.createReloadContext();
        }
    }

    @Override
    public void dispose() {
        if (this.delegate instanceof IDisposableReloadContext) {
            ((IDisposableReloadContext)this.delegate).dispose();
        }
        this.delegate = null;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void restore(Object reloadContextProvider) {
        IReloadContextProvider provider;
        if (this.delegate != null && (provider = (IReloadContextProvider)AdapterUtils.adapt((Object)reloadContextProvider, IReloadContextProvider.class, null)) != null) {
            provider.restore(this.delegate);
        }
    }

    public Object getAdapter(Class adapter) {
        return adapter == IInternalEMFSelectionContext.class ? this.getEMFContext() : null;
    }

    private IInternalEMFSelectionContext getEMFContext() {
        IInternalEMFSelectionContext.Delegating result = null;
        if (this.delegate != null && AdapterUtils.adapt((Object)this.delegate, IInternalEMFSelectionContext.class, null) != null) {
            result = new IInternalEMFSelectionContext.Delegating(this);
        }
        return result;
    }
}

