/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.java.jdt;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.sapphire.java.JavaType;
import org.eclipse.sapphire.java.JavaTypeKind;

public final class JdtJavaType
extends JavaType {
    private final IType type;
    private final JavaTypeKind kind;
    private final JavaType base;
    private final Set<JavaType> interfaces;

    public JdtJavaType(IType type) throws JavaModelException {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        this.type = type;
        this.kind = type.isAnnotation() ? JavaTypeKind.ANNOTATION : (type.isEnum() ? JavaTypeKind.ENUM : (type.isInterface() ? JavaTypeKind.INTERFACE : (Flags.isAbstract((int)type.getFlags()) ? JavaTypeKind.ABSTRACT_CLASS : JavaTypeKind.CLASS)));
        ITypeHierarchy typeHierarchy = type.newSupertypeHierarchy(null);
        IType base = typeHierarchy.getSuperclass(type);
        this.base = base != null ? new JdtJavaType(base) : null;
        HashSet<JdtJavaType> interfaces = new HashSet<JdtJavaType>();
        IType[] iTypeArray = typeHierarchy.getSuperInterfaces(type);
        int n = iTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IType i = iTypeArray[n2];
            interfaces.add(new JdtJavaType(i));
            ++n2;
        }
        this.interfaces = Collections.unmodifiableSet(interfaces);
    }

    public IType artifact() {
        return this.type;
    }

    public String name() {
        return this.type.getFullyQualifiedName();
    }

    public JavaTypeKind kind() {
        return this.kind;
    }

    public JavaType base() {
        return this.base;
    }

    public Set<JavaType> interfaces() {
        return this.interfaces;
    }
}

