/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.core.trace;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.common.core.StreamUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.component.ITmfEventProvider;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.request.ITmfEventRequest;
import org.eclipse.tracecompass.tmf.core.request.TmfEventRequest;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

@NonNullByDefault
public final class TmfTraceUtils {
    private static final int MAX_NB_BINARY_BYTES = 2048;
    private static final Set<ITmfEventAspect<?>> EXTRA_ASPECTS = new HashSet();

    private TmfTraceUtils() {
    }

    public static <T extends IAnalysisModule> @Nullable T getAnalysisModuleOfClass(ITmfTrace trace, Class<T> moduleClass, String id) {
        Iterable<IAnalysisModule> modules = TmfTraceUtils.getAnalysisModulesOfClass(trace, moduleClass);
        for (IAnalysisModule module : modules) {
            if (!id.equals(module.getId())) continue;
            return (T)module;
        }
        return null;
    }

    public static void registerEventAspect(ITmfEventAspect<?> aspect) {
        EXTRA_ASPECTS.add(aspect);
    }

    public static <T> Iterable<@NonNull T> getAnalysisModulesOfClass(ITmfTrace trace, Class<T> moduleClass) {
        Iterable<IAnalysisModule> analysisModules = trace.getAnalysisModules();
        ArrayList<@NonNull Object> modules = new ArrayList<Object>();
        for (IAnalysisModule module : analysisModules) {
            if (!moduleClass.isAssignableFrom(module.getClass())) continue;
            modules.add(NonNullUtils.checkNotNull(moduleClass.cast(module)));
        }
        for (ITmfEventProvider child : trace.getChildren()) {
            if (!(child instanceof ITmfTrace)) continue;
            ITmfTrace childTrace = (ITmfTrace)child;
            Iterables.addAll(modules, TmfTraceUtils.getAnalysisModulesOfClass(childTrace, moduleClass));
        }
        return modules;
    }

    public static <T extends ITmfEventAspect<?>> @Nullable Object resolveEventAspectOfClassForEvent(ITmfTrace trace, Class<T> aspectClass, ITmfEvent event) {
        Object value = StreamUtils.getStream(trace.getEventAspects()).filter(aspect -> aspectClass.isAssignableFrom(aspect.getClass())).map(aspect -> aspect.resolve(event)).filter(obj -> obj != null).findFirst().orElse(null);
        if (value != null) {
            return value;
        }
        return EXTRA_ASPECTS.stream().filter(aspect -> aspectClass.isAssignableFrom(aspect.getClass())).map(aspect -> aspect.resolve(event)).filter(obj -> obj != null).findFirst().orElse(null);
    }

    public static @Nullable Object resolveAspectOfNameForEvent(ITmfTrace trace, String aspectName, ITmfEvent event) {
        Object value = StreamUtils.getStream(trace.getEventAspects()).filter(aspect -> aspectName.equalsIgnoreCase(aspect.getName())).map(aspect -> aspect.resolve(event)).filter(obj -> obj != null).findFirst().orElse(null);
        if (value != null) {
            return value;
        }
        for (ITmfEventAspect<?> aspect2 : EXTRA_ASPECTS) {
            if (!aspectName.equalsIgnoreCase(aspect2.getName()) || (value = aspect2.resolve(event)) == null) continue;
            return value;
        }
        return null;
    }

    public static <T extends ITmfEventAspect<Integer>> @Nullable Integer resolveIntEventAspectOfClassForEvent(ITmfTrace trace, Class<T> aspectClass, ITmfEvent event) {
        Integer value = StreamUtils.getStream(trace.getEventAspects()).filter(aspect -> aspectClass.isAssignableFrom(aspect.getClass())).map(aspect -> (Integer)aspect.resolve(event)).filter(obj -> obj != null).findFirst().orElse(null);
        if (value != null) {
            return value;
        }
        return EXTRA_ASPECTS.stream().filter(aspect -> aspectClass.isAssignableFrom(aspect.getClass())).map(aspect -> (Integer)aspect.resolve(event)).filter(obj -> obj != null).findFirst().orElse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isText(File file) throws IOException {
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            try {
                int count = 0;
                int val = bufferedInputStream.read();
                if (count >= 2048) return true;
                if (val >= 0) {
                }
                return true;
            }
            finally {
                if (bufferedInputStream == null) return false;
                bufferedInputStream.close();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable ITmfEvent getNextEventMatching(ITmfTrace trace, long startRank, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        EventMatchingRequest req = new EventMatchingRequest(startRank + 1L, predicate, false);
        trace.sendRequest(req);
        try {
            req.waitForStart();
            do {
                if (!req.isRunning()) {
                    req.waitForCompletion();
                    return req.getFoundEvent();
                }
                Thread.sleep(200L);
            } while (monitor == null || !monitor.isCanceled());
            req.cancel();
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static @Nullable ITmfEvent getPreviousEventMatching(ITmfTrace trace, long startRank, Predicate<ITmfEvent> predicate, @Nullable IProgressMonitor monitor) {
        if (monitor != null && monitor.isCanceled()) {
            return null;
        }
        int step = trace.getCacheSize();
        if (startRank < (long)step) {
            step = (int)startRank;
        }
        long currentRank = startRank;
        try {
            ArrayFillingRequest req;
            block2: while (true) {
                if (currentRank <= 0L) {
                    return null;
                }
                currentRank = Math.max(currentRank - (long)step, 0L);
                ArrayList<ITmfEvent> list = new ArrayList<ITmfEvent>(step);
                req = new ArrayFillingRequest(currentRank, step, list);
                trace.sendRequest(req);
                req.waitForStart();
                do {
                    if (!req.isRunning()) {
                        req.waitForCompletion();
                        Optional<ITmfEvent> matchingEvent = Lists.reverse(list).stream().filter(predicate).findFirst();
                        if (!matchingEvent.isPresent()) continue block2;
                        return matchingEvent.get();
                    }
                    Thread.sleep(200L);
                } while (monitor == null || !monitor.isCanceled());
                break;
            }
            req.cancel();
            return null;
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    private static class ArrayFillingRequest
    extends TmfEventRequest {
        private final List<ITmfEvent> fList;

        public ArrayFillingRequest(long startRank, int limit, List<ITmfEvent> listToFill) {
            super(ITmfEvent.class, startRank, limit, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fList = listToFill;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            this.fList.add(event);
        }
    }

    private static class EventMatchingRequest
    extends TmfEventRequest {
        private final Predicate<ITmfEvent> fPredicate;
        private final boolean fReturnLast;
        private @Nullable ITmfEvent fFoundEvent = null;

        public EventMatchingRequest(long startRank, Predicate<ITmfEvent> predicate, boolean returnLast) {
            super(ITmfEvent.class, startRank, Integer.MAX_VALUE, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fPredicate = predicate;
            this.fReturnLast = returnLast;
        }

        public EventMatchingRequest(long startRank, int limit, Predicate<ITmfEvent> predicate, boolean returnLast) {
            super(ITmfEvent.class, startRank, limit, ITmfEventRequest.ExecutionType.FOREGROUND);
            this.fPredicate = predicate;
            this.fReturnLast = returnLast;
        }

        public @Nullable ITmfEvent getFoundEvent() {
            return this.fFoundEvent;
        }

        @Override
        public void handleData(ITmfEvent event) {
            super.handleData(event);
            if (this.fPredicate.test(event)) {
                this.fFoundEvent = event;
                if (!this.fReturnLast) {
                    this.done();
                }
            }
        }
    }
}

