/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.ui.symbols;

import java.io.File;
import java.text.MessageFormat;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.BasicSymbolProvider;
import org.eclipse.tracecompass.internal.tmf.ui.symbols.Messages;
import org.eclipse.tracecompass.tmf.ui.dialog.TmfFileDialogFactory;
import org.eclipse.tracecompass.tmf.ui.symbols.AbstractSymbolProviderPreferencePage;

public class BasicSymbolProviderPreferencePage
extends AbstractSymbolProviderPreferencePage {
    private Button fRadioBinaryFile;
    private Text fTextBinaryFile;
    private Button fButtonBrowseBinary;
    private Button fRadioMappingFile;
    private Text fTextMappingFile;
    private Button fButtonBrowseMapping;

    public BasicSymbolProviderPreferencePage(@NonNull BasicSymbolProvider provider) {
        super(provider);
        this.setDescription(MessageFormat.format(Messages.BasicSymbolProviderPrefPage_description, provider.getTrace().getName()));
        this.setValid(true);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(3, false));
        this.fRadioBinaryFile = new Button(composite, 16);
        this.fRadioBinaryFile.setText(Messages.BasicSymbolProviderPrefPage_radioBinaryFile_text);
        this.fRadioBinaryFile.setToolTipText(Messages.BasicSymbolProviderPrefPage_radioBinaryFile_tooltip);
        this.fRadioBinaryFile.setSelection(true);
        this.fRadioBinaryFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicSymbolProviderPreferencePage.this.switchToSourceKind(BasicSymbolProvider.SourceKind.BINARY, true);
            }
        });
        this.fTextBinaryFile = new Text(composite, 2048);
        this.fTextBinaryFile.setLayoutData((Object)new GridData(768));
        this.fTextBinaryFile.setEditable(false);
        this.fButtonBrowseBinary = new Button(composite, 0);
        this.fButtonBrowseBinary.setText(Messages.BasicSymbolProviderPrefPage_btnBrowse);
        this.fButtonBrowseBinary.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicSymbolProviderPreferencePage.this.browseForFile(BasicSymbolProviderPreferencePage.this.fTextBinaryFile, Messages.BasicSymbolProviderPrefPage_ImportBinaryFileDialogTitle);
            }
        });
        this.fRadioMappingFile = new Button(composite, 16);
        this.fRadioMappingFile.setText(Messages.BasicSymbolProviderPrefPage_radioMappingFile_text);
        this.fRadioMappingFile.setToolTipText(Messages.BasicSymbolProviderPrefPage_radioMappingFile_tooltip);
        this.fRadioMappingFile.setSelection(false);
        this.fRadioMappingFile.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicSymbolProviderPreferencePage.this.switchToSourceKind(BasicSymbolProvider.SourceKind.MAPPING, true);
            }
        });
        this.fTextMappingFile = new Text(composite, 2048);
        this.fTextMappingFile.setLayoutData((Object)new GridData(768));
        this.fTextMappingFile.setEnabled(false);
        this.fTextMappingFile.setEditable(false);
        this.fButtonBrowseMapping = new Button(composite, 0);
        this.fButtonBrowseMapping.setText(Messages.BasicSymbolProviderPrefPage_btnBrowse);
        this.fButtonBrowseMapping.setEnabled(false);
        this.fButtonBrowseMapping.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BasicSymbolProviderPreferencePage.this.browseForFile(BasicSymbolProviderPreferencePage.this.fTextMappingFile, Messages.BasicSymbolProviderPrefPage_ImportMappingDialogTitle);
            }
        });
        this.loadProviderSettings();
        return composite;
    }

    private void browseForFile(Text fileField, String dialogTitle) {
        FileDialog fileDialog = TmfFileDialogFactory.create(this.getShell(), 4096);
        fileDialog.setText(dialogTitle);
        String filePath = fileDialog.open();
        if (filePath != null) {
            fileField.setText(filePath);
            this.broadcastChanges();
        }
    }

    private void loadProviderSettings() {
        BasicSymbolProvider provider = (BasicSymbolProvider)this.getSymbolProvider();
        String source = provider.getConfiguredSource();
        BasicSymbolProvider.SourceKind sourceKind = provider.getConfiguredSourceKind();
        if (source != null) {
            if (sourceKind == BasicSymbolProvider.SourceKind.BINARY) {
                this.fTextBinaryFile.setText(source);
            } else {
                this.fTextMappingFile.setText(source);
            }
        }
        this.switchToSourceKind(sourceKind, false);
        this.broadcastChanges();
    }

    private void switchToSourceKind(@NonNull BasicSymbolProvider.SourceKind kind, boolean broadcastChanges) {
        this.fRadioBinaryFile.setSelection(kind == BasicSymbolProvider.SourceKind.BINARY);
        this.fTextBinaryFile.setEnabled(kind == BasicSymbolProvider.SourceKind.BINARY);
        this.fButtonBrowseBinary.setEnabled(kind == BasicSymbolProvider.SourceKind.BINARY);
        this.fRadioMappingFile.setSelection(kind == BasicSymbolProvider.SourceKind.MAPPING);
        this.fTextMappingFile.setEnabled(kind == BasicSymbolProvider.SourceKind.MAPPING);
        this.fButtonBrowseMapping.setEnabled(kind == BasicSymbolProvider.SourceKind.MAPPING);
        if (broadcastChanges) {
            this.broadcastChanges();
        }
    }

    @Override
    public void saveConfiguration() {
        BasicSymbolProvider provider = (BasicSymbolProvider)this.getSymbolProvider();
        provider.setConfiguredSource(this.getCurrentSource(), this.getCurrentSourceKind());
    }

    private @NonNull BasicSymbolProvider.SourceKind getCurrentSourceKind() {
        if (this.fRadioBinaryFile.getSelection()) {
            return BasicSymbolProvider.SourceKind.BINARY;
        }
        return BasicSymbolProvider.SourceKind.MAPPING;
    }

    private String getCurrentSource() {
        if (this.fRadioBinaryFile.getSelection()) {
            return this.fTextBinaryFile.getText();
        }
        return this.fTextMappingFile.getText();
    }

    private void broadcastChanges() {
        String filePath = this.getCurrentSource();
        String errorMessage = null;
        if (filePath != null && filePath.length() > 0) {
            File file = new File(filePath);
            if (!file.isFile()) {
                errorMessage = Messages.BasicSymbolProviderPrefPage_errorFileDoesNotExists;
            }
        } else {
            errorMessage = Messages.BasicSymbolProviderPrefPage_errorSpecifyFile;
        }
        this.setErrorMessage(errorMessage);
        this.setValid(errorMessage == null);
    }
}

