/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.editors;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.tracecompass.internal.tmf.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.ui.editors.ITmfEventsEditorConstants;
import org.eclipse.tracecompass.internal.tmf.ui.editors.TmfTableColumnUtils;
import org.eclipse.tracecompass.tmf.core.TmfCommonConstants;
import org.eclipse.tracecompass.tmf.core.event.aspect.ITmfEventAspect;
import org.eclipse.tracecompass.tmf.core.event.aspect.TmfBaseAspects;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignalHandler;
import org.eclipse.tracecompass.tmf.core.signal.TmfTimestampFormatUpdateSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceClosedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceOpenedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfTraceSelectedSignal;
import org.eclipse.tracecompass.tmf.core.trace.ITmfContext;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.experiment.TmfExperiment;
import org.eclipse.tracecompass.tmf.ui.editors.ITmfTraceEditor;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEditor;
import org.eclipse.tracecompass.tmf.ui.editors.TmfEditorInput;
import org.eclipse.tracecompass.tmf.ui.editors.UnsortedPropertySheetPage;
import org.eclipse.tracecompass.tmf.ui.project.model.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfOpenTraceHelper;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceTypeUIUtils;
import org.eclipse.tracecompass.tmf.ui.viewers.events.TmfEventsTable;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IReusableEditor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.properties.IPropertySheetPage;

public class TmfEventsEditor
extends TmfEditor
implements ITmfTraceEditor,
IReusableEditor,
IPropertyListener,
IResourceChangeListener,
ISelectionProvider,
ISelectionChangedListener,
IPartListener,
IGotoMarker {
    public static final String ID = "org.eclipse.linuxtools.tmf.ui.editors.events";
    private TmfEventsTable fEventsTable;
    private IFile fFile;
    private ITmfTrace fTrace;
    private Composite fParent;
    private ListenerList fSelectionChangedListeners = new ListenerList();
    private boolean fTraceSelected;
    private IMarker fPendingGotoMarker;

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        IFileEditorInput fileEditorInput;
        if (input instanceof TmfEditorInput) {
            this.fFile = ((TmfEditorInput)input).getFile();
            this.fTrace = ((TmfEditorInput)input).getTrace();
            fileEditorInput = new FileEditorInput(this.fFile);
        } else {
            if (!(input instanceof IFileEditorInput)) throw new PartInitException("Invalid IEditorInput: " + input.getClass());
            fileEditorInput = (IFileEditorInput)input;
            this.fFile = fileEditorInput.getFile();
            if (this.fFile == null) {
                throw new PartInitException("Invalid IFileEditorInput: " + fileEditorInput);
            }
            try {
                String traceTypeId = this.fFile.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (traceTypeId == null) {
                    throw new PartInitException(Messages.TmfOpenTraceHelper_NoTraceType);
                }
                if (ITmfEventsEditorConstants.EXPERIMENT_INPUT_TYPE_CONSTANTS.contains((Object)traceTypeId)) {
                    TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject(), true);
                    if (project == null) {
                        throw new PartInitException(Messages.TmfOpenTraceHelper_NoTraceType);
                    }
                    TmfExperimentFolder experimentFolder = project.getExperimentsFolder();
                    if (experimentFolder != null) {
                        for (TmfExperimentElement experimentElement : experimentFolder.getExperiments()) {
                            if (!experimentElement.getResource().equals((Object)this.fFile.getParent())) continue;
                            this.setPartName(experimentElement.getName());
                            super.setSite((IWorkbenchPartSite)site);
                            super.setInput((IEditorInput)fileEditorInput);
                            TmfOpenTraceHelper.reopenTraceFromElement(experimentElement, this);
                            return;
                        }
                    }
                } else if (ITmfEventsEditorConstants.TRACE_INPUT_TYPE_CONSTANTS.contains((Object)traceTypeId)) {
                    TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject(), true);
                    TmfTraceFolder tracesFolder = project.getTracesFolder();
                    if (tracesFolder != null) {
                        for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
                            if (!traceElement.getResource().equals((Object)this.fFile.getParent())) continue;
                            this.setPartName(traceElement.getElementPath());
                            super.setSite((IWorkbenchPartSite)site);
                            super.setInput((IEditorInput)fileEditorInput);
                            TmfOpenTraceHelper.reopenTraceFromElement(traceElement, this);
                            return;
                        }
                    }
                } else {
                    TmfProjectElement project = TmfProjectRegistry.getProject(this.fFile.getProject(), true);
                    TmfTraceFolder tracesFolder = project.getTracesFolder();
                    if (tracesFolder != null) {
                        for (TmfTraceElement traceElement : tracesFolder.getTraces()) {
                            if (!traceElement.getResource().equals((Object)this.fFile)) continue;
                            this.setPartName(traceElement.getElementPath());
                            super.setSite((IWorkbenchPartSite)site);
                            super.setInput((IEditorInput)fileEditorInput);
                            TmfOpenTraceHelper.reopenTraceFromElement(traceElement, this);
                            return;
                        }
                    }
                }
            }
            catch (PartInitException e) {
                throw e;
            }
            catch (InvalidRegistryObjectException e) {
                Activator.getDefault().logError("Error initializing TmfEventsEditor", e);
            }
            catch (CoreException e) {
                Activator.getDefault().logError("Error initializing TmfEventsEditor", e);
            }
        }
        if (this.fTrace == null) {
            throw new PartInitException("Invalid IEditorInput: " + this.fFile.getName());
        }
        super.setSite((IWorkbenchPartSite)site);
        super.setInput((IEditorInput)fileEditorInput);
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void setInput(IEditorInput input) {
        super.setInput(input);
        this.firePropertyChange(258);
    }

    public void propertyChanged(Object source, int propId) {
        if (propId == 258 && this.getEditorInput() instanceof TmfEditorInput) {
            if (this.fTrace != null) {
                this.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, this.fTrace));
                this.saveState();
            }
            this.fEventsTable.dispose();
            this.fFile = ((TmfEditorInput)this.getEditorInput()).getFile();
            this.fTrace = ((TmfEditorInput)this.getEditorInput()).getTrace();
            super.setInput((IEditorInput)new FileEditorInput(this.fFile));
            this.createAndInitializeTable();
            if (!PlatformUI.getWorkbench().isClosing() && PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart() == this.getSite().getPart()) {
                this.fEventsTable.setFocus();
            }
            this.fParent.layout();
        }
    }

    private void loadState() {
        @Nullable String traceTypeId = this.fTrace.getTraceTypeId();
        this.fEventsTable.setColumnOrder(TmfTableColumnUtils.loadColumnOrder(traceTypeId));
        this.fEventsTable.setColumnWidth(TmfTableColumnUtils.loadColumnWidth(traceTypeId), TmfTableColumnUtils.loadColumnResizable(traceTypeId));
    }

    private void saveState() {
        @Nullable String traceTypeId = this.fTrace.getTraceTypeId();
        TmfTableColumnUtils.saveColumnOrder(traceTypeId, this.fEventsTable.getColumnOrder());
        TmfTableColumnUtils.saveColumnWidth(traceTypeId, this.fEventsTable.getColumnWidth());
        TmfTableColumnUtils.saveColumnResizability(traceTypeId, this.fEventsTable.getColumnResizable());
    }

    public void createPartControl(Composite parent) {
        this.fParent = parent;
        this.createAndInitializeTable();
        this.addPropertyListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this, 1);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
    }

    private void createAndInitializeTable() {
        if (this.fTrace != null) {
            this.setPartName(this.fTrace.getName());
            this.fEventsTable = this.createEventsTable(this.fParent, this.fTrace.getCacheSize());
            this.fEventsTable.registerContextMenus(this.getSite());
            this.fEventsTable.addSelectionChangedListener(this);
            this.fEventsTable.setTrace(this.fTrace, true);
            this.fEventsTable.refreshBookmarks(this.fFile);
            this.loadState();
            ITmfContext context = this.fTrace.seekEvent(0L);
            this.fTrace.getNext(context);
            context.dispose();
            this.broadcast((TmfSignal)new TmfTraceOpenedSignal((Object)this, this.fTrace, this.fFile));
            if (this.fTraceSelected) {
                this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
            }
            if (this.fPendingGotoMarker != null) {
                this.fEventsTable.gotoMarker(this.fPendingGotoMarker);
                this.fPendingGotoMarker = null;
            }
        } else {
            this.fEventsTable = new TmfEventsTable(this.fParent, 0);
            this.fEventsTable.addSelectionChangedListener(this);
        }
        IStatusLineManager statusLineManager = this.getEditorSite().getActionBars().getStatusLineManager();
        this.fEventsTable.setStatusLineManager(statusLineManager);
    }

    @Override
    public void dispose() {
        if (this.getSite() != null) {
            this.getSite().getPage().removePartListener((IPartListener)this);
        }
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        this.removePropertyListener(this);
        if (this.fTrace != null) {
            this.broadcast((TmfSignal)new TmfTraceClosedSignal((Object)this, this.fTrace));
            if (this.fEventsTable != null) {
                this.saveState();
            }
        }
        super.dispose();
    }

    protected @NonNull TmfEventsTable createEventsTable(Composite parent, int cacheSize) {
        ITmfTrace trace = this.fTrace;
        TmfEventsTable table = TmfTraceTypeUIUtils.getEventTable(trace, parent, cacheSize);
        if (table != null) {
            return table;
        }
        Iterable<ITmfEventAspect<?>> aspects = TmfEventsEditor.getTraceAspects(trace);
        if (Iterables.isEmpty(aspects)) {
            return new TmfEventsTable(parent, cacheSize);
        }
        return new TmfEventsTable(parent, cacheSize, aspects);
    }

    private static @NonNull Iterable<ITmfEventAspect<?>> getTraceAspects(ITmfTrace trace) {
        if (trace instanceof TmfExperiment) {
            return TmfEventsEditor.getExperimentAspects((TmfExperiment)trace);
        }
        return trace.getEventAspects();
    }

    private static @NonNull Iterable<ITmfEventAspect<?>> getExperimentAspects(TmfExperiment experiment) {
        List traces = experiment.getTraces();
        ImmutableSet.Builder builder = new ImmutableSet.Builder();
        builder.add((Object)TmfBaseAspects.getTraceNameAspect());
        String commonTraceType = TmfEventsEditor.getCommonTraceType(experiment);
        if (commonTraceType != null) {
            builder.addAll(((ITmfTrace)traces.get(0)).getEventAspects());
        } else {
            for (ITmfTrace trace : traces) {
                Iterable traceAspects = trace.getEventAspects();
                builder.addAll(traceAspects);
            }
        }
        return builder.build();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static @Nullable String getCommonTraceType(TmfExperiment experiment) {
        String commonTraceType = null;
        try {
            Iterator iterator = experiment.getTraces().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    return commonTraceType;
                }
                ITmfTrace trace = (ITmfTrace)iterator.next();
                IResource resource = trace.getResource();
                if (resource == null) {
                    return null;
                }
                String traceType = resource.getPersistentProperty(TmfCommonConstants.TRACETYPE);
                if (commonTraceType != null && !commonTraceType.equals(traceType)) {
                    return null;
                }
                commonTraceType = traceType;
            }
        }
        catch (CoreException e) {
            return null;
        }
    }

    @Override
    public ITmfTrace getTrace() {
        return this.fTrace;
    }

    public void setFocus() {
        this.fEventsTable.setFocus();
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (IGotoMarker.class.equals(adapter)) {
            if (this.fTrace == null || this.fEventsTable == null) {
                return adapter.cast(this);
            }
            return adapter.cast(this.fEventsTable);
        }
        if (IPropertySheetPage.class.equals(adapter)) {
            return adapter.cast((Object)new UnsortedPropertySheetPage());
        }
        return (T)super.getAdapter(adapter);
    }

    public void gotoMarker(IMarker marker) {
        if (this.fTrace == null || this.fEventsTable == null) {
            this.fPendingGotoMarker = marker;
        } else {
            this.fEventsTable.gotoMarker(marker);
        }
    }

    public void resourceChanged(IResourceChangeEvent event) {
        final HashSet<@NonNull IMarker> added = new HashSet<IMarker>();
        final HashSet<@NonNull IMarker> removed = new HashSet<IMarker>();
        boolean deltaFound = false;
        IMarkerDelta[] iMarkerDeltaArray = event.findMarkerDeltas("org.eclipse.core.resources.bookmark", false);
        int n = iMarkerDeltaArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            if (delta.getResource().equals((Object)this.fFile)) {
                if (delta.getKind() == 2) {
                    removed.add(delta.getMarker());
                } else if (delta.getKind() == 1) {
                    added.add(delta.getMarker());
                }
                deltaFound = true;
            }
            ++n2;
        }
        if (!deltaFound) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (removed.isEmpty() && added.isEmpty()) {
                    TmfEventsEditor.this.fEventsTable.getTable().refresh();
                } else {
                    if (!removed.isEmpty()) {
                        TmfEventsEditor.this.fEventsTable.removeBookmark((IMarker[])Iterables.toArray((Iterable)removed, IMarker.class));
                    }
                    if (!added.isEmpty()) {
                        TmfEventsEditor.this.fEventsTable.addBookmark((IMarker[])Iterables.toArray((Iterable)added, IMarker.class));
                    }
                }
            }
        });
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.add((Object)listener);
    }

    public ISelection getSelection() {
        if (this.fEventsTable == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fEventsTable.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionChangedListeners.remove((Object)listener);
    }

    public void setSelection(ISelection selection) {
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            final ISelectionChangedListener l = (ISelectionChangedListener)listeners[i];
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++i;
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fireSelectionChanged(event);
    }

    public void partActivated(IWorkbenchPart part) {
        if (part == this && !this.fTraceSelected) {
            this.fTraceSelected = true;
            if (this.fTrace == null) {
                return;
            }
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
        if (part == this && !this.fTraceSelected) {
            this.fTraceSelected = true;
            if (this.fTrace == null) {
                return;
            }
            this.broadcast((TmfSignal)new TmfTraceSelectedSignal((Object)this, this.fTrace));
        }
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    public void addBookmark() {
        this.fEventsTable.addBookmark(this.fFile);
    }

    @TmfSignalHandler
    public void traceSelected(TmfTraceSelectedSignal signal) {
        if (signal.getSource() != this) {
            if (signal.getTrace().equals(this.fTrace)) {
                this.getSite().getPage().bringToTop((IWorkbenchPart)this);
            } else {
                this.fTraceSelected = false;
            }
        }
    }

    @TmfSignalHandler
    public void timestampFormatUpdated(TmfTimestampFormatUpdateSignal signal) {
        if (this.fEventsTable != null) {
            this.fEventsTable.refresh();
        }
    }
}

