/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.api;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Sets;
import java.util.Set;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineManager;
import org.eclipse.viatra.query.runtime.api.ViatraQueryEngineOptions;
import org.eclipse.viatra.query.runtime.api.ViatraQueryMatcher;
import org.eclipse.viatra.query.runtime.api.scope.IBaseIndex;
import org.eclipse.viatra.query.runtime.api.scope.QueryScope;
import org.eclipse.viatra.query.runtime.exception.ViatraQueryException;

public abstract class ViatraQueryEngine {
    public static ViatraQueryEngine on(QueryScope scope) throws ViatraQueryException {
        return ViatraQueryEngineManager.getInstance().getQueryEngine(scope);
    }

    public static ViatraQueryEngine on(QueryScope scope, ViatraQueryEngineOptions options) throws ViatraQueryException {
        return ViatraQueryEngineManager.getInstance().getQueryEngine(scope, options);
    }

    public abstract IBaseIndex getBaseIndex() throws ViatraQueryException;

    public abstract <Matcher extends ViatraQueryMatcher<? extends IPatternMatch>> Matcher getMatcher(IQuerySpecification<Matcher> var1) throws ViatraQueryException;

    public abstract ViatraQueryMatcher<? extends IPatternMatch> getMatcher(String var1) throws ViatraQueryException;

    public abstract <Matcher extends ViatraQueryMatcher<? extends IPatternMatch>> Matcher getExistingMatcher(IQuerySpecification<Matcher> var1);

    public abstract Set<? extends ViatraQueryMatcher<? extends IPatternMatch>> getCurrentMatchers();

    public Set<IQuerySpecification<? extends ViatraQueryMatcher<? extends IPatternMatch>>> getRegisteredQuerySpecifications() {
        return Sets.newHashSet((Iterable)Collections2.transform(this.getCurrentMatchers(), (Function)new Function<ViatraQueryMatcher<?>, IQuerySpecification<?>>(){

            public IQuerySpecification<?> apply(ViatraQueryMatcher<?> arg0) {
                return arg0.getSpecification();
            }
        }));
    }

    public abstract QueryScope getScope();
}

