/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.runtime.registry;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.viatra.query.runtime.api.IQueryGroup;
import org.eclipse.viatra.query.runtime.api.IQuerySpecification;
import org.eclipse.viatra.query.runtime.extensibility.IQueryGroupProvider;
import org.eclipse.viatra.query.runtime.extensibility.IQuerySpecificationProvider;
import org.eclipse.viatra.query.runtime.registry.IConnectorListener;
import org.eclipse.viatra.query.runtime.registry.IRegistrySourceConnector;
import org.eclipse.viatra.query.runtime.registry.QuerySpecificationRegistry;
import org.eclipse.viatra.query.runtime.util.ViatraQueryLoggingUtil;

public class ExtensionBasedQuerySpecificationLoader {
    public static final String CONNECTOR_ID = "org.eclipse.viatra.query.runtime.querygroup.extension.based.connector";
    private static final String DUPLICATE_QUERY_GROUP_MESSAGE = "Duplicate query group identifier %s for plugin %s (already contributed by %s)";
    private static final ExtensionBasedQuerySpecificationLoader INSTANCE = new ExtensionBasedQuerySpecificationLoader();
    private Multimap<String, String> contributingPluginOfGroupMap = HashMultimap.create();
    private Map<String, QueryGroupProvider> contributedQueryGroups;
    private ExtensionBasedSourceConnector sourceConnector;

    public static ExtensionBasedQuerySpecificationLoader getInstance() {
        return INSTANCE;
    }

    public void loadRegisteredQuerySpecificationsIntoRegistry() {
        ((QuerySpecificationRegistry)QuerySpecificationRegistry.getInstance()).addDelayedSourceConnector(this.getSourceConnector());
    }

    public IRegistrySourceConnector getSourceConnector() {
        if (this.sourceConnector == null) {
            this.sourceConnector = new ExtensionBasedSourceConnector();
        }
        return this.sourceConnector;
    }

    private Map<String, QueryGroupProvider> getRegisteredQueryGroups() {
        if (this.contributedQueryGroups != null) {
            return this.contributedQueryGroups;
        }
        this.contributedQueryGroups = Maps.newHashMap();
        if (Platform.isRunning()) {
            ImmutableList config = ImmutableList.builder().add((Object[])Platform.getExtensionRegistry().getConfigurationElementsFor("org.eclipse.viatra.query.runtime.queryspecification")).build();
            for (IConfigurationElement e : config) {
                if (!e.isValid()) continue;
                this.processExtension(e);
            }
        }
        return this.contributedQueryGroups;
    }

    private void processExtension(IConfigurationElement el) {
        String id = null;
        try {
            String contributorName = el.getContributor().getName();
            id = el.getAttribute("id");
            if (id == null) {
                throw new IllegalStateException(String.format("Query group extension identifier is required (plug-in: %s)!", contributorName));
            }
            QueryGroupProvider provider = new QueryGroupProvider(el);
            QueryGroupProvider queryGroupInMap = this.contributedQueryGroups.get(id);
            if (queryGroupInMap != null) {
                Collection contributorPlugins = this.contributingPluginOfGroupMap.get((Object)id);
                throw new IllegalStateException(String.format(DUPLICATE_QUERY_GROUP_MESSAGE, id, contributorName, contributorPlugins));
            }
            this.contributedQueryGroups.put(id, provider);
            this.contributingPluginOfGroupMap.put((Object)id, (Object)contributorName);
        }
        catch (Exception e) {
            if (id == null) {
                id = "undefined in plugin.xml";
            }
            ViatraQueryLoggingUtil.getLogger(ExtensionBasedQuerySpecificationLoader.class).error((Object)("[ExtensionBasedQuerySpecificationLoader] Exception during query specification registry initialization when preparing group: " + id + "! " + e.getMessage()), (Throwable)e);
        }
    }

    private final class ExtensionBasedSourceConnector
    implements IRegistrySourceConnector {
        private Set<IConnectorListener> listeners = Sets.newHashSet();

        @Override
        public String getIdentifier() {
            return ExtensionBasedQuerySpecificationLoader.CONNECTOR_ID;
        }

        @Override
        public void addListener(IConnectorListener listener) {
            Preconditions.checkNotNull((Object)listener, (Object)"Listener must not be null!");
            boolean added = this.listeners.add(listener);
            if (added) {
                for (QueryGroupProvider queryGroupProvider : ExtensionBasedQuerySpecificationLoader.this.getRegisteredQueryGroups().values()) {
                    for (IQuerySpecificationProvider specificationProvider : queryGroupProvider.getQuerySpecificationProviders()) {
                        listener.querySpecificationAdded(this, specificationProvider);
                    }
                }
            }
        }

        @Override
        public void removeListener(IConnectorListener listener) {
            Preconditions.checkNotNull((Object)listener, (Object)"Listener must not be null!");
            this.listeners.remove(listener);
        }

        @Override
        public boolean includeSpecificationsInDefaultViews() {
            return true;
        }
    }

    private static final class GroupBasedQuerySpecificationProvider
    implements IQuerySpecificationProvider {
        private String queryFQN;
        private QueryGroupProvider queryGroupProvider;
        private IQuerySpecification<?> specification;

        public GroupBasedQuerySpecificationProvider(String queryFQN, QueryGroupProvider queryGroupProvider) {
            this.queryFQN = queryFQN;
            this.queryGroupProvider = queryGroupProvider;
            this.specification = null;
        }

        public IQuerySpecification<?> get() {
            if (this.specification == null) {
                if (this.queryGroupProvider.getQuerySpecificationFQNs().contains(this.queryFQN)) {
                    for (IQuerySpecification<?> spec : this.queryGroupProvider.get().getSpecifications()) {
                        if (!spec.getFullyQualifiedName().equals(this.queryFQN)) continue;
                        this.specification = spec;
                    }
                } else {
                    throw new IllegalStateException(String.format("Could not find query specifition %s in group (plug-in %s)", this.queryFQN, this.queryGroupProvider.element.getContributor().getName()));
                }
            }
            return this.specification;
        }

        @Override
        public String getFullyQualifiedName() {
            return this.queryFQN;
        }

        @Override
        public String getSourceProjectName() {
            return this.queryGroupProvider.element.getContributor().getName();
        }
    }

    private static final class QueryGroupProvider
    implements IQueryGroupProvider {
        private static final String DUPLICATE_FQN_MESSAGE = "Duplicate FQN %s in query group extension point (plug-in %s)";
        private final IConfigurationElement element;
        private IQueryGroup queryGroup;
        private Set<String> querySpecificationFQNs;
        private Map<String, IQuerySpecificationProvider> querySpecificationMap;

        public QueryGroupProvider(IConfigurationElement element) {
            this.element = element;
            this.queryGroup = null;
            this.querySpecificationFQNs = null;
            this.querySpecificationMap = null;
        }

        public IQueryGroup get() {
            try {
                if (this.queryGroup == null) {
                    this.queryGroup = (IQueryGroup)this.element.createExecutableExtension("group");
                }
                return this.queryGroup;
            }
            catch (CoreException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
        }

        @Override
        public Set<String> getQuerySpecificationFQNs() {
            if (this.querySpecificationFQNs == null) {
                HashSet fqns = Sets.newHashSet();
                ImmutableList config = ImmutableList.builder().add((Object[])this.element.getChildren("query-specification")).build();
                for (IConfigurationElement e : config) {
                    String fqn;
                    boolean added;
                    if (!e.isValid() || (added = fqns.add(fqn = e.getAttribute("fqn")))) continue;
                    String contributorName = e.getContributor().getName();
                    throw new IllegalArgumentException(String.format(DUPLICATE_FQN_MESSAGE, fqn, contributorName));
                }
                if (fqns.isEmpty()) {
                    IQueryGroup loadedQueryGroup = this.get();
                    for (IQuerySpecification<?> specification : loadedQueryGroup.getSpecifications()) {
                        String fullyQualifiedName = specification.getFullyQualifiedName();
                        boolean added = fqns.add(fullyQualifiedName);
                        if (added) continue;
                        String contributorName = this.element.getContributor().getName();
                        throw new IllegalArgumentException(String.format(DUPLICATE_FQN_MESSAGE, fullyQualifiedName, contributorName));
                    }
                }
                this.querySpecificationFQNs = ImmutableSet.copyOf((Collection)fqns);
            }
            return this.querySpecificationFQNs;
        }

        @Override
        public Set<IQuerySpecificationProvider> getQuerySpecificationProviders() {
            return ImmutableSet.copyOf(this.getQuerySpecificationMap().values());
        }

        private Map<String, IQuerySpecificationProvider> getQuerySpecificationMap() {
            if (this.querySpecificationMap == null) {
                this.querySpecificationMap = Maps.newHashMap();
                Set<String> fqns = this.getQuerySpecificationFQNs();
                for (String fqn : fqns) {
                    this.querySpecificationMap.put(fqn, new GroupBasedQuerySpecificationProvider(fqn, this));
                }
            }
            return this.querySpecificationMap;
        }
    }
}

