/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists.swing;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.FilterList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.swing.AdvancedListSelectionModel;
import ca.odell.glazedlists.swing.AdvancedTableModel;
import ca.odell.glazedlists.swing.GlazedListsSwing;
import ca.odell.glazedlists.swing.TableComparatorChooser;
import ca.odell.glazedlists.swing.TextComponentMatcherEditor;
import com.publicobject.issuesbrowser.Issue;
import com.publicobject.issuesbrowser.IssueTableFormat;
import com.publicobject.issuesbrowser.IssueTextFilterator;
import com.publicobject.issuesbrowser.IssueTrackingSystem;
import com.publicobject.issuesbrowser.Project;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import org.jdesktop.swingx.JXTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JXTableTestApp2
implements Runnable {
    private EventList<Issue> issues;

    public JXTableTestApp2(EventList<Issue> issues) {
        this.issues = issues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.issues.getReadWriteLock().writeLock().lock();
        try {
            JTextField filterEdit = new JTextField(12);
            TextComponentMatcherEditor textMatcherEditor = new TextComponentMatcherEditor(filterEdit, new IssueTextFilterator());
            FilterList<Issue> textFilteredIssues = new FilterList<Issue>(this.issues, textMatcherEditor);
            SortedList<Issue> sortedIssues = new SortedList<Issue>(textFilteredIssues, null);
            TransformedList<Issue, Issue> issueProxyList = GlazedListsSwing.swingThreadProxyList(sortedIssues);
            AdvancedTableModel tableModel = GlazedListsSwing.eventTableModel(issueProxyList, new IssueTableFormat());
            AdvancedListSelectionModel selectionModel = GlazedListsSwing.eventSelectionModel(issueProxyList);
            JPanel filterPanel = new JPanel(new FlowLayout(0));
            filterPanel.add(new JLabel("Filter:"));
            filterPanel.add(filterEdit);
            JXTable table = new JXTable(tableModel);
            table.setSortable(false);
            table.getTableHeader().setDefaultRenderer(new JTableHeader().getDefaultRenderer());
            table.getSelectionMapper().setEnabled(false);
            table.setSelectionModel(selectionModel);
            table.setColumnControlVisible(true);
            TableComparatorChooser.install((JTable)table, sortedIssues, TableComparatorChooser.MULTIPLE_COLUMN_MOUSE_WITH_UNDO);
            JFrame frame = new JFrame();
            frame.setDefaultCloseOperation(3);
            frame.getContentPane().setLayout(new BorderLayout());
            frame.getContentPane().add((Component)filterPanel, "North");
            frame.getContentPane().add((Component)new JScrollPane((Component)table), "Center");
            frame.pack();
            frame.setVisible(true);
        }
        finally {
            this.issues.getReadWriteLock().writeLock().unlock();
        }
    }

    public static void main(String[] args) {
        BasicEventList<Issue> issues = new BasicEventList<Issue>();
        new Thread(new IssueLoader(issues, args[0])).start();
        SwingUtilities.invokeLater(new JXTableTestApp2(issues));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IssueLoader
    implements Runnable {
        private EventList<Issue> issues;
        private Project project;

        public IssueLoader(EventList<Issue> issues, String filename) {
            this.issues = issues;
            this.project = new Project("Glazed Lists", "Glazed Lists", IssueTrackingSystem.getJavaNetJira());
            this.project.setFileName(filename);
        }

        @Override
        public void run() {
            try {
                this.project.getOwner().loadIssues(GlazedLists.threadSafeList(this.issues), (InputStream)new FileInputStream(this.project.getFileName()), this.project);
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
        }
    }

    private static class IssueStateComparator
    implements Comparator {
        private static final List STATES = Arrays.asList("UNCONFIRMED", "NEW", "STARTED", "REOPENED", "RESOLVED", "VERIFIED", "CLOSED");

        private IssueStateComparator() {
        }

        public int compare(Object a, Object b) {
            int stateIndexA = STATES.indexOf(a);
            int stateIndexB = STATES.indexOf(b);
            if (stateIndexA == -1 || stateIndexB == -1) {
                throw new IllegalStateException();
            }
            return stateIndexA - stateIndexB;
        }
    }
}

