/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.rpc.server;

import com.google.gwt.rpc.client.ast.CommandSink;
import com.google.gwt.rpc.client.ast.HasValues;
import com.google.gwt.rpc.client.ast.ReturnCommand;
import com.google.gwt.rpc.client.ast.RpcCommand;
import com.google.gwt.rpc.client.ast.ThrowCommand;
import com.google.gwt.rpc.client.impl.HasValuesCommandSink;
import com.google.gwt.rpc.client.impl.RemoteException;
import com.google.gwt.rpc.server.ClientOracle;
import com.google.gwt.rpc.server.CommandSerializationUtil;
import com.google.gwt.rpc.server.CommandServerSerializationStreamReader;
import com.google.gwt.rpc.server.CommandServerSerializationStreamWriter;
import com.google.gwt.rpc.server.RpcServlet;
import com.google.gwt.rpc.server.SimplePayloadDecoder;
import com.google.gwt.user.client.rpc.IncompatibleRemoteServiceException;
import com.google.gwt.user.client.rpc.RemoteService;
import com.google.gwt.user.client.rpc.SerializationException;
import com.google.gwt.user.server.rpc.RPCRequest;
import com.google.gwt.user.server.rpc.RPCServletUtils;
import com.google.gwt.user.server.rpc.UnexpectedException;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RPC {
    private static final HashMap<String, Class<?>> TYPE_NAMES = new HashMap();
    private static final Map<Class<?>, Set<String>> serviceToImplementedInterfacesMap = new HashMap();

    public static RPCRequest decodeRequest(String encodedRequest, Class<?> type, ClientOracle clientOracle) throws RemoteException {
        if (encodedRequest == null) {
            throw new NullPointerException("encodedRequest cannot be null");
        }
        if (encodedRequest.length() == 0) {
            throw new IllegalArgumentException("encodedRequest cannot be empty");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<?> serviceIntf;
            SimplePayloadDecoder decoder;
            try {
                decoder = new SimplePayloadDecoder(clientOracle, encodedRequest);
            }
            catch (ClassNotFoundException e) {
                throw new IncompatibleRemoteServiceException("Client does not have a type sent by the server", e);
            }
            CommandServerSerializationStreamReader streamReader = new CommandServerSerializationStreamReader();
            if (decoder.getThrownValue() != null) {
                streamReader.prepareToRead(Collections.singletonList(decoder.getThrownValue()));
                try {
                    throw new RemoteException((Throwable)streamReader.readObject());
                }
                catch (ClassCastException e) {
                    throw new SerializationException("The remote end threw something other than a Throwable", e);
                }
                catch (SerializationException e) {
                    throw new IncompatibleRemoteServiceException("The remote end threw an exception which could not be deserialized", e);
                }
            }
            streamReader.prepareToRead(decoder.getValues());
            String serviceIntfName = streamReader.readString();
            if (type != null && !RPC.implementsInterface(type, serviceIntfName)) {
                throw new IncompatibleRemoteServiceException("Blocked attempt to access interface '" + serviceIntfName + "', which is not implemented by '" + RPC.printTypeName(type) + "'; this is either misconfiguration or a hack attempt");
            }
            try {
                serviceIntf = RPC.getClassFromSerializedName(null, serviceIntfName, classLoader);
                if (!RemoteService.class.isAssignableFrom(serviceIntf)) {
                    throw new IncompatibleRemoteServiceException("Blocked attempt to access interface '" + RPC.printTypeName(serviceIntf) + "', which doesn't extend RpcService; " + "this is either misconfiguration or a hack attempt");
                }
            }
            catch (ClassNotFoundException e) {
                throw new IncompatibleRemoteServiceException("Could not locate requested interface '" + serviceIntfName + "' in default classloader", e);
            }
            String serviceMethodName = streamReader.readString();
            int paramCount = streamReader.readInt();
            Class[] parameterTypes = new Class[paramCount];
            for (int i = 0; i < parameterTypes.length; ++i) {
                String paramClassName = streamReader.readString();
                try {
                    parameterTypes[i] = RPC.getClassFromSerializedName(clientOracle, paramClassName, classLoader);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    throw new IncompatibleRemoteServiceException("Parameter " + i + " of is of an unknown type '" + paramClassName + "'", e);
                }
            }
            try {
                Method method = serviceIntf.getMethod(serviceMethodName, parameterTypes);
                Object[] parameterValues = new Object[parameterTypes.length];
                for (int i = 0; i < parameterValues.length; ++i) {
                    Object o;
                    parameterValues[i] = o = CommandSerializationUtil.getAccessor(parameterTypes[i]).readNext(streamReader);
                }
                return new RPCRequest(method, parameterValues, null, 0);
            }
            catch (NoSuchMethodException e) {
                throw new IncompatibleRemoteServiceException(RPC.formatMethodNotFoundErrorMessage(serviceIntf, serviceMethodName, parameterTypes));
            }
        }
        catch (SerializationException ex) {
            throw new IncompatibleRemoteServiceException(ex.getMessage(), ex);
        }
    }

    public static void invokeAndStreamResponse(Object target, Method serviceMethod, Object[] args, ClientOracle clientOracle, OutputStream stream) throws SerializationException {
        CommandSink sink;
        if (serviceMethod == null) {
            throw new NullPointerException("serviceMethod");
        }
        if (clientOracle == null) {
            throw new NullPointerException("clientOracle");
        }
        try {
            sink = clientOracle.createCommandSink(stream);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to initialize output", e);
        }
        try {
            Object result = serviceMethod.invoke(target, args);
            try {
                RPC.streamResponse(clientOracle, result, sink, false);
            }
            catch (SerializationException e) {
                RPC.streamResponse(clientOracle, e, sink, true);
            }
        }
        catch (IllegalAccessException e) {
            SecurityException securityException = new SecurityException(RPC.formatIllegalAccessErrorMessage(target, serviceMethod));
            securityException.initCause(e);
            throw securityException;
        }
        catch (IllegalArgumentException e) {
            SecurityException securityException = new SecurityException(RPC.formatIllegalArgumentErrorMessage(target, serviceMethod, args));
            securityException.initCause(e);
            throw securityException;
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (!RPCServletUtils.isExpectedException(serviceMethod, cause)) {
                throw new UnexpectedException("Service method '" + RPC.getSourceRepresentation(serviceMethod) + "' threw an unexpected exception: " + cause.toString(), cause);
            }
            RPC.streamResponse(clientOracle, cause, sink, true);
        }
        sink.finish();
    }

    public static void streamResponseForFailure(ClientOracle clientOracle, OutputStream out, Throwable payload) throws SerializationException {
        CommandSink sink;
        try {
            sink = clientOracle.createCommandSink(out);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to initialize output", e);
        }
        RPC.streamResponse(clientOracle, payload, sink, true);
        sink.finish();
    }

    public static void streamResponseForSuccess(ClientOracle clientOracle, OutputStream out, Object payload) throws SerializationException {
        CommandSink sink;
        try {
            sink = clientOracle.createCommandSink(out);
        }
        catch (IOException e) {
            throw new SerializationException("Unable to initialize output", e);
        }
        RPC.streamResponse(clientOracle, payload, sink, false);
        sink.finish();
    }

    private static String formatIllegalAccessErrorMessage(Object target, Method serviceMethod) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to access inaccessible method '");
        sb.append(RPC.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(RPC.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append("; this is either misconfiguration or a hack attempt");
        return sb.toString();
    }

    private static String formatIllegalArgumentErrorMessage(Object target, Method serviceMethod, Object[] args) {
        StringBuffer sb = new StringBuffer();
        sb.append("Blocked attempt to invoke method '");
        sb.append(RPC.getSourceRepresentation(serviceMethod));
        sb.append("'");
        if (target != null) {
            sb.append(" on target '");
            sb.append(RPC.printTypeName(target.getClass()));
            sb.append("'");
        }
        sb.append(" with invalid arguments");
        if (args != null && args.length > 0) {
            sb.append(Arrays.asList(args));
        }
        return sb.toString();
    }

    private static String formatMethodNotFoundErrorMessage(Class<?> serviceIntf, String serviceMethodName, Class<?>[] parameterTypes) {
        StringBuffer sb = new StringBuffer();
        sb.append("Could not locate requested method '");
        sb.append(serviceMethodName);
        sb.append("(");
        for (int i = 0; i < parameterTypes.length; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(RPC.printTypeName(parameterTypes[i]));
        }
        sb.append(")'");
        sb.append(" in interface '");
        sb.append(RPC.printTypeName(serviceIntf));
        sb.append("'");
        return sb.toString();
    }

    private static Class<?> getClassFromSerializedName(ClientOracle clientOracle, String serializedName, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> value = TYPE_NAMES.get(serializedName);
        if (value != null) {
            return value;
        }
        if (serializedName.charAt(0) == ' ') {
            serializedName = serializedName.substring(1);
        } else if (clientOracle != null) {
            serializedName = clientOracle.getTypeName(serializedName);
        }
        assert (serializedName != null);
        return Class.forName(serializedName, false, classLoader);
    }

    private static String getSourceRepresentation(Method method) {
        return method.toString().replace('$', '.');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean implementsInterface(Class<?> service, String intfName) {
        Map<Class<?>, Set<String>> map = serviceToImplementedInterfacesMap;
        synchronized (map) {
            Set<String> interfaceSet = serviceToImplementedInterfacesMap.get(service);
            if (interfaceSet != null) {
                if (interfaceSet.contains(intfName)) {
                    return true;
                }
            } else {
                interfaceSet = new HashSet<String>();
                serviceToImplementedInterfacesMap.put(service, interfaceSet);
            }
            if (!service.isInterface()) {
                while (service != null && !RpcServlet.class.equals(service)) {
                    Class<?>[] intfs;
                    for (Class<?> intf : intfs = service.getInterfaces()) {
                        if (!RPC.implementsInterfaceRecursive(intf, intfName)) continue;
                        interfaceSet.add(intfName);
                        return true;
                    }
                    service = service.getSuperclass();
                }
            } else if (RPC.implementsInterfaceRecursive(service, intfName)) {
                interfaceSet.add(intfName);
                return true;
            }
            return false;
        }
    }

    private static boolean implementsInterfaceRecursive(Class<?> clazz, String intfName) {
        Class<?>[] intfs;
        assert (clazz.isInterface());
        if (clazz.getName().equals(intfName)) {
            return true;
        }
        for (Class<?> intf : intfs = clazz.getInterfaces()) {
            if (!RPC.implementsInterfaceRecursive(intf, intfName)) continue;
            return true;
        }
        return false;
    }

    private static String printTypeName(Class<?> type) {
        if (type.equals(Integer.TYPE)) {
            return "int";
        }
        if (type.equals(Long.TYPE)) {
            return "long";
        }
        if (type.equals(Short.TYPE)) {
            return "short";
        }
        if (type.equals(Byte.TYPE)) {
            return "byte";
        }
        if (type.equals(Character.TYPE)) {
            return "char";
        }
        if (type.equals(Boolean.TYPE)) {
            return "boolean";
        }
        if (type.equals(Float.TYPE)) {
            return "float";
        }
        if (type.equals(Double.TYPE)) {
            return "double";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return RPC.printTypeName(componentType) + "[]";
        }
        return type.getName().replace('$', '.');
    }

    private static void streamResponse(ClientOracle clientOracle, Object payload, CommandSink sink, boolean asThrow) throws SerializationException {
        RpcCommand command;
        if (asThrow) {
            command = new ThrowCommand();
            assert (payload instanceof Throwable) : "Trying to throw something other than a Throwable";
        } else {
            command = new ReturnCommand();
        }
        CommandServerSerializationStreamWriter out = new CommandServerSerializationStreamWriter(clientOracle, new HasValuesCommandSink((HasValues)((Object)command)));
        out.writeObject(payload);
        sink.accept(command);
    }

    private RPC() {
    }

    static {
        TYPE_NAMES.put(" Z", Boolean.TYPE);
        TYPE_NAMES.put(" B", Byte.TYPE);
        TYPE_NAMES.put(" C", Character.TYPE);
        TYPE_NAMES.put(" D", Double.TYPE);
        TYPE_NAMES.put(" F", Float.TYPE);
        TYPE_NAMES.put(" I", Integer.TYPE);
        TYPE_NAMES.put(" J", Long.TYPE);
        TYPE_NAMES.put(" S", Short.TYPE);
    }
}

