/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.nattable.selection;

import java.util.HashMap;
import java.util.Map;
import net.sourceforge.nattable.config.IConfigRegistry;
import net.sourceforge.nattable.coordinate.PositionCoordinate;
import net.sourceforge.nattable.layer.ILayer;
import net.sourceforge.nattable.layer.cell.LayerCell;
import net.sourceforge.nattable.painter.layer.GridLineCellLayerPainter;
import net.sourceforge.nattable.util.GUIHelper;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class SelectionLayerPainter
extends GridLineCellLayerPainter {
    private int columnPositionOffset;
    private int rowPositionOffset;
    private Map<PositionCoordinate, LayerCell> cells;

    public void paintLayer(ILayer natLayer, GC gc, int xOffset, int yOffset, Rectangle pixelRectangle, IConfigRegistry configRegistry) {
        Rectangle cellBounds;
        LayerCell cell;
        Rectangle positionRectangle = this.getPositionRectangleFromPixelRectangle(natLayer, pixelRectangle);
        this.columnPositionOffset = positionRectangle.x;
        this.rowPositionOffset = positionRectangle.y;
        this.cells = new HashMap<PositionCoordinate, LayerCell>();
        super.paintLayer(natLayer, gc, xOffset, yOffset, pixelRectangle, configRegistry);
        int originalLineStyle = gc.getLineStyle();
        Color originalForeground = gc.getForeground();
        gc.setLineStyle(6);
        gc.setLineDash(new int[]{1, 1});
        gc.setForeground(GUIHelper.COLOR_BLACK);
        boolean selectedMode = false;
        int columnPosition = this.columnPositionOffset;
        while (columnPosition < this.columnPositionOffset + positionRectangle.width) {
            cell = null;
            int rowPosition = this.rowPositionOffset;
            while (rowPosition < this.rowPositionOffset + positionRectangle.height) {
                cell = this.cells.get(new PositionCoordinate(natLayer, columnPosition, rowPosition));
                if (cell != null && selectedMode != this.isSelected(cell)) {
                    selectedMode = !selectedMode;
                    cellBounds = cell.getBounds();
                    gc.drawLine(cellBounds.x - 1, cellBounds.y - 1, cellBounds.x + cellBounds.width - 1, cellBounds.y - 1);
                }
                ++rowPosition;
            }
            if (selectedMode && cell != null) {
                Rectangle cellBounds2 = cell.getBounds();
                gc.drawLine(cellBounds2.x - 1, cellBounds2.y + cellBounds2.height - 1, cellBounds2.x + cellBounds2.width - 1, cellBounds2.y + cellBounds2.height - 1);
            }
            selectedMode = false;
            ++columnPosition;
        }
        int rowPosition = this.rowPositionOffset;
        while (rowPosition < this.rowPositionOffset + positionRectangle.height) {
            cell = null;
            int columnPosition2 = this.columnPositionOffset;
            while (columnPosition2 < this.columnPositionOffset + positionRectangle.width) {
                cell = this.cells.get(new PositionCoordinate(natLayer, columnPosition2, rowPosition));
                if (cell != null && selectedMode != this.isSelected(cell)) {
                    selectedMode = !selectedMode;
                    cellBounds = cell.getBounds();
                    gc.drawLine(cellBounds.x - 1, cellBounds.y - 1, cellBounds.x - 1, cellBounds.y + cellBounds.height - 1);
                }
                ++columnPosition2;
            }
            if (selectedMode && cell != null) {
                Rectangle cellBounds3 = cell.getBounds();
                gc.drawLine(cellBounds3.x + cellBounds3.width - 1, cellBounds3.y - 1, cellBounds3.x + cellBounds3.width - 1, cellBounds3.y + cellBounds3.height - 1);
            }
            selectedMode = false;
            ++rowPosition;
        }
        gc.setLineStyle(originalLineStyle);
        gc.setForeground(originalForeground);
    }

    protected void paintCell(LayerCell cell, GC gc, IConfigRegistry configRegistry) {
        int columnPosition = cell.getColumnPosition();
        while (columnPosition < cell.getColumnPosition() + cell.getColumnSpan()) {
            int rowPosition = cell.getRowPosition();
            while (rowPosition < cell.getRowPosition() + cell.getRowSpan()) {
                this.cells.put(new PositionCoordinate(cell.getLayer(), columnPosition, rowPosition), cell);
                ++rowPosition;
            }
            ++columnPosition;
        }
        super.paintCell(cell, gc, configRegistry);
    }

    private boolean isSelected(LayerCell cell) {
        return cell.getDisplayMode() == "SELECT";
    }
}

