/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.engines.blind.html;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import org.eclipse.actf.visualization.engines.blind.ParamBlind;
import org.eclipse.actf.visualization.engines.blind.TextCheckResult;
import org.eclipse.actf.visualization.engines.blind.TextChecker;
import org.eclipse.actf.visualization.engines.blind.html.IVisualizeMapData;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.VisualizeStyleInfo;
import org.eclipse.actf.visualization.engines.blind.html.ui.elementViewer.impl.VisualizeStyleInfoManager;
import org.eclipse.actf.visualization.engines.blind.html.util.Id2LineViaActfId;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacket;
import org.eclipse.actf.visualization.engines.voicebrowser.IPacketCollection;
import org.eclipse.actf.visualization.engines.voicebrowser.IVoiceBrowserController;
import org.eclipse.actf.visualization.engines.voicebrowser.VoiceBrowserControllerFactory;
import org.eclipse.actf.visualization.eval.EvaluationUtil;
import org.eclipse.actf.visualization.eval.IEvaluationItem;
import org.eclipse.actf.visualization.eval.guideline.GuidelineHolder;
import org.eclipse.actf.visualization.eval.html.HtmlTagUtil;
import org.eclipse.actf.visualization.eval.html.statistics.PageData;
import org.eclipse.actf.visualization.eval.problem.IProblemItem;
import org.eclipse.actf.visualization.internal.engines.blind.html.BlindProblem;
import org.eclipse.actf.visualization.internal.engines.blind.html.Messages;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.DocumentCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.ImgChecker;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.LinkAnalyzer;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.NodeInfoCreator;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationNodeInfo;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizationResultCleaner;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeColorUtil;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapDataImpl;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeMapUtil;
import org.eclipse.actf.visualization.internal.engines.blind.html.util.VisualizeViewUtil;
import org.eclipse.actf.visualization.util.html2view.Html2ViewMapData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VisualizeEngine {
    public static String ERROR_ICON_NAME = "exclawhite21.gif";
    private static final String errorStyle = "color: #dd0000; background-color: #FFFFFF; border-width: medium; border-style: solid; border-color: #dd0000;";
    private static final String CHECK_ITEM_PATTERN = "B_\\p{Digit}+";
    private String baseUrl = "";
    private String targetUrl = "";
    private Document orig = null;
    private Document result = null;
    private List<IProblemItem> problems = null;
    private Vector<Html2ViewMapData> html2viewMapV = new Vector();
    private VisualizeMapDataImpl mapData = null;
    private VisualizeStyleInfo styleInfo;
    private IVoiceBrowserController jwatc = null;
    private boolean fIsActivating = false;
    private IPacketCollection allPc = null;
    private boolean servletMode = false;
    private boolean isHTML5 = false;
    private int iMaxTime;
    private int iMaxTimeLeaf;
    private Set<String> invisibleIdSet = new HashSet<String>();
    private TextChecker textChecker;
    private PageData pageData;
    private GuidelineHolder guidelineHolder = GuidelineHolder.getInstance();
    private boolean[] checkItems = new boolean[39];
    private File variantFile;

    public VisualizeEngine() {
        this.jwatInit();
        this.initCheckItems();
        this.textChecker = TextChecker.getInstance();
    }

    private void initCheckItems() {
        Arrays.fill(this.checkItems, false);
        Set set = this.guidelineHolder.getMatchedCheckitemSet();
        for (IEvaluationItem iEvaluationItem : set) {
            String string = iEvaluationItem.getId();
            if (!string.matches(CHECK_ITEM_PATTERN)) continue;
            string = string.substring(2);
            try {
                int n = Integer.parseInt(string);
                if (n <= -1 || n >= 39) continue;
                this.checkItems[n] = true;
            }
            catch (Exception exception) {}
        }
    }

    public void setDocument(Document document) {
        DocumentCleaner.removeDisplayNone(document);
        NodeList nodeList = document.getElementsByTagName("template");
        int n = 0;
        while (n < nodeList.getLength()) {
            Element element = (Element)nodeList.item(n);
            NodeList nodeList2 = element.getChildNodes();
            int n2 = nodeList2.getLength() - 1;
            while (n2 >= 0) {
                element.removeChild(nodeList2.item(n2));
                --n2;
            }
            ++n;
        }
        this.orig = document;
        this.result = (Document)document.cloneNode(true);
        this.jwatc.setDocument(this.result);
        this.pageData = new PageData();
        this.mapData = new VisualizeMapDataImpl();
        VisualizeMapUtil.createNode2NodeMap(document, this.result, this.mapData);
    }

    private void cleanupPacketCollection(IPacketCollection iPacketCollection) {
        if (iPacketCollection != null) {
            int n = iPacketCollection.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                IPacket iPacket = (IPacket)iPacketCollection.get(n2);
                Node node = iPacket.getNode();
                while (node != null) {
                    String string = node.getNodeName();
                    if ("noscript".equals(string) || "template".equals(string)) {
                        iPacketCollection.remove(n2);
                        break;
                    }
                    node = node.getParentNode();
                }
                --n2;
            }
        }
    }

    private void replaceMathML_SVG_PacketCollection(IPacketCollection iPacketCollection) {
        if (iPacketCollection != null) {
            int n = iPacketCollection.size();
            int n2 = n - 1;
            while (n2 >= 0) {
                IPacket iPacket = (IPacket)iPacketCollection.get(n2);
                Node node = iPacket.getNode();
                while (node != null) {
                    String string = node.getNodeName();
                    if (string.equals("math") || string.equals("svg")) {
                        iPacketCollection.remove(n2);
                        break;
                    }
                    node = node.getParentNode();
                }
                --n2;
            }
        }
    }

    public void visualize() {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.result == null) {
            return;
        }
        this.problems = new Vector<IProblemItem>();
        this.allPc = this.jwatc.getPacketCollection();
        this.cleanupPacketCollection(this.allPc);
        ParamBlind paramBlind = ParamBlind.getInstance();
        NodeInfoCreator nodeInfoCreator = new NodeInfoCreator(this.mapData, this.textChecker, this.problems, this.invisibleIdSet, paramBlind);
        nodeInfoCreator.prepareNodeInfo(this.allPc);
        nodeInfoCreator.createAdditionalNodeInfo(this.result);
        LinkAnalyzer linkAnalyzer = new LinkAnalyzer(this.result, this.allPc, this.mapData, this.problems, this.invisibleIdSet, paramBlind, this.pageData);
        this.styleInfo = new VisualizeStyleInfo(this.orig, this.mapData);
        this.mapData.makeIdMapping("eclipse-actf-id");
        this.styleInfo.setImportedCssSet(DocumentCleaner.removeCSS(this.result, this.targetUrl));
        if (this.result.getElementsByTagName("head").getLength() == 0) {
            object4 = this.result.createElement("head");
            object3 = this.result.getDocumentElement();
            if (object3 != null) {
                object3.insertBefore((Node)object4, object3.getFirstChild());
            }
        }
        object4 = new VisualizeColorUtil(this.result, this.mapData, paramBlind, this.isHTML5);
        ((VisualizeColorUtil)object4).setColorAll();
        this.calMaxTime();
        this.problems.addAll(linkAnalyzer.skipLinkCheck(this.iMaxTime, this.iMaxTimeLeaf));
        Object object5 = new String[]{"svg", "math"};
        int n = ((String[])object5).length;
        int n2 = 0;
        while (n2 < n) {
            object3 = object5[n2];
            NodeList nodeList2 = this.orig.getElementsByTagName((String)object3);
            int n3 = 0;
            while (n3 < nodeList2.getLength()) {
                object2 = (Element)nodeList2.item(n3);
                object = object2.getChildNodes();
                int n4 = object.getLength() - 1;
                while (n4 >= 0) {
                    object2.removeChild(object.item(n4));
                    --n4;
                }
                ++n3;
            }
            ++n2;
        }
        this.replaceElement(this.result, "math", new String[0], "MathML");
        this.replaceElement(this.result, "svg", new String[]{"title", "desc"}, "SVG");
        this.replaceElement(this.result, "canvas", new String[0], "canvas");
        this.replaceElement(this.result, "video", new String[0], "video");
        this.replaceElement(this.result, "audio", new String[0], "audio");
        this.replaceElement(this.result, "template", new String[0], null);
        this.visualizeProgress(this.result);
        this.replaceElement(this.result, "meter", new String[0], "meter");
        this.replaceImgAndCheck(this.result, this.mapData, paramBlind.oReplaceImage);
        int n5 = 0;
        n2 = 0;
        n = 0;
        object5 = this.problems.iterator();
        while (object5.hasNext()) {
            IProblemItem iProblemItem = (IProblemItem)object5.next();
            if (!(iProblemItem instanceof BlindProblem)) continue;
            BlindProblem blindProblem = (BlindProblem)iProblemItem;
            if (this.checkItems[blindProblem.getSubType()]) {
                if (blindProblem.getSeverity() != 1) continue;
                switch (blindProblem.getSubType()) {
                    case 0: 
                    case 1: {
                        ++n2;
                        ++n5;
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 29: 
                    case 30: 
                    case 38: {
                        ++n;
                        ++n5;
                    }
                }
                continue;
            }
            object5.remove();
        }
        this.pageData.setImageAltErrorNum(n5);
        this.pageData.setWrongAltNum(n);
        this.pageData.setMissingAltNum(n2);
        VisualizeViewUtil.visualizeError(this.result, this.problems, this.mapData, this.baseUrl);
        DocumentCleaner.removeJavaScript(this.mapData.getNodeInfoList(), this.result);
        DocumentCleaner.removeMeta(this.result);
        DocumentCleaner.removeObject(this.result);
        DocumentCleaner.removeEmbed(this.result);
        DocumentCleaner.removeApplet(this.result);
        DocumentCleaner.removeBase(this.result);
        DocumentCleaner.removePI(this.result);
        VisualizationResultCleaner.clean(this.result, this.targetUrl);
        object5 = null;
        if (EvaluationUtil.isOriginalDOM()) {
            object5 = new Id2LineViaActfId(this.mapData.getId2AccIdMap(), this.html2viewMapV);
        }
        for (IProblemItem iProblemItem : this.problems) {
            object2 = (BlindProblem)iProblemItem;
            ((BlindProblem)object2).prepareHighlight();
            if (object5 == null) continue;
            ((BlindProblem)object2).setLineNumber((Id2LineViaActfId)object5);
        }
        NodeList nodeList = this.result.getElementsByTagName("input");
        NodeList nodeList2 = this.orig.getElementsByTagName("datalist");
        if (nodeList2.getLength() > 0) {
            int n6 = 0;
            while (n6 < nodeList.getLength()) {
                object = (Element)nodeList.item(n6);
                String string = object.getAttribute("list");
                int n7 = 0;
                while (n7 < nodeList2.getLength()) {
                    Node node;
                    Element element = (Element)nodeList2.item(n7);
                    String string2 = element.getAttribute("id");
                    if (string2 != null && string2.equals(string) && (node = this.mapData.getResultNode(element)) != null && node instanceof Element) {
                        String string3 = ((Element)node).getAttribute("id");
                        object.setAttribute("list", string3);
                    }
                    ++n7;
                }
                ++n6;
            }
        }
        VisualizeStyleInfoManager.getInstance().fireVisualizeStyleInfoUpdate(this.styleInfo);
        if (paramBlind.visualizeMode.equals(ParamBlind.BLIND_BROWSER_MODE)) {
            this.replaceMathML_SVG_PacketCollection(this.allPc);
            VisualizeViewUtil.returnTextView(this.result, this.allPc, this.baseUrl);
            return;
        }
        this.variantFile = VisualizeViewUtil.prepareActions(this.result, this.mapData, this.baseUrl, this.servletMode);
        if (this.isHTML5) {
            VisualizeViewUtil.visualizeLandmark(this.result, this.baseUrl);
        }
    }

    private void replaceElement(Document document, String string, String[] stringArray, String string2) {
        NodeList nodeList = document.getElementsByTagName(string);
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Object object;
            Element element = (Element)nodeList.item(n2);
            Element element2 = document.createElement("div");
            element2.setAttribute("comment", element.getAttribute("comment"));
            element2.setAttribute("id", element.getAttribute("id"));
            if (string2 != null) {
                object = new StringBuffer();
                ((StringBuffer)object).append("(" + string2);
                int n3 = 0;
                while (n3 < stringArray.length) {
                    NodeList nodeList2 = element.getElementsByTagName(stringArray[n3]);
                    int n4 = 0;
                    while (n4 < nodeList2.getLength()) {
                        Node node = nodeList2.item(0).getFirstChild();
                        String string3 = "";
                        if (node != null) {
                            string3 = HtmlTagUtil.getTextDescendant((Node)node);
                        }
                        if (string3.length() > 0) {
                            ((StringBuffer)object).append(" " + stringArray[n3] + ": \"" + string3 + "\"");
                            break;
                        }
                        ++n4;
                    }
                    ++n3;
                }
                ((StringBuffer)object).append(")");
                element2.appendChild(document.createTextNode(((StringBuffer)object).toString()));
            }
            object = element.getParentNode();
            object.insertBefore(element2, element);
            this.mapData.addReplacedNodeMapping(element, element2);
            object.removeChild(element);
            --n2;
        }
    }

    private void visualizeProgress(Document document) {
        NodeList nodeList = document.getElementsByTagName("progress");
        int n = nodeList.getLength();
        int n2 = n - 1;
        while (n2 >= 0) {
            Element element = (Element)nodeList.item(n2);
            Element element2 = document.createElement("div");
            element2.setAttribute("comment", element.getAttribute("comment"));
            element2.setAttribute("id", element.getAttribute("id"));
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("(progress bar: ");
            double d = 1.0;
            double d2 = 0.0;
            if (element.hasAttribute("value")) {
                double d3;
                try {
                    d3 = Double.parseDouble(element.getAttribute("value"));
                    if (d3 > d2) {
                        d2 = d3;
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                if (element.hasAttribute("max") && (d3 = Double.parseDouble(element.getAttribute("max"))) > 0.0) {
                    d = d3;
                }
                if (d2 > d) {
                    stringBuffer.append("100%");
                } else {
                    stringBuffer.append(d2 / d * 100.0);
                    stringBuffer.append("%");
                }
            } else {
                stringBuffer.append(Messages.ProgressBar_1);
            }
            stringBuffer.append(")");
            element2.appendChild(document.createTextNode(stringBuffer.toString()));
            Node node = element.getParentNode();
            node.insertBefore(element2, element);
            this.mapData.addReplacedNodeMapping(element, element2);
            node.removeChild(element);
            --n2;
        }
    }

    private void replaceImgAndCheck(Document document, VisualizeMapDataImpl visualizeMapDataImpl, boolean bl) {
        Object object;
        String string;
        Element element;
        Element element2;
        NodeList nodeList = document.getElementsByTagName("map");
        HashMap<String, Element> hashMap = new HashMap<String, Element>();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Element element3 = (Element)nodeList.item(n2);
            hashMap.put(element3.getAttribute("name"), element3);
            ++n2;
        }
        NodeList nodeList2 = document.getElementsByTagName("img");
        int n3 = nodeList2.getLength();
        Vector<IProblemItem> vector = new Vector<IProblemItem>();
        ImgChecker imgChecker = new ImgChecker(visualizeMapDataImpl, hashMap, this.textChecker, vector, this.baseUrl, this.checkItems);
        this.pageData.setTotalImageNumber(n3);
        int n4 = n3 - 1;
        while (n4 >= 0) {
            element2 = (Element)nodeList2.item(n4);
            imgChecker.checkAndReplaceImg(element2, document, bl);
            --n4;
        }
        n3 = vector.size();
        n4 = n3 - 1;
        while (n4 >= 0) {
            element2 = vector.get(n4);
            this.problems.add((IProblemItem)element2);
            --n4;
        }
        nodeList2 = document.getElementsByTagName("iframe");
        n3 = nodeList2.getLength();
        n4 = n3 - 1;
        while (n4 >= 0) {
            element2 = (Element)nodeList2.item(n4);
            element = document.createElement("div");
            element.setAttribute("comment", element2.getAttribute("comment"));
            element.setAttribute("id", element2.getAttribute("id"));
            string = null;
            boolean bl2 = false;
            object = element2.getAttributes();
            int n5 = object.getLength();
            Node node = null;
            int n6 = 0;
            while (n6 < n5) {
                Node node2 = object.item(n6);
                if (node2.getNodeName().equals("title")) {
                    node = node2;
                    break;
                }
                ++n6;
            }
            if (node != null) {
                string = node.getNodeValue();
            } else {
                bl2 = true;
                string = "";
            }
            if (bl) {
                element.setAttribute("width", element2.getAttribute("width"));
                element.setAttribute("height", element2.getAttribute("height"));
                if (bl2) {
                    element.appendChild(document.createTextNode("[iframe: (without title)]"));
                    element.setAttribute("style", errorStyle);
                } else {
                    element.appendChild(document.createTextNode("[iframe: title=\"" + string + "\"]"));
                    if (string.matches("^[\\s\u3000]*$")) {
                        element.setAttribute("style", errorStyle);
                    } else {
                        element.setAttribute("style", element2.getAttribute("style"));
                    }
                }
                Node node3 = element2.getParentNode();
                node3.insertBefore(element, element2);
                visualizeMapDataImpl.addReplacedNodeMapping(element2, element);
                node3.removeChild(element2);
            }
            --n4;
        }
        nodeList2 = document.getElementsByTagName("input");
        n3 = nodeList2.getLength();
        Vector<BlindProblem> vector2 = new Vector<BlindProblem>();
        int n7 = n3 - 1;
        while (n7 >= 0) {
            element = (Element)nodeList2.item(n7);
            string = element.getAttribute("type").toLowerCase();
            if (string.equalsIgnoreCase("image")) {
                element.setAttribute("type", "button");
                NamedNodeMap namedNodeMap = element.getAttributes();
                int n8 = namedNodeMap.getLength();
                Node node = null;
                int n9 = 0;
                while (n9 < n8) {
                    Node node4 = namedNodeMap.item(n9);
                    if (node4.getNodeName().equals("alt")) {
                        node = node4;
                        break;
                    }
                    ++n9;
                }
                if (node != null) {
                    element.setAttribute("value", node.getNodeValue());
                } else {
                    BlindProblem blindProblem = new BlindProblem(1);
                    Integer n10 = visualizeMapDataImpl.getIdOfNode(element);
                    if (n10 != null) {
                        blindProblem.setNode(element, n10);
                    } else {
                        blindProblem.setNode(element);
                    }
                    blindProblem.setTargetNode(visualizeMapDataImpl.getOrigNode(element));
                    vector2.add(blindProblem);
                    element.setAttribute("value", element.getAttribute("src"));
                    element.setAttribute("style", errorStyle);
                }
            } else if (string.matches("submit|reset|button")) {
                BlindProblem blindProblem = null;
                object = element.getAttribute("value");
                if (((String)object).length() == 0) {
                    if (string.equals("button")) {
                        blindProblem = new BlindProblem(36);
                    }
                } else {
                    TextCheckResult textCheckResult = this.textChecker.checkAlt((String)object);
                    if (textCheckResult.equals((Object)TextCheckResult.SPACE_SEPARATED) || textCheckResult.equals((Object)TextCheckResult.SPACE_SEPARATED_JP)) {
                        blindProblem = new BlindProblem(37, (String)object);
                    }
                }
                if (blindProblem != null) {
                    Integer n11 = visualizeMapDataImpl.getIdOfNode(element);
                    if (n11 != null) {
                        blindProblem.setNode(element, n11);
                    } else {
                        blindProblem.setNode(element);
                    }
                    blindProblem.setTargetNode(visualizeMapDataImpl.getOrigNode(element));
                    vector2.add(blindProblem);
                }
            }
            --n7;
        }
        n7 = vector2.size() - 1;
        while (n7 > -1) {
            this.problems.add((IProblemItem)vector2.get(n7));
            --n7;
        }
    }

    private void jwatInit() {
        if (this.fIsActivating) {
            return;
        }
        this.fIsActivating = true;
        if (this.jwatc == null) {
            try {
                this.jwatc = VoiceBrowserControllerFactory.createVoiceBrowserController();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Document getResult() {
        return this.result;
    }

    public List<IProblemItem> getProbelems() {
        return this.problems;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setTargetUrl(String string) {
        this.targetUrl = string;
    }

    private void calMaxTime() {
        this.iMaxTime = 0;
        this.iMaxTimeLeaf = 0;
        int n = 0;
        List<VisualizationNodeInfo> list = this.mapData.getNodeInfoList();
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            VisualizationNodeInfo visualizationNodeInfo = list.get(n3);
            int n4 = visualizationNodeInfo.getTime();
            if (n4 > this.iMaxTime) {
                this.iMaxTime = n4;
            }
            if (visualizationNodeInfo.isBlockElement() && !visualizationNodeInfo.isSequence() && n4 > this.iMaxTimeLeaf) {
                this.iMaxTimeLeaf = n4;
            }
            if (n < visualizationNodeInfo.getOrgTime()) {
                n = visualizationNodeInfo.getOrgTime();
            }
            ++n3;
        }
        this.pageData.setMaxTime(this.iMaxTime);
        this.pageData.setOrgMaxTime(n);
    }

    public int getMaxTime() {
        return this.iMaxTime;
    }

    public void setInvisibleIdSet(Set<String> set) {
        this.invisibleIdSet = set;
    }

    public IVisualizeMapData getVisualizeMapData() {
        return this.mapData;
    }

    public void setHtml2viewMapV(Vector<Html2ViewMapData> vector) {
        this.html2viewMapV = vector;
    }

    public void setPageData(PageData pageData) {
        this.pageData = pageData;
    }

    public void setHTML5(boolean bl) {
        this.isHTML5 = bl;
    }

    public File getVariantFile() {
        return this.variantFile;
    }
}

