/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.internal.engines.lowvision.io;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.WritableRaster;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.actf.visualization.engines.lowvision.LowVisionIOException;
import org.eclipse.actf.visualization.internal.engines.lowvision.DosUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.ImageUtil;
import org.eclipse.actf.visualization.internal.engines.lowvision.image.Int2D;

public class BMPWriter {
    private static final int DEFAULT_BITCOUNT = 24;

    public static void writeInt2D(Int2D int2D, String string, int n) throws LowVisionIOException {
        BMPWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(int2D), string, n);
    }

    public static void writeInt2D(Int2D int2D, String string) throws LowVisionIOException {
        BMPWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(int2D), string);
    }

    public static void writeInt2D(Int2D int2D, OutputStream outputStream, int n) throws LowVisionIOException {
        BMPWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(int2D), outputStream, n);
    }

    public static void writeInt2D(Int2D int2D, OutputStream outputStream) throws LowVisionIOException {
        BMPWriter.writeBufferedImage(ImageUtil.int2DToBufferedImage(int2D), outputStream);
    }

    public static void writeBufferedImage(BufferedImage bufferedImage, String string, int n) throws LowVisionIOException {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            throw new LowVisionIOException("The file was not found: " + string);
        }
        BMPWriter.writeBufferedImage(bufferedImage, fileOutputStream, n);
    }

    public static void writeBufferedImage(BufferedImage bufferedImage, String string) throws LowVisionIOException {
        BMPWriter.writeBufferedImage(bufferedImage, string, 24);
    }

    public static void writeBufferedImage(BufferedImage bufferedImage, OutputStream outputStream) throws LowVisionIOException {
        BMPWriter.writeBufferedImage(bufferedImage, outputStream, 24);
    }

    public static void writeBufferedImage(BufferedImage bufferedImage, OutputStream outputStream, int n) throws LowVisionIOException {
        int n2;
        int n3;
        int n4;
        if (n != 16 && n != 24) {
            throw new LowVisionIOException("Invalid bitCount: " + n);
        }
        int n5 = bufferedImage.getWidth();
        int n6 = bufferedImage.getHeight();
        int n7 = 0;
        if (n == 24) {
            n7 = n5 * 3 % 4;
        } else if (n == 16) {
            n7 = n5 * 2 % 4;
        }
        int n8 = 0;
        if (n7 > 0) {
            n8 = 4 - n7;
        }
        int n9 = 0;
        if (n == 24) {
            n9 = (n5 * 3 + n8) * n6;
        } else if (n == 16) {
            n9 = (n5 * 2 + n8) * n6;
        }
        int n10 = n9 + 54;
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        try {
            dataOutputStream.writeByte(66);
            dataOutputStream.writeByte(77);
            dataOutputStream.writeInt(DosUtil.upsideDownInt(n10));
            dataOutputStream.writeInt(0);
            dataOutputStream.writeInt(DosUtil.upsideDownInt(54));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(40));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(n5));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(n6));
            dataOutputStream.writeShort(DosUtil.upsideDownShort((short)1));
            dataOutputStream.writeShort(DosUtil.upsideDownShort((short)n));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(0));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(n9));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(4724));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(4724));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(0));
            dataOutputStream.writeInt(DosUtil.upsideDownInt(0));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when writing header.");
        }
        WritableRaster writableRaster = bufferedImage.copyData(null);
        DataBufferInt dataBufferInt = (DataBufferInt)writableRaster.getDataBuffer();
        int[] nArray = dataBufferInt.getData();
        byte[][] byArray = null;
        int n11 = 0;
        if (n == 24) {
            byArray = new byte[n6][n5 * 3];
            n4 = n6 - 1;
            while (n4 >= 0) {
                n3 = 0;
                while (n3 < n5) {
                    n2 = nArray[n11];
                    byArray[n4][n3 * 3] = (byte)(n2 & 0xFF);
                    byArray[n4][n3 * 3 + 1] = (byte)(n2 >> 8 & 0xFF);
                    byArray[n4][n3 * 3 + 2] = (byte)(n2 >> 16 & 0xFF);
                    ++n11;
                    ++n3;
                }
                --n4;
            }
        } else if (n == 16) {
            byArray = new byte[n6][n5 * 2];
            n4 = n6 - 1;
            while (n4 >= 0) {
                n3 = 0;
                while (n3 < n5) {
                    n2 = nArray[n11];
                    int n12 = n2 >> 19 & 0x1F;
                    int n13 = n2 >> 11 & 0x1F;
                    int n14 = n2 >> 3 & 0x1F;
                    byArray[n4][n3 * 2] = (byte)((n13 & 7) << 5 | n14);
                    byArray[n4][n3 * 2 + 1] = (byte)(n12 << 2 | n13 >> 3 & 3);
                    ++n11;
                    ++n3;
                }
                --n4;
            }
        }
        try {
            n4 = 0;
            while (n4 < n6) {
                dataOutputStream.write(byArray[n4]);
                n3 = 0;
                while (n3 < n8) {
                    dataOutputStream.writeByte(0);
                    ++n3;
                }
                ++n4;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred while writing image data.");
        }
        try {
            dataOutputStream.close();
            outputStream.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw new LowVisionIOException("IO error occurred when closing output streams.");
        }
    }
}

