/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.actf.visualization.gui.preferences;

import org.eclipse.actf.util.win32.OverlayWindow;
import org.eclipse.actf.visualization.gui.internal.GuiPlugin;
import org.eclipse.actf.visualization.gui.ui.actions.WindowListAction;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class GuiPreferenceManager {
    private static IPreferenceStore preferenceStore = GuiPlugin.getDefault().getPreferenceStore();

    public static void init() {
        GuiPreferenceManager.resetOverlayWindow();
        GuiPreferenceManager.resetAlwaysOnTop();
        preferenceStore.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getProperty();
                if ("UseOverlayWindow".equals(string)) {
                    GuiPreferenceManager.resetOverlayWindow();
                } else if ("AlwaysOnTop".equals(string)) {
                    GuiPreferenceManager.resetAlwaysOnTop();
                }
            }
        });
    }

    private static void resetOverlayWindow() {
        OverlayWindow.setVisible((boolean)GuiPreferenceManager.getPreferenceBoolean("UseOverlayWindow"));
    }

    private static void resetAlwaysOnTop() {
        WindowListAction.setWindowOrder(GuiPreferenceManager.getPreferenceBoolean("AlwaysOnTop"));
    }

    public static IPreferenceStore getPreferenceStore() {
        return preferenceStore;
    }

    public static String getPreferenceString(String string) {
        return preferenceStore.getString(string);
    }

    public static boolean getPreferenceBoolean(String string) {
        return preferenceStore.getBoolean(string);
    }

    public static void setPreference(String string, String string2) {
        preferenceStore.setValue(string, string2);
    }

    public static void setPreference(String string, boolean bl) {
        preferenceStore.setValue(string, bl);
    }
}

