/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.model;

import org.eclipse.ant.internal.ui.model.AntElementNode;
import org.eclipse.ant.internal.ui.model.AntProjectNodeProxy;
import org.eclipse.ant.internal.ui.model.AntTargetNode;
import org.eclipse.ant.internal.ui.model.AntTaskNode;
import org.eclipse.ant.internal.ui.model.IAntElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class AntModelLabelProvider
extends StyledCellLabelProvider
implements IColorProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public Image getImage(Object anElement) {
        AntElementNode node = (AntElementNode)anElement;
        return node.getImage();
    }

    public void update(ViewerCell cell) {
        Object obj = cell.getElement();
        StyledString str = this.getStyledText(obj);
        cell.setText(str.toString());
        cell.setStyleRanges(str.getStyleRanges());
        cell.setImage(this.getImage(obj));
    }

    public Color getForeground(Object node) {
        if (node instanceof AntTargetNode && ((AntTargetNode)node).isDefaultTarget()) {
            return Display.getDefault().getSystemColor(9);
        }
        return Display.getDefault().getSystemColor(24);
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof AntTargetNode) {
            AntTargetNode node = (AntTargetNode)element;
            return new StyledString(node.getLabel());
        }
        if (element instanceof AntTaskNode) {
            AntTaskNode node = (AntTaskNode)element;
            return new StyledString(node.getLabel());
        }
        if (element instanceof AntProjectNodeProxy) {
            AntProjectNodeProxy node = (AntProjectNodeProxy)element;
            StyledString buff = new StyledString(node.getLabel());
            IFile buildfile = node.getBuildFileResource();
            if (buildfile != null) {
                buff.append("  ");
                buff.append('[', StyledString.DECORATIONS_STYLER);
                buff.append(buildfile.getFullPath().makeRelative().toString(), StyledString.DECORATIONS_STYLER);
                buff.append(']', StyledString.DECORATIONS_STYLER);
            }
            return buff;
        }
        if (element instanceof IAntElement) {
            return new StyledString(((IAntElement)element).getLabel());
        }
        return null;
    }

    public Color getBackground(Object element) {
        return Display.getDefault().getSystemColor(25);
    }
}

