/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.dialogs;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.dialogs.AbstractParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.BaseDialog;
import org.eclipse.birt.report.designer.ui.dialogs.CheckBoxParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.ComboParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.IParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.ListParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.RadioParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.SelectionParameterControlHelper;
import org.eclipse.birt.report.designer.ui.dialogs.StaticTextParameterControlHelper;
import org.eclipse.birt.report.designer.ui.parameters.AbstractParameterGroup;
import org.eclipse.birt.report.designer.ui.parameters.CheckBoxParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameter;
import org.eclipse.birt.report.designer.ui.parameters.IParameterAdapter;
import org.eclipse.birt.report.designer.ui.parameters.ListingParameter;
import org.eclipse.birt.report.designer.ui.parameters.RadioParameter;
import org.eclipse.birt.report.designer.ui.parameters.ScalarParameter;
import org.eclipse.birt.report.designer.ui.parameters.StaticTextParameter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class InputParameterDialog
extends BaseDialog {
    private Composite contentPane;
    private ScrolledComposite scrollPane;
    private List params;
    private Map<String, Object> paramValues = new HashMap<String, Object>();
    private List<IParameterAdapter> paramAdatpers = new ArrayList<IParameterAdapter>();
    private List<IParameterControlHelper> controlHelpers = new ArrayList<IParameterControlHelper>();
    private Map<IParameter, SelectionParameterControlHelper> postCascadeParamLists = new HashMap<IParameter, SelectionParameterControlHelper>();

    public InputParameterDialog(Shell parentShell, List params, Map paramValues) {
        super(parentShell, Messages.getString((String)"InputParameterDialog.msg.title"));
        this.params = params;
        if (paramValues != null) {
            this.paramValues.putAll(paramValues);
        }
    }

    protected void okPressed() {
        if (!this.validateParameters()) {
            return;
        }
        if (!this.validateAdapters()) {
            return;
        }
        super.okPressed();
    }

    private boolean validateParameters() {
        for (IParameterControlHelper helper : this.controlHelpers) {
            if (helper.validate()) continue;
            return false;
        }
        return true;
    }

    private boolean validateAdapters() {
        for (IParameterAdapter adapter : this.paramAdatpers) {
            try {
                adapter.validate();
            }
            catch (BirtException e) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString((String)"InputParameterDialog.err.invalidValueTitle"), (String)e.getMessage());
                return false;
            }
        }
        return true;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(1808));
        InputParameterDialog.applyDialogFont((Control)composite);
        new Label(composite, 0).setText(Messages.getString((String)"InputParameterDialog.msg.requiredParam"));
        this.scrollPane = new ScrolledComposite(composite, 768);
        this.scrollPane.setExpandHorizontal(true);
        this.scrollPane.setExpandVertical(true);
        GridData gd = new GridData(1808);
        gd.widthHint = 400;
        gd.heightHint = 400;
        this.scrollPane.setLayoutData((Object)gd);
        this.createParameters();
        UIUtil.bindHelp((Control)parent, "org.eclipse.birt.cshelp.InputParametersDialog_ID");
        return composite;
    }

    private void createParameters() {
        if (this.contentPane != null && !this.contentPane.isDisposed()) {
            this.contentPane.dispose();
        }
        this.contentPane = new Composite((Composite)this.scrollPane, 0);
        this.scrollPane.setContent((Control)this.contentPane);
        this.contentPane.setLayoutData((Object)new GridData(1808));
        this.contentPane.setLayout((Layout)new GridLayout());
        this.createParametersSection(this.params, this.contentPane);
        this.scrollPane.setMinSize(this.contentPane.computeSize(400, -1));
    }

    private void createParametersSection(List children, Composite parent) {
        for (Object obj : children) {
            if (obj instanceof ScalarParameter && !((ScalarParameter)obj).getHandle().isHidden()) {
                ScalarParameter param = (ScalarParameter)obj;
                this.createParamSection(param, parent);
                continue;
            }
            if (obj instanceof IParameterAdapter) {
                IParameterAdapter adapterObj = (IParameterAdapter)obj;
                adapterObj.createControl(parent);
                this.paramAdatpers.add(adapterObj);
                continue;
            }
            if (!(obj instanceof AbstractParameterGroup)) continue;
            AbstractParameterGroup group = (AbstractParameterGroup)obj;
            this.createParametersSection(group.getChildren(), this.createParamGroupSection(group, parent));
        }
    }

    private Composite createParamGroupSection(AbstractParameterGroup paramGroup, Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(paramGroup.getHandle().getDisplayLabel());
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout());
        return group;
    }

    private Composite createParamSection(ScalarParameter param, Composite parent) {
        Composite container = this.createParamSectionContainer(parent);
        AbstractParameterControlHelper helper = null;
        if (param instanceof StaticTextParameter) {
            helper = new StaticTextParameterControlHelper(this);
        } else if (param instanceof RadioParameter) {
            helper = new RadioParameterControlHelper(this);
        } else if (param instanceof CheckBoxParameter) {
            helper = new CheckBoxParameterControlHelper(this);
        } else if (param instanceof ListingParameter) {
            ListingParameter listParam = (ListingParameter)param;
            helper = "multi-value".equals(listParam.getHandle().getParamType()) ? new ListParameterControlHelper(this) : new ComboParameterControlHelper(this);
        }
        helper.createControl(container, param, this.paramValues.get(param.getHandle().getName()));
        this.controlHelpers.add(helper);
        return container;
    }

    private Composite createParamSectionContainer(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        return parent;
    }

    public Map getParameters() {
        for (IParameterControlHelper helper : this.controlHelpers) {
            this.paramValues.putAll(helper.getResults());
        }
        for (IParameterAdapter adapter : this.paramAdatpers) {
            this.paramValues.put(adapter.getName(), adapter.getValue());
        }
        return this.paramValues;
    }

    public Map<IParameter, SelectionParameterControlHelper> getPostParamLists() {
        return this.postCascadeParamLists;
    }

    public void addPostParamter(IParameter parameter, SelectionParameterControlHelper helper) {
        this.postCascadeParamLists.put(parameter, helper);
    }
}

