/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.bpel.common.ui.editmodel.EditModel;
import org.eclipse.bpel.model.partnerlinktype.PartnerLinkType;
import org.eclipse.bpel.model.partnerlinktype.PartnerlinktypeFactory;
import org.eclipse.bpel.model.partnerlinktype.Role;
import org.eclipse.bpel.ui.BPELEditor;
import org.eclipse.bpel.ui.BPELUIPlugin;
import org.eclipse.bpel.ui.commands.AddWSDLImportCommand;
import org.eclipse.bpel.ui.commands.CompoundCommand;
import org.eclipse.bpel.ui.commands.CreatePartnerLinkTypeCommand;
import org.eclipse.bpel.ui.wizards.CreatePartnerLinkTypeWizardNamePage;
import org.eclipse.bpel.ui.wizards.CreatePartnerLinkTypeWizardRolePage;
import org.eclipse.bpel.ui.wizards.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.wsdl.Definition;
import org.eclipse.wst.wsdl.PortType;

public class CreatePartnerLinkWizard
extends Wizard {
    CreatePartnerLinkTypeWizardNamePage fFirstPage;
    CreatePartnerLinkTypeWizardRolePage fRolePage1;
    CreatePartnerLinkTypeWizardRolePage fRolePage2;
    PortType fMandatoryPortType;
    PartnerLinkType fPartnerLinkType;
    BPELEditor fEditor;

    public CreatePartnerLinkWizard() {
        this.setNeedsProgressMonitor(true);
        this.setDialogSettings(BPELUIPlugin.INSTANCE.getDialogSettingsFor((Object)this));
        this.setHelpAvailable(false);
        this.setWindowTitle(Messages.CreatePartnerLinkWizard_0);
    }

    public PartnerLinkType getPartnerLinkType() {
        return this.fPartnerLinkType;
    }

    public void setMandatoryPortType(PortType pt) {
        this.fMandatoryPortType = pt;
    }

    public void setBPELEditor(BPELEditor editor) {
        this.fEditor = editor;
    }

    public void addPages() {
        this.fFirstPage = new CreatePartnerLinkTypeWizardNamePage("name.page");
        this.fFirstPage.setTitle(Messages.CreatePartnerLinkWizard_2);
        this.fFirstPage.setDescription(Messages.CreatePartnerLinkWizard_3);
        this.fFirstPage.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("wizban/new_bpel.gif"));
        this.fFirstPage.setDefinitions(this.fEditor.getArtifactsDefinition());
        this.fRolePage1 = new CreatePartnerLinkTypeWizardRolePage("role.1");
        this.fRolePage1.setTitle(Messages.CreatePartnerLinkWizard_5);
        this.fRolePage1.setDescription(Messages.CreatePartnerLinkWizard_6);
        this.fRolePage1.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("wizban/new_bpel.gif"));
        this.fRolePage1.setMandatoryDefinition(this.fMandatoryPortType.getEnclosingDefinition());
        this.fRolePage2 = new CreatePartnerLinkTypeWizardRolePage("role.2");
        this.fRolePage2.setTitle(Messages.CreatePartnerLinkWizard_8);
        this.fRolePage2.setDescription(Messages.CreatePartnerLinkWizard_9);
        this.fRolePage2.setImageDescriptor(BPELUIPlugin.INSTANCE.getImageDescriptor("wizban/new_bpel.gif"));
        IFile file = EditModel.getIFileForURI((URI)this.fMandatoryPortType.eResource().getURI());
        if (file == null) {
            file = ((FileEditorInput)this.fEditor.getEditorInput()).getFile();
        }
        if (file != null) {
            this.fRolePage2.setOptionalDefinitions(this.getOptionalDefinitions(file.getProject()));
        }
        this.fRolePage2.setOptional(true);
        this.fRolePage1.setOtherRolePage(this.fRolePage2);
        this.fRolePage2.setOtherRolePage(this.fRolePage1);
        this.addPage((IWizardPage)this.fFirstPage);
        this.addPage((IWizardPage)this.fRolePage1);
        this.addPage((IWizardPage)this.fRolePage2);
        this.fRolePage1.setPreviousPage((IWizardPage)this.fFirstPage);
        this.fRolePage2.setPreviousPage((IWizardPage)this.fRolePage1);
    }

    private List<Definition> getOptionalDefinitions(IProject project) {
        ArrayList<Definition> wsdlDefinitions = new ArrayList<Definition>();
        final ArrayList wsdlFiles = new ArrayList();
        IResourceVisitor visitor = new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                IFile artifactFile;
                if (resource.getType() == 1 && "wsdl".equalsIgnoreCase(resource.getFileExtension()) && ((artifactFile = EditModel.getIFileForURI((URI)CreatePartnerLinkWizard.this.fEditor.getArtifactsDefinition().eResource().getURI())) == null || !artifactFile.getFullPath().equals((Object)((IFile)resource).getFullPath()))) {
                    wsdlFiles.add((IFile)resource);
                }
                return true;
            }
        };
        try {
            project.accept(visitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        for (IFile iFile : wsdlFiles) {
            IPath fullPath = iFile.getFullPath();
            URI uri = URI.createPlatformResourceURI((String)fullPath.toString(), (boolean)false);
            Resource wsdlResource = this.fEditor.getResource().getResourceSet().getResource(uri, true);
            EcorePackage instance = EcorePackage.eINSTANCE;
            instance.eAdapters();
            try {
                wsdlResource.load(Collections.EMPTY_MAP);
                EList contents = wsdlResource.getContents();
                if (contents.isEmpty()) continue;
                Definition def = (Definition)contents.get(0);
                wsdlDefinitions.add(def);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return wsdlDefinitions;
    }

    PartnerLinkType createPLT() {
        PartnerLinkType plt = PartnerlinktypeFactory.eINSTANCE.createPartnerLinkType();
        plt.setName(this.fFirstPage.getPartnerLinkTypeName());
        Role role1 = PartnerlinktypeFactory.eINSTANCE.createRole();
        role1.setName(this.fRolePage1.getRoleName());
        role1.setPortType((Object)this.fRolePage1.getMandatoryPortType());
        plt.getRole().add((Object)role1);
        if (this.fRolePage2.isSpecified()) {
            Role role2 = PartnerlinktypeFactory.eINSTANCE.createRole();
            role2.setName(this.fRolePage2.getRoleName());
            role2.setPortType((Object)this.fRolePage2.getOptionalPortType());
            plt.getRole().add((Object)role2);
        }
        return plt;
    }

    public boolean performFinish() {
        this.fPartnerLinkType = this.createPLT();
        Definition artifactsDefinition = this.fEditor.getArtifactsDefinition();
        CompoundCommand cmd = new CompoundCommand();
        cmd.add((Command)new AddWSDLImportCommand(artifactsDefinition, this.fMandatoryPortType));
        cmd.add((Command)new CreatePartnerLinkTypeCommand(artifactsDefinition, this.fPartnerLinkType));
        this.fEditor.getCommandFramework().execute((Command)cmd);
        return true;
    }

    public boolean canFinish() {
        return super.canFinish();
    }
}

