/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpel.validator.rules;

import java.util.Map;
import java.util.Set;
import org.eclipse.bpel.validator.model.ARule;
import org.eclipse.bpel.validator.model.Filters;
import org.eclipse.bpel.validator.model.IFilter;
import org.eclipse.bpel.validator.model.INode;
import org.eclipse.bpel.validator.model.IProblem;
import org.eclipse.bpel.validator.model.NodeNameFilter;
import org.eclipse.bpel.validator.rules.CValidator;
import org.eclipse.bpel.validator.rules.FlowValidator;

public class LinkValidator
extends CValidator {
    public static IFilter<INode> PARENTS = new NodeNameFilter(ND_LINKS);
    String ncName;
    protected INode fFlowNode;
    protected Set<String> fSet;
    protected Map<String, INode> fSourceMap;
    protected Map<String, INode> fTargetMap;
    protected INode fSourceNode;
    protected INode fTargetNode;

    @Override
    protected void start() {
        super.start();
        this.ncName = this.mNode.getAttribute(AT_NAME);
        this.fFlowNode = mSelector.selectParent(this.mNode, Filters.FLOW);
    }

    @ARule(sa=0, desc="Check the NCName of the link", author="michal.chmielewski@oracle.com", date="02/15/2007", errors="BPELC__UNSET_ATTRIBUTE,General.NCName_Bad")
    public void rule_CheckName_1() {
        if (!this.checkNCName(this.mNode, this.ncName, AT_NAME)) {
            this.disableRules();
        }
        this.fSet = this.getValue(this.fFlowNode, FlowValidator.LINKS_SET, null);
        if (this.fSet != null) {
            this.fSet.add(this.ncName);
        }
    }

    @ARule(sa=66, desc="Every link must have exactly one activity as source and one as target", author="michal.chmielewski@oracle.com", date="02/17/2007", tag="pass2", order=10, errors="BPELC_LINK__NO_SOURCE,BPELC_LINK__NO_TARGET")
    public void rule_CheckLinkConnections_10() {
        IProblem problem;
        this.fSourceMap = this.getValue(this.fFlowNode, FlowValidator.SOURCE_MAP, null);
        if (this.fSourceMap != null) {
            if (!this.fSourceMap.containsKey(this.ncName)) {
                problem = this.createError();
                problem.fill("BPELC_LINK__NO_SOURCE", this.toString(this.mNode.nodeName()), this.ncName);
            }
            this.fSourceNode = this.fSourceMap.get(this.ncName);
        }
        this.fTargetMap = this.getValue(this.fFlowNode, FlowValidator.TARGET_MAP, null);
        if (this.fTargetMap != null) {
            if (!this.fTargetMap.containsKey(this.ncName)) {
                problem = this.createError();
                problem.fill("BPELC_LINK__NO_TARGET", this.toString(this.mNode.nodeName()), this.ncName);
            }
            this.fTargetNode = this.fTargetMap.get(this.ncName);
        }
    }

    @ARule(sa=67, desc="Two different links MUST NOT share the same source *and* target activities;  that is, at most one link may be used to connect two activities.", author="michal.chmielewski@oracle.com", date="02/17/2007", tag="pass2", order=12, errors="BPELC_LINK__NOT_UNIQUE")
    public void rule_CheckDistinctLinks_12() {
        if (this.fSourceMap == null || this.fTargetMap == null || this.fSourceNode == null || this.fTargetNode == null) {
            return;
        }
        for (String linkName : this.fSet) {
            if (linkName.equals(this.ncName)) continue;
            INode linkTarget = this.fTargetMap.get(linkName);
            INode linkSource = this.fSourceMap.get(linkName);
            if (!this.mModelQuery.check(0, linkTarget, this.fTargetNode) || !this.mModelQuery.check(0, linkSource, this.fSourceNode)) continue;
            IProblem problem = this.createError();
            problem.fill("BPELC_LINK__NOT_UNIQUE", this.toString(this.mNode.nodeName()), this.ncName, linkName);
        }
    }

    @ARule(sa=72, desc="A <link> declared in a <flow> MUST NOT create a control cycle,  that is, the source activity must not  have the target activity as a logically preceding activity.", author="michal.chmielewski@oracle.com", date="02/17/2007", tag="pass2", order=14, errors="BPELC_LINK__CYCLE")
    public void rule_ControlCycle_14() {
        if (this.fSourceNode == null || this.fTargetNode == null) {
            return;
        }
        INode linkTarget = null;
        INode linkSource = null;
        if (this.mModelQuery.check(0, linkTarget, this.fTargetNode) && this.mModelQuery.check(0, linkSource, this.fSourceNode)) {
            IProblem problem = this.createError();
            problem.fill("BPELC_LINK__CYCLE", this.toString(this.mNode.nodeName()), this.ncName, this.fSourceNode.nodeName(), this.fTargetNode.nodeName());
        }
    }
}

