/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.runtime;

import java.lang.reflect.Constructor;
import org.eclipse.bpmn2.modeler.core.DefaultConversionDelegate;
import org.eclipse.bpmn2.modeler.core.EDataTypeConversionFactory;
import org.eclipse.bpmn2.modeler.core.runtime.BaseRuntimeExtensionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntimeConfigurationException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EDataType;

public class DataTypeDescriptor
extends BaseRuntimeExtensionDescriptor {
    public static final String EXTENSION_NAME = "dataType";
    protected String name;
    protected String delegateClassName;

    public DataTypeDescriptor(IConfigurationElement e) {
        super(e);
        this.name = e.getAttribute("name");
        this.delegateClassName = e.getAttribute("class");
    }

    @Override
    public void dispose() {
        super.dispose();
        EDataTypeConversionFactory.unregisterConversionDelegate(this.name);
    }

    @Override
    public void setRuntime(TargetRuntime targetRuntime) {
        try {
            super.setRuntime(targetRuntime);
            EDataType.Internal.ConversionDelegate delegate = this.getConversionDelegate();
            EDataTypeConversionFactory.registerConversionDelegate(this.name, delegate.getClass());
        }
        catch (Exception e) {
            throw new TargetRuntimeConfigurationException(targetRuntime, e);
        }
    }

    @Override
    public String getExtensionName() {
        return EXTENSION_NAME;
    }

    public String getDataTypeName() {
        return this.name;
    }

    public EDataType.Internal.ConversionDelegate getConversionDelegate() throws TargetRuntimeConfigurationException {
        try {
            ClassLoader cl = this.getRuntime().getRuntimeExtension().getClass().getClassLoader();
            Constructor<?> ctor = null;
            Class<?> adapterClass = Class.forName(this.delegateClassName, true, cl);
            ctor = adapterClass.getConstructor(new Class[0]);
            return (EDataType.Internal.ConversionDelegate)ctor.newInstance(new Object[0]);
        }
        catch (Exception exception) {
            try {
                Object object = this.configurationElement.createExecutableExtension("class");
                return (DefaultConversionDelegate)object;
            }
            catch (Exception ex2) {
                throw new TargetRuntimeConfigurationException(this.targetRuntime, ex2);
            }
        }
    }
}

