/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.ui.property;

import org.eclipse.bpmn2.modeler.core.DefaultConversionDelegate;
import org.eclipse.bpmn2.modeler.core.EditControlProvider;
import org.eclipse.jface.preference.ColorSelector;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EColorConversionDelegate
extends DefaultConversionDelegate {
    public String convertToString(Object value) {
        if (value instanceof RGB) {
            RGB c = (RGB)value;
            return "#" + this.toHex(c.red) + this.toHex(c.green) + this.toHex(c.blue);
        }
        if (value == null) {
            return "";
        }
        return value.toString();
    }

    public Object createFromString(String literal) {
        if (literal.startsWith("#")) {
            literal = literal.substring(1);
        }
        if (literal.length() == 6) {
            RGB c = new RGB(this.fromHex(literal, RGBComponent.RED), this.fromHex(literal, RGBComponent.GREEN), this.fromHex(literal, RGBComponent.BLUE));
            return c;
        }
        return new RGB(0, 0, 0);
    }

    public EditControlProvider.EditControl createControl(Composite parent, int style) {
        return new ColorControl(parent, style);
    }

    private String toHex(int i) {
        String s = Integer.toHexString(i);
        int l = s.length();
        if (l == 1) {
            s = "0" + s;
        } else if (l > 2) {
            s = s.substring(l - 2, l - 1);
        }
        return s;
    }

    private int fromHex(String s, RGBComponent cc) {
        switch (cc) {
            case RED: {
                s = s.substring(0, 2);
                break;
            }
            case GREEN: {
                s = s.substring(2, 4);
                break;
            }
            case BLUE: {
                s = s.substring(4, 6);
            }
        }
        return Integer.parseInt(s, 16);
    }

    public class ColorControl
    extends EditControlProvider.EditControl {
        private ColorSelector colorSelector;

        public ColorControl(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)new RowLayout());
            this.colorSelector = new ColorSelector((Composite)this);
            this.colorSelector.getButton().addSelectionListener((SelectionListener)this);
        }

        public Object getValue() {
            return this.colorSelector.getColorValue();
        }

        public boolean setValue(Object value) {
            if (value instanceof RGB) {
                this.colorSelector.setColorValue((RGB)value);
                return true;
            }
            return false;
        }
    }

    private static enum RGBComponent {
        RED,
        GREEN,
        BLUE;

    }
}

