/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.scanner;

import java.util.ArrayList;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.parser.util.CharArrayMap;
import org.eclipse.cdt.core.parser.util.CharArrayUtils;
import org.eclipse.cdt.internal.core.parser.scanner.CPreprocessor;
import org.eclipse.cdt.internal.core.parser.scanner.LocationMap;
import org.eclipse.cdt.internal.core.parser.scanner.PreprocessorMacro;
import org.eclipse.cdt.internal.core.parser.scanner.Token;
import org.eclipse.cdt.internal.core.parser.scanner.TokenList;
import org.eclipse.cdt.internal.core.parser.scanner.UndefinedMacro;

public class ExpressionEvaluator {
    private Token fTokens;
    private CharArrayMap<PreprocessorMacro> fDictionary;
    private ArrayList<IASTName> fMacrosInDefinedExpressions = new ArrayList();
    private LocationMap fLocationMap;
    private CPreprocessor fPreprocessor;

    ExpressionEvaluator(CPreprocessor preprocessor) {
        this.fPreprocessor = preprocessor;
    }

    public boolean evaluate(TokenList condition, CharArrayMap<PreprocessorMacro> macroDictionary, LocationMap map) throws EvalException {
        this.fTokens = condition.first();
        this.fDictionary = macroDictionary;
        this.fLocationMap = map;
        this.fMacrosInDefinedExpressions.clear();
        return this.expression() != 0L;
    }

    public IASTName[] clearMacrosInDefinedExpression() {
        IASTName[] result = this.fMacrosInDefinedExpressions.toArray(new IASTName[this.fMacrosInDefinedExpressions.size()]);
        this.fMacrosInDefinedExpressions.clear();
        return result;
    }

    private long expression() throws EvalException {
        return this.conditionalExpression();
    }

    private long conditionalExpression() throws EvalException {
        long r1 = this.logicalOrExpression();
        if (this.LA() == 7) {
            this.consume();
            long r2 = this.expression();
            if (this.LA() != 4) {
                throw new EvalException(0x100000E, null);
            }
            this.consume();
            long r3 = this.conditionalExpression();
            return r1 != 0L ? r2 : r3;
        }
        return r1;
    }

    private long logicalOrExpression() throws EvalException {
        long r1 = this.logicalAndExpression();
        while (this.LA() == 32) {
            this.consume();
            long r2 = this.logicalAndExpression();
            r1 = r1 != 0L || r2 != 0L ? 1 : 0;
        }
        return r1;
    }

    private long logicalAndExpression() throws EvalException {
        long r1 = this.inclusiveOrExpression();
        while (this.LA() == 29) {
            this.consume();
            long r2 = this.inclusiveOrExpression();
            r1 = r1 != 0L && r2 != 0L ? 1 : 0;
        }
        return r1;
    }

    private long inclusiveOrExpression() throws EvalException {
        long r1 = this.exclusiveOrExpression();
        while (this.LA() == 33) {
            this.consume();
            long r2 = this.exclusiveOrExpression();
            r1 |= r2;
        }
        return r1;
    }

    private long exclusiveOrExpression() throws EvalException {
        long r1 = this.andExpression();
        while (this.LA() == 27) {
            this.consume();
            long r2 = this.andExpression();
            r1 ^= r2;
        }
        return r1;
    }

    private long andExpression() throws EvalException {
        long r1 = this.equalityExpression();
        while (this.LA() == 30) {
            this.consume();
            long r2 = this.equalityExpression();
            r1 &= r2;
        }
        return r1;
    }

    private long equalityExpression() throws EvalException {
        long r1 = this.relationalExpression();
        int t = this.LA();
        while (t == 37 || t == 35) {
            this.consume();
            long r2 = this.relationalExpression();
            r1 = t == 37 ? (long)(r1 == r2 ? 1 : 0) : (long)(r1 != r2 ? 1 : 0);
            t = this.LA();
        }
        return r1;
    }

    private long relationalExpression() throws EvalException {
        long r1 = this.shiftExpression();
        int t = this.LA();
        while (t == 42 || t == 41 || t == 46 || t == 45 || t == 38) {
            this.consume();
            long r2 = this.shiftExpression();
            switch (t) {
                case 42: {
                    r1 = r1 < r2 ? 1 : 0;
                    break;
                }
                case 41: {
                    r1 = r1 <= r2 ? 1 : 0;
                    break;
                }
                case 46: {
                    r1 = r1 > r2 ? 1 : 0;
                    break;
                }
                case 45: {
                    r1 = r1 >= r2 ? 1 : 0;
                    break;
                }
                case 38: {
                    throw new EvalException(0x1000009, null);
                }
            }
            t = this.LA();
        }
        return r1;
    }

    private long shiftExpression() throws EvalException {
        long r1 = this.additiveExpression();
        int t = this.LA();
        while (t == 40 || t == 44) {
            this.consume();
            long r2 = this.additiveExpression();
            r1 = t == 40 ? (r1 <<= (int)r2) : (r1 >>= (int)r2);
            t = this.LA();
        }
        return r1;
    }

    private long additiveExpression() throws EvalException {
        long r1 = this.multiplicativeExpression();
        int t = this.LA();
        while (t == 16 || t == 21) {
            this.consume();
            long r2 = this.multiplicativeExpression();
            r1 = t == 16 ? (r1 += r2) : (r1 -= r2);
            t = this.LA();
        }
        return r1;
    }

    private long multiplicativeExpression() throws EvalException {
        long r1 = this.unaryExpression();
        int t = this.LA();
        while (t == 23 || t == 52 || t == 25) {
            this.consume();
            long r2 = this.unaryExpression();
            if (t == 23) {
                r1 *= r2;
            } else if (r2 != 0L) {
                r1 = t == 52 ? (r1 /= r2) : (r1 %= r2);
            } else {
                throw new EvalException(0x100000A, null);
            }
            t = this.LA();
        }
        return r1;
    }

    private long unaryExpression() throws EvalException {
        char c;
        switch (this.LA()) {
            case 16: {
                this.consume();
                return this.unaryExpression();
            }
            case 21: {
                this.consume();
                return -this.unaryExpression();
            }
            case 36: {
                this.consume();
                return this.unaryExpression() == 0L ? 1 : 0;
            }
            case 34: {
                this.consume();
                return this.unaryExpression() ^ 0xFFFFFFFFFFFFFFFFL;
            }
            case 2: 
            case 132: 
            case 133: 
            case 5002: 
            case 5003: {
                long val = this.getValue(this.fTokens);
                this.consume();
                return val;
            }
            case 114: {
                this.consume();
                return 1L;
            }
            case 81: {
                this.consume();
                return 0L;
            }
            case -200: {
                return this.handleDefined();
            }
            case -194: {
                return this.handleHasFeature();
            }
            case 8: {
                this.consume();
                long r1 = this.expression();
                if (this.LA() == 9) {
                    this.consume();
                    return r1;
                }
                throw new EvalException(0x100000B, null);
            }
            case 1: {
                this.consume();
                return 0L;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 130: 
            case 131: 
            case 5000: 
            case 5001: {
                throw new EvalException(0x100000C, null);
            }
        }
        char[] image = this.fTokens.getCharImage();
        if (image.length > 0 && ((c = image[0]) >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$' || c == '@')) {
            return 0L;
        }
        throw new EvalException(0x100000C, null);
    }

    private long handleDefined() throws EvalException {
        int result;
        boolean parenthesis = false;
        this.consume();
        if (this.LA() == 8) {
            parenthesis = true;
            this.consume();
        }
        if (this.LA() != 1) {
            throw new EvalException(0x100000D, null);
        }
        char[] macroName = this.fTokens.getCharImage();
        PreprocessorMacro macro = this.fDictionary.get(macroName);
        int n = result = macro != null ? 1 : 0;
        if (macro == null) {
            macro = new UndefinedMacro(macroName);
        }
        this.fMacrosInDefinedExpressions.add(this.fLocationMap.encounterDefinedExpression(macro, this.fTokens.getOffset(), this.fTokens.getEndOffset()));
        this.consume();
        if (parenthesis) {
            if (this.LA() != 9) {
                throw new EvalException(0x100000B, null);
            }
            this.consume();
        }
        return result;
    }

    private long handleHasFeature() throws EvalException {
        this.consume();
        if (this.LA() != 8) {
            throw new EvalException(0x100000C, null);
        }
        this.consume();
        if (this.LA() != 1) {
            throw new EvalException(0x100000C, null);
        }
        char[] featureName = this.fTokens.getCharImage();
        boolean supported = this.fPreprocessor.getSupportedFeatures().contains(new String(featureName));
        this.consume();
        if (this.LA() != 9) {
            throw new EvalException(0x100000B, null);
        }
        this.consume();
        return supported ? 1 : 0;
    }

    private int LA() {
        return this.fTokens.getType();
    }

    private void consume() {
        this.fTokens = (Token)this.fTokens.getNext();
        if (this.fTokens == null) {
            this.fTokens = new Token(144, null, 0, 0);
        }
    }

    long getValue(Token t) throws EvalException {
        switch (t.getType()) {
            case 132: {
                return ExpressionEvaluator.getChar(t.getCharImage(), 1);
            }
            case 133: 
            case 5002: 
            case 5003: {
                return ExpressionEvaluator.getChar(t.getCharImage(), 2);
            }
            case 2: {
                return ExpressionEvaluator.getNumber(t.getCharImage());
            }
        }
        assert (false);
        return 1L;
    }

    public static long getNumber(char[] image) throws EvalException {
        if (image.length > 1 && image[0] == '0') {
            switch (image[1]) {
                case 'B': 
                case 'b': {
                    return ExpressionEvaluator.getNumber(image, 2, image.length, 2, 0x100000F);
                }
                case 'X': 
                case 'x': {
                    return ExpressionEvaluator.getNumber(image, 2, image.length, 16, 0x1000005);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return ExpressionEvaluator.getNumber(image, 1, image.length, 8, 0x1000007);
                }
            }
        }
        return ExpressionEvaluator.getNumber(image, 0, image.length, 10, 0x1000008);
    }

    public static long getChar(char[] tokenImage, int i) throws EvalException {
        if (i >= tokenImage.length) {
            throw new EvalException(0x1000001, tokenImage);
        }
        char c = tokenImage[i];
        if (c != '\\') {
            return c;
        }
        if (++i >= tokenImage.length) {
            throw new EvalException(0x1000001, tokenImage);
        }
        char d = tokenImage[i];
        switch (d) {
            case '\"': 
            case '\'': 
            case '\\': {
                return d;
            }
            case 'a': {
                return 7L;
            }
            case 'b': {
                return 8L;
            }
            case 'f': {
                return 12L;
            }
            case 'n': {
                return 10L;
            }
            case 'r': {
                return 13L;
            }
            case 't': {
                return 9L;
            }
            case 'v': {
                return 11L;
            }
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': {
                return ExpressionEvaluator.getNumber(tokenImage, i, tokenImage.length - 1, 8, 0x1000007);
            }
            case 'U': 
            case 'u': 
            case 'x': {
                return ExpressionEvaluator.getNumber(tokenImage, i + 1, tokenImage.length - 1, 16, 0x1000005);
            }
        }
        throw new EvalException(0x1000001, tokenImage);
    }

    private static long getNumber(char[] tokenImage, int from, int to, int base, int problemID) throws EvalException {
        char c;
        long result = 0L;
        int i = from;
        if (from != to) {
            while (i < to) {
                int digit = ExpressionEvaluator.getDigit(tokenImage[i]);
                if (digit >= base) break;
                result = result * (long)base + (long)digit;
                ++i;
            }
            if (i >= to) {
                return result;
            }
            c = tokenImage[i];
            if ('0' <= c && c <= '9') {
                throw new EvalException(problemID, tokenImage);
            }
            if (i == 2 && base != 10) {
                --i;
            }
        } else {
            i = 1;
        }
        int suffixStart = i;
        while (i < to) {
            switch (tokenImage[i]) {
                case 'L': 
                case 'U': 
                case 'l': 
                case 'u': {
                    break;
                }
                default: {
                    c = tokenImage[i];
                    if (Character.isLetterOrDigit(c) || c == '_') {
                        char[] suffix = CharArrayUtils.subarray(tokenImage, suffixStart, -1);
                        throw new EvalException(0x1000010, suffix);
                    }
                    throw new EvalException(problemID, tokenImage);
                }
            }
            ++i;
        }
        return result;
    }

    private static int getDigit(char c) {
        switch (c) {
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return c - 48;
            }
            case 'a': 
            case 'b': 
            case 'c': 
            case 'd': 
            case 'e': 
            case 'f': {
                return c - 97 + 10;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'D': 
            case 'E': 
            case 'F': {
                return c - 65 + 10;
            }
        }
        return Integer.MAX_VALUE;
    }

    public static class EvalException
    extends Exception {
        private int fProblemID;
        private char[] fProblemArg;

        private EvalException(int problemID, char[] problemArg) {
            this.fProblemID = problemID;
            this.fProblemArg = problemArg;
        }

        public int getProblemID() {
            return this.fProblemID;
        }

        public char[] getProblemArg() {
            return this.fProblemArg;
        }
    }
}

