/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.core.sourcelookup;

import org.eclipse.cdt.debug.internal.core.sourcelookup.CompilationDirectorySourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.InternalSourceLookupMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.AbstractSourceContainerTypeDelegate;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CompilationDirectorySourceContainerType
extends AbstractSourceContainerTypeDelegate {
    public String getMemento(ISourceContainer container) throws CoreException {
        CompilationDirectorySourceContainer folder = (CompilationDirectorySourceContainer)container;
        Document document = this.newDocument();
        Element element = document.createElement("directory");
        element.setAttribute("path", folder.getDirectory().getAbsolutePath());
        String nest = "false";
        if (folder.isComposite()) {
            nest = "true";
        }
        element.setAttribute("nest", nest);
        document.appendChild(element);
        return this.serializeDocument(document);
    }

    public ISourceContainer createSourceContainer(String memento) throws CoreException {
        Element node = this.parseDocument(memento);
        if (node.getNodeType() == 1) {
            Element element = node;
            if ("directory".equals(element.getNodeName())) {
                String path = element.getAttribute("path");
                if (path == null || path.isEmpty()) {
                    this.abort(InternalSourceLookupMessages.CompilationDirectorySourceContainerType_0, null);
                }
                String nest = element.getAttribute("nest");
                boolean nested = Boolean.parseBoolean(nest);
                return new CompilationDirectorySourceContainer((IPath)new Path(path), nested);
            }
            this.abort(InternalSourceLookupMessages.CompilationDirectorySourceContainerType_1, null);
        }
        this.abort(InternalSourceLookupMessages.CompilationDirectorySourceContainerType_2, null);
        return null;
    }
}

