/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.enablement.ibm.db2.luw.catalog;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.datatools.enablement.ibm.db2.luw.catalog.RemoteCatalogProvider;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.impl.RelationalRemoteServerImpl;
import org.eclipse.datatools.enablement.ibm.db2.luw.model.util.DatabaseToRemoteServerHelper;
import org.eclipse.datatools.modelbase.sql.schema.Database;

public class LUWCatalogRelationalRemoteServer
extends RelationalRemoteServerImpl {
    private static RemoteCatalogProvider remoteCatalogProvider = null;
    private static boolean remoteCatalogProviderLoaded = false;
    private boolean remoteServerLoaded = false;
    private boolean databaseLoaded = false;

    public LUWCatalogRelationalRemoteServer() {
        this.eAdapters().add((Object)DatabaseToRemoteServerHelper.INVERSE_DATABASE_ADAPTER);
        DatabaseToRemoteServerHelper.INVERSE_DATABASE_ADAPTER.setTarget(null);
    }

    public static RemoteCatalogProvider getRemoteCatalogProvider() {
        if (!remoteCatalogProviderLoaded) {
            remoteCatalogProviderLoaded = true;
            IExtensionRegistry pluginRegistry = Platform.getExtensionRegistry();
            IExtensionPoint extensionPoint = pluginRegistry.getExtensionPoint("com.ibm.datatools.db2.luw", "remoteCatalog");
            IExtension[] extensions = extensionPoint.getExtensions();
            if (extensions.length == 1) {
                IConfigurationElement[] configElements = extensions[0].getConfigurationElements();
                try {
                    remoteCatalogProvider = (RemoteCatalogProvider)configElements[0].createExecutableExtension("class");
                }
                catch (Exception exception) {}
            }
        }
        return remoteCatalogProvider;
    }

    @Override
    public Database getDatabase() {
        if (!this.databaseLoaded) {
            this.loadDatabase();
        }
        return this.database;
    }

    private synchronized void loadDatabase() {
        if (this.databaseLoaded) {
            return;
        }
        RemoteCatalogProvider p = LUWCatalogRelationalRemoteServer.getRemoteCatalogProvider();
        if (p != null) {
            this.database = p.getDatabase(this);
        }
        this.databaseLoaded = true;
    }
}

