/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.sqlbuilder;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderEditor;
import org.eclipse.datatools.sqltools.sqlbuilder.SQLBuilderPlugin;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class StatementResourceChangeListener
implements IResourceChangeListener,
IResourceDeltaVisitor {
    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta resourceDelta = event.getDelta();
        try {
            if (resourceDelta != null) {
                resourceDelta.accept((IResourceDeltaVisitor)this);
            }
        }
        catch (Exception e) {
            SQLBuilderPlugin.getPlugin().getLogger().writeLog("Exception caught: " + e);
        }
    }

    public boolean visit(IResourceDelta delta) {
        if (delta.getKind() == 2) {
            IResource resource = delta.getResource();
            if (resource instanceof IFile && resource.getFileExtension().equalsIgnoreCase("sqx")) {
                this.cleanupStatementResource((IFile)resource);
            }
        } else {
            delta.getKind();
        }
        return true;
    }

    private void cleanupStatementResource(IFile statementResource) {
        this.closeEditors((IResource)statementResource);
    }

    private void closeEditors(IResource deletedResource) {
        IWorkbenchWindow[] windows = SQLBuilderPlugin.getPlugin().getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            IWorkbenchPage[] pages = windows[i].getPages();
            int j = 0;
            while (j < pages.length) {
                IEditorReference[] editorRefArray = pages[j].getEditorReferences();
                int k = 0;
                while (k < editorRefArray.length) {
                    IEditorReference editorRef = editorRefArray[k];
                    IEditorPart editor = editorRef.getEditor(false);
                    IEditorInput editorInput = editor.getEditorInput();
                    if (editorInput instanceof IFileEditorInput && ((IFileEditorInput)editorInput).getFile().equals((Object)deletedResource) && editor instanceof SQLBuilderEditor) {
                        ((SQLBuilderEditor)editor).setResourceRemoved(true);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

