/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.remoteservice.provider;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ecf.core.ContainerCreateException;
import org.eclipse.ecf.core.ContainerTypeDescription;
import org.eclipse.ecf.core.IContainer;
import org.eclipse.ecf.core.provider.BaseContainerInstantiator;
import org.eclipse.ecf.core.provider.IRemoteServiceContainerInstantiator;
import org.eclipse.ecf.remoteservice.IRemoteServiceContainerAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RemoteServiceContainerInstantiator
extends BaseContainerInstantiator
implements IRemoteServiceContainerInstantiator {
    protected static final String[] defaultSupportedAdapterTypes = new String[]{IContainer.class.getName(), IRemoteServiceContainerAdapter.class.getName()};
    protected static final Class[][] defaultSupportedParameterTypes = new Class[][]{{Map.class}};
    protected static final String[] defaultSupportedIntents = new String[]{"passByValue", "exactlyOnce", "ordered"};
    protected List<String> exporterConfigs = new ArrayList<String>();
    protected Map<String, List<String>> exporterConfigToImporterConfigs = new HashMap<String, List<String>>();

    public String[] getSupportedAdapterTypes(ContainerTypeDescription description) {
        return defaultSupportedAdapterTypes;
    }

    public Class[][] getSupportedParameterTypes(ContainerTypeDescription description) {
        return defaultSupportedParameterTypes;
    }

    public String[] getSupportedIntents(ContainerTypeDescription description) {
        return defaultSupportedIntents;
    }

    protected RemoteServiceContainerInstantiator(String exportingProvider, String importingProvider) {
        this();
        this.exporterConfigs.add(exportingProvider);
        this.exporterConfigToImporterConfigs.put(exportingProvider, Arrays.asList(importingProvider));
    }

    protected RemoteServiceContainerInstantiator(List<String> exporterConfigs, Map<String, List<String>> exporterConfigToImporterConfig) {
        this();
        this.exporterConfigs.addAll(exporterConfigs);
        this.exporterConfigToImporterConfigs.putAll(exporterConfigToImporterConfig);
    }

    protected RemoteServiceContainerInstantiator() {
    }

    public String[] getSupportedConfigs(ContainerTypeDescription description) {
        ArrayList<String> results = new ArrayList<String>();
        String descriptionName = description.getName();
        if (this.exporterConfigs.contains(descriptionName)) {
            results.add(descriptionName);
        }
        return results.toArray(new String[results.size()]);
    }

    public String[] getImportedConfigs(ContainerTypeDescription description, String[] exporterSupportedConfigs) {
        if (exporterSupportedConfigs == null) {
            return null;
        }
        ArrayList<String> results = new ArrayList<String>();
        String[] stringArray = exporterSupportedConfigs;
        int n = exporterSupportedConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            String exporterConfig = stringArray[n2];
            List<String> importerConfigs = this.exporterConfigToImporterConfigs.get(exporterConfig);
            if (importerConfigs != null) {
                for (String importerConfig : importerConfigs) {
                    if (!description.getName().equals(importerConfig)) continue;
                    results.add(importerConfig);
                }
            }
            ++n2;
        }
        return results.toArray(new String[results.size()]);
    }

    public Dictionary getPropertiesForImportedConfigs(ContainerTypeDescription description, String[] importedConfigs, Dictionary exportedProperties) {
        return null;
    }

    public abstract IContainer createInstance(ContainerTypeDescription var1, Map<String, ?> var2) throws ContainerCreateException;

    public IContainer createInstance(ContainerTypeDescription description, Object[] parameters) throws ContainerCreateException {
        return this.createInstance(description, this.getMap(parameters));
    }

    protected IContainer throwCreateException(String message, Throwable cause) throws ContainerCreateException {
        ContainerCreateException cce = new ContainerCreateException(message, cause);
        cce.setStackTrace(cause.getStackTrace());
        throw cce;
    }
}

