/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ecf.internal.storage;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.ecf.core.identity.ID;
import org.eclipse.ecf.internal.storage.Activator;
import org.eclipse.ecf.internal.storage.ContainerEntry;
import org.eclipse.ecf.internal.storage.IDStore;
import org.eclipse.ecf.storage.IContainerEntry;
import org.eclipse.ecf.storage.IContainerStore;
import org.eclipse.ecf.storage.IIDEntry;
import org.eclipse.ecf.storage.INamespaceEntry;
import org.eclipse.ecf.storage.IStorableContainerAdapter;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.StorageException;

public class ContainerStore
implements IContainerStore {
    static final String CONTAINER_NODE_NAME = "container";
    final IDStore idStore;

    public ContainerStore(IDStore idStore) {
        this.idStore = idStore;
    }

    public IContainerEntry[] getContainerEntries() {
        INamespaceEntry[] namespaceEntries = this.idStore.getNamespaceEntries();
        ArrayList<ContainerEntry> results = new ArrayList<ContainerEntry>();
        int i = 0;
        while (i < namespaceEntries.length) {
            IIDEntry[] idEntries = namespaceEntries[i].getIDEntries();
            int j = 0;
            while (j < idEntries.length) {
                ISecurePreferences pref = idEntries[j].getPreferences();
                String[] names = pref.childrenNames();
                int k = 0;
                while (k < names.length) {
                    if (names[k].equals(CONTAINER_NODE_NAME)) {
                        results.add(new ContainerEntry(idEntries[j]));
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return results.toArray(new IContainerEntry[0]);
    }

    public IContainerEntry store(IStorableContainerAdapter containerAdapter) throws StorageException {
        String factoryName = containerAdapter.getContainerFactoryName();
        Assert.isNotNull((Object)factoryName);
        ID containerID = containerAdapter.getID();
        Assert.isNotNull((Object)containerID);
        IIDEntry idEntry = this.idStore.store(containerID);
        ContainerEntry containerEntry = new ContainerEntry(idEntry);
        try {
            containerEntry.setFactoryName(containerAdapter.getContainerFactoryName(), containerAdapter.storeEncrypted());
            containerAdapter.store(containerEntry.getPreferences());
            return containerEntry;
        }
        catch (StorageException e) {
            containerEntry.delete();
            throw e;
        }
    }

    public IContainerEntry retrieve(ID containerID) {
        IIDEntry entry = this.idStore.store(containerID);
        return this.retrieve(entry);
    }

    public IContainerEntry retrieve(IIDEntry idEntry) {
        Assert.isNotNull((Object)idEntry);
        ISecurePreferences pref = idEntry.getPreferences();
        String[] names = pref.childrenNames();
        ContainerEntry result = null;
        int k = 0;
        while (k < names.length) {
            if (names[k].equals(CONTAINER_NODE_NAME)) {
                result = new ContainerEntry(idEntry);
            }
            ++k;
        }
        return result;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == null) {
            return null;
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        IAdapterManager adapterManager = Activator.getDefault().getAdapterManager();
        return adapterManager == null ? null : adapterManager.loadAdapter((Object)this, adapter.getName());
    }
}

