/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.compare;

import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.model.RevisionInfo;
import org.eclipse.egerrit.internal.ui.compare.CommitCompareItem;
import org.eclipse.egerrit.internal.ui.compare.CommitMsgCompareItem;
import org.eclipse.egerrit.internal.ui.compare.PatchSetCompareItem;

class CompareItemFactory {
    private static final String COMMIT_MSG = "/COMMIT_MSG";
    private GerritClient gerrit;
    private PatchSetCompareItem newCompareItem = new PatchSetCompareItem();

    CompareItemFactory(GerritClient gerrit) {
        this.gerrit = gerrit;
    }

    PatchSetCompareItem createCompareItemFromRevision(FileInfo fileInfo) {
        if (fileInfo == null || fileInfo.getRevision() == null) {
            throw new IllegalArgumentException();
        }
        if (COMMIT_MSG.equals(fileInfo.getPath())) {
            this.newCompareItem = new CommitMsgCompareItem();
        }
        this.newCompareItem.setGerritConnection(this.gerrit);
        this.newCompareItem.setFile(fileInfo);
        return this.newCompareItem;
    }

    CommitCompareItem createCompareItemFromCommit(RevisionInfo revision, FileInfo file, String fileName, int baseRevisionNumber) {
        return new CommitCompareItem(this.gerrit, revision, file, fileName, baseRevisionNumber);
    }

    CommitCompareItem createCompareItemFromBase(RevisionInfo revision, FileInfo file, String fileName) {
        return new CommitCompareItem(this.gerrit, revision, file, fileName, 0);
    }
}

