/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.editors;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.FileInfo;
import org.eclipse.egerrit.internal.ui.compare.GerritMultipleInput;
import org.eclipse.egerrit.internal.ui.utils.GerritToGitMapping;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.URIish;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenCompareEditor {
    private static final Logger logger = LoggerFactory.getLogger(OpenCompareEditor.class);
    private static final boolean SUPPORT_SWAP = Platform.getBundle((String)"org.eclipse.compare").getVersion().compareTo(new Version("3.7.0")) > 0;
    private final GerritClient gerrit;
    private final ChangeInfo changeInfo;

    public OpenCompareEditor(GerritClient gerrit, ChangeInfo changeInfo) {
        this.gerrit = gerrit;
        this.changeInfo = changeInfo;
    }

    public void compareFiles(String leftSide, String rightSide, FileInfo fileToReveal) {
        if (!SUPPORT_SWAP) {
            CompareUI.openCompareEditor((CompareEditorInput)new GerritMultipleInput(leftSide, rightSide, this.changeInfo, this.gerrit, fileToReveal));
            return;
        }
        CompareUI.openCompareEditor((CompareEditorInput)new GerritMultipleInput(rightSide, leftSide, this.changeInfo, this.gerrit, fileToReveal));
    }

    public IFile getCorrespondingWorkspaceFile(FileInfo reviewFile) {
        File potentialFile = this.locateFileInLocalGitRepo(reviewFile);
        IFile workspaceFile = null;
        if (potentialFile == null) {
            logger.debug("The corresponding file could not be found in any git repository known by the workspace.");
        }
        if (potentialFile != null && (workspaceFile = this.getFileFromWorkspace(potentialFile)) == null) {
            logger.debug("The compare editor could not be opened because the corresponding file is not in the workspace.");
        }
        return workspaceFile;
    }

    private IFile getFileFromWorkspace(File potentialFile) {
        return ResourcesPlugin.getWorkspace().getRoot().getFileForLocation(Path.fromOSString((String)potentialFile.getAbsolutePath()));
    }

    private File locateFileInLocalGitRepo(FileInfo fileInfo) {
        Repository repo;
        try {
            repo = new GerritToGitMapping(new URIish(this.gerrit.getRepository().getURIBuilder(false).toString()), this.changeInfo.getProject()).find();
            if (repo == null) {
                return null;
            }
        }
        catch (IOException | URISyntaxException e) {
            return null;
        }
        File workTree = repo.getWorkTree();
        if (workTree == null) {
            return null;
        }
        File potentialFile = new File(workTree, fileInfo.getPath());
        if (potentialFile.exists()) {
            return potentialFile;
        }
        if (fileInfo.getOld_path() != null && (potentialFile = new File(workTree, fileInfo.getOld_path())).exists()) {
            return potentialFile;
        }
        return null;
    }
}

