/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egerrit.internal.ui.table.provider;

import java.util.ArrayList;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.egerrit.internal.core.EGerritCorePlugin;
import org.eclipse.egerrit.internal.core.GerritClient;
import org.eclipse.egerrit.internal.core.command.DeleteDraftRevisionCommand;
import org.eclipse.egerrit.internal.core.exception.EGerritException;
import org.eclipse.egerrit.internal.model.ChangeInfo;
import org.eclipse.egerrit.internal.model.ModelHelpers;
import org.eclipse.egerrit.internal.model.ModelPackage;
import org.eclipse.egerrit.internal.ui.editors.ModelLoader;
import org.eclipse.egerrit.internal.ui.tabs.ObservableCollector;
import org.eclipse.egerrit.internal.ui.utils.Messages;
import org.eclipse.emf.databinding.EMFProperties;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public class DeleteDraftRevisionProvider {
    private Button fDeleteDraftRevisionButton;
    private DataBindingContext bindingContext = new DataBindingContext();
    private ObservableCollector observableCollector;

    public void create(Composite parent, final GerritClient gerritClient, final ChangeInfo changeInfo) {
        this.fDeleteDraftRevisionButton = new Button(parent, 2048);
        this.fDeleteDraftRevisionButton.setText(Messages.DeleteDraft_Text);
        GridData gdDeleteDraft = new GridData(4, 128, false, false, 1, 1);
        this.fDeleteDraftRevisionButton.setLayoutData((Object)gdDeleteDraft);
        this.fDeleteDraftRevisionButton.setToolTipText(Messages.DeleteDraft_Tip);
        IObservableValue revisionInfoObserveValue = EMFProperties.value((EStructuralFeature)ModelPackage.Literals.CHANGE_INFO__USER_SELECTED_REVISION).value((EStructuralFeature)ModelPackage.Literals.REVISION_INFO__DELETEABLE).observe((Object)changeInfo);
        this.bindingContext.bindValue((IObservableValue)WidgetProperties.enabled().observe((Widget)this.fDeleteDraftRevisionButton), revisionInfoObserveValue, null, null);
        this.fDeleteDraftRevisionButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!MessageDialog.openConfirm((Shell)DeleteDraftRevisionProvider.this.fDeleteDraftRevisionButton.getParent().getShell(), (String)Messages.DeleteDraft_Dialogue_Title, (String)NLS.bind((String)Messages.DeleteDraft_Dialogue_Message, (Object)changeInfo.getUserSelectedRevision().get_number(), (Object)changeInfo.getSubject()))) {
                    return;
                }
                DeleteDraftRevisionCommand deleteDraftChangeCmd = gerritClient.deleteDraftRevision(changeInfo.getId(), changeInfo.getUserSelectedRevision().getId());
                try {
                    deleteDraftChangeCmd.call();
                    if (changeInfo.getRevisions().size() == 1) {
                        IWorkbench workbench = PlatformUI.getWorkbench();
                        IWorkbenchPage activePage = workbench.getActiveWorkbenchWindow().getActivePage();
                        IEditorPart editor = activePage.getActiveEditor();
                        activePage.closeEditor(editor, false);
                    } else {
                        ArrayList revisions = new ArrayList(changeInfo.getRevisions().values());
                        revisions.remove(changeInfo.getUserSelectedRevision());
                        changeInfo.setUserSelectedRevision(changeInfo.getRevisionByNumber(ModelHelpers.getHighestRevisionNumber(revisions)));
                        ModelLoader ml = ModelLoader.initialize(gerritClient, changeInfo);
                        ml.reload(false);
                        ml.dispose();
                    }
                }
                catch (EGerritException e1) {
                    EGerritCorePlugin.logError((String)(String.valueOf(gerritClient.getRepository().formatGerritVersion()) + e1.getMessage()));
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        this.observableCollector = new ObservableCollector(this.bindingContext);
    }

    public void dispose() {
        this.observableCollector.dispose();
        this.bindingContext.dispose();
    }
}

