/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.resources.team.ResourceRuleFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.GitMoveDeleteHook;
import org.eclipse.egit.core.internal.storage.GitFileHistoryProvider;
import org.eclipse.egit.core.project.GitProjectData;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;

public class GitProvider
extends RepositoryProvider {
    public static final String ID = "org.eclipse.egit.core.GitProvider";
    private GitProjectData data;
    private GitMoveDeleteHook hook;
    private GitFileHistoryProvider historyProvider;
    private final IResourceRuleFactory resourceRuleFactory = new GitResourceRuleFactory();

    public String getID() {
        return ID;
    }

    public void configureProject() throws CoreException {
        GitProjectData projectData = this.getData();
        if (projectData != null) {
            projectData.markTeamPrivateResources();
        }
    }

    public void deconfigure() throws CoreException {
        try {
            GitProjectData.deconfigure(this.getProject());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, Activator.getPluginId(), e.getMessage(), (Throwable)e));
        }
    }

    public boolean canHandleLinkedResources() {
        return true;
    }

    public boolean canHandleLinkedResourceURI() {
        return true;
    }

    public synchronized IMoveDeleteHook getMoveDeleteHook() {
        GitProjectData _data;
        if (this.hook == null && (_data = this.getData()) != null) {
            this.hook = new GitMoveDeleteHook(_data);
        }
        return this.hook;
    }

    @Nullable
    public synchronized GitProjectData getData() {
        IProject project;
        if (this.data == null && (project = this.getProject()) != null) {
            this.data = GitProjectData.get(project);
        }
        return this.data;
    }

    public synchronized IFileHistoryProvider getFileHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new GitFileHistoryProvider();
        }
        return this.historyProvider;
    }

    public IResourceRuleFactory getRuleFactory() {
        return this.resourceRuleFactory;
    }

    private static class GitResourceRuleFactory
    extends ResourceRuleFactory {
        private GitResourceRuleFactory() {
        }
    }
}

