/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.mapping;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.core.synchronize.GitSubscriberResourceMappingContext;
import org.eclipse.egit.core.synchronize.dto.GitSynchronizeDataSet;
import org.eclipse.egit.ui.internal.synchronize.mapping.GitObjectMapping;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;

class GitContainerMapping
extends GitObjectMapping {
    private static final IWorkspaceRoot ROOT = ResourcesPlugin.getWorkspace().getRoot();

    public GitContainerMapping(GitModelObjectContainer gitCommit) {
        super(gitCommit);
    }

    public ResourceTraversal[] getTraversals(ResourceMappingContext context, IProgressMonitor monitor) throws CoreException {
        GitModelObject[] children = ((GitModelObjectContainer)((Object)this.getModelObject())).getChildren();
        LinkedHashSet<ResourceTraversal> result = new LinkedHashSet<ResourceTraversal>();
        GitSynchronizeDataSet dataSet = context instanceof GitSubscriberResourceMappingContext ? ((GitSubscriberResourceMappingContext)context).getSyncData() : null;
        GitModelObject[] gitModelObjectArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            GitModelObject child = gitModelObjectArray[n2];
            if (child.isContainer()) {
                result.addAll(this.createTraversalForContainer(child, dataSet));
            } else {
                result.add(this.createTraversalForFile(child, dataSet));
            }
            ++n2;
        }
        return result.toArray(new ResourceTraversal[result.size()]);
    }

    private Set<ResourceTraversal> createTraversalForContainer(GitModelObject child, GitSynchronizeDataSet dataSet) {
        GitModelObject[] containerChildren = child.getChildren();
        LinkedHashSet<ResourceTraversal> result = new LinkedHashSet<ResourceTraversal>();
        GitModelObject[] gitModelObjectArray = containerChildren;
        int n = containerChildren.length;
        int n2 = 0;
        while (n2 < n) {
            GitModelObject aChild = gitModelObjectArray[n2];
            if (aChild.isContainer()) {
                result.addAll(this.createTraversalForContainer(aChild, dataSet));
            } else {
                ResourceTraversal traversal = this.createTraversalForFile(aChild, dataSet);
                if (traversal != null) {
                    result.add(traversal);
                }
            }
            ++n2;
        }
        return result;
    }

    private ResourceTraversal createTraversalForFile(GitModelObject aChild, GitSynchronizeDataSet dataSet) {
        IPath childLocation = aChild.getLocation();
        IFile file = ROOT.getFileForLocation(childLocation);
        if (file == null) {
            file = ROOT.getFile(childLocation);
        }
        ResourceTraversal traversal = null;
        if (dataSet == null) {
            traversal = new ResourceTraversal(new IResource[]{file}, 1, 16);
        } else if (file != null && dataSet.shouldBeIncluded((IResource)file)) {
            traversal = new ResourceTraversal(new IResource[]{file}, 1, 16);
        }
        return traversal;
    }
}

